/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.assemble;

import java.nio.file.Path;
import java.util.Objects;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.assemble.AssemblerProcessors;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.Assembler;
import org.jreleaser.model.spi.assemble.AssemblerProcessingException;
import org.jreleaser.model.spi.assemble.AssemblerProcessor;
import org.jreleaser.mustache.TemplateContext;

public class DistributionAssembler {
    private final JReleaserContext context;
    private final Assembler<?> assembler;
    private final Path outputDirectory;

    private DistributionAssembler(JReleaserContext context, Assembler<?> assembler) {
        this.context = context;
        this.assembler = assembler;
        this.outputDirectory = context.getOutputDirectory();
    }

    public Assembler<?> getAssembler() {
        return this.assembler;
    }

    public boolean assemble() throws AssemblerProcessingException {
        if (!this.assembler.isEnabled()) {
            this.context.getLogger().debug(RB.$((String)"assemblers.distribution.skip", (Object[])new Object[0]), new Object[]{this.assembler.getName()});
            return false;
        }
        AssemblerProcessor assemblerProcessor = AssemblerProcessors.findProcessor(this.context, this.assembler);
        this.context.getLogger().info(RB.$((String)"assemblers.distribution.assemble", (Object[])new Object[0]), new Object[]{this.assembler.getName()});
        assemblerProcessor.assemble(this.initProps());
        return true;
    }

    private TemplateContext initProps() {
        TemplateContext props = this.context.props();
        props.set("basedir", (Object)this.context.getBasedir());
        props.set("baseOutputDirectory", (Object)this.outputDirectory.getParent());
        props.set("outputDirectory", (Object)this.outputDirectory);
        props.set("assembleDirectory", (Object)this.context.getAssembleDirectory());
        props.set("distributionAssembleDirectory", (Object)this.context.getAssembleDirectory().resolve(this.assembler.getName()).resolve(this.assembler.getType()));
        return props;
    }

    public static DistributionAssemblerBuilder builder() {
        return new DistributionAssemblerBuilder();
    }

    public static class DistributionAssemblerBuilder {
        private JReleaserContext context;
        private Assembler<?> assembler;

        public DistributionAssemblerBuilder context(JReleaserContext context) {
            this.context = Objects.requireNonNull(context, "'context' must not be null");
            return this;
        }

        public DistributionAssemblerBuilder assembler(Assembler<?> assembler) {
            this.assembler = Objects.requireNonNull(assembler, "'assembler' must not be null");
            return this;
        }

        public DistributionAssembler build() {
            Objects.requireNonNull(this.context, "'context' must not be null");
            Objects.requireNonNull(this.assembler, "'assembler' must not be null");
            return new DistributionAssembler(this.context, this.assembler);
        }
    }
}

