/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.nio.file.Path;
import org.jreleaser.cli.AbstractPlatformAwareModelCommand;
import org.jreleaser.cli.Config;
import org.jreleaser.cli.Template;
import org.jreleaser.engine.context.ModelValidator;
import org.jreleaser.engine.templates.TemplateEvaluator;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import picocli.CommandLine;

@CommandLine.Command(name="eval")
public class TemplateEval
extends AbstractPlatformAwareModelCommand<Template> {
    @CommandLine.ArgGroup
    Config.Exclusive exclusive;
    @CommandLine.ArgGroup(multiplicity="1")
    Composite composite;
    @CommandLine.Option(names={"--target-directory"}, paramLabel="<directory>", required=true)
    Path targetDirectory;
    @CommandLine.Option(names={"-o", "--overwrite"})
    boolean overwrite;

    @Override
    protected void doExecute(JReleaserContext context) {
        ModelValidator.validate((JReleaserContext)context);
        if (null != this.composite.inputFile) {
            TemplateEvaluator.generateTemplate((JReleaserContext)context, (Path)this.composite.inputFile, (Path)context.relativizeToBasedir(this.targetDirectory), (boolean)this.overwrite);
        } else {
            TemplateEvaluator.generateTemplates((JReleaserContext)context, (Path)this.composite.inputDirectory, (Path)context.relativizeToBasedir(this.targetDirectory), (boolean)this.overwrite);
        }
        context.report();
    }

    @Override
    protected JReleaserContext.Mode getMode() {
        if (this.download()) {
            return JReleaserContext.Mode.DOWNLOAD;
        }
        if (this.assembly()) {
            return JReleaserContext.Mode.ASSEMBLE;
        }
        if (this.changelog()) {
            return JReleaserContext.Mode.CHANGELOG;
        }
        if (this.announce()) {
            return JReleaserContext.Mode.ANNOUNCE;
        }
        return JReleaserContext.Mode.CONFIG;
    }

    private boolean download() {
        return null != this.exclusive && this.exclusive.download;
    }

    private boolean assembly() {
        return null != this.exclusive && this.exclusive.assembly;
    }

    private boolean changelog() {
        return null != this.exclusive && this.exclusive.changelog;
    }

    private boolean announce() {
        return null != this.exclusive && this.exclusive.announce;
    }

    @Override
    protected JReleaserCommand getCommand() {
        return JReleaserCommand.CONFIG;
    }

    static class Composite {
        @CommandLine.Option(names={"--input-file"}, paramLabel="<file>")
        Path inputFile;
        @CommandLine.Option(names={"--input-directory"}, paramLabel="<directory>")
        Path inputDirectory;

        Composite() {
        }
    }

    static class Exclusive {
        @CommandLine.Option(names={"--announce"}, required=true)
        boolean announce;
        @CommandLine.Option(names={"--assembly"}, required=true)
        boolean assembly;
        @CommandLine.Option(names={"--changelog"}, required=true)
        boolean changelog;
        @CommandLine.Option(names={"--download"}, required=true)
        boolean download;

        Exclusive() {
        }
    }
}

