/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.bluesky;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jreleaser.sdk.bluesky.api.BlueskyAPI;
import org.jreleaser.sdk.bluesky.api.CreateRecordResponse;
import org.jreleaser.sdk.bluesky.api.CreateTextRecordRequest;
import org.jreleaser.sdk.bluesky.api.Facet;
import org.jreleaser.sdk.bluesky.api.Index;
import org.jreleaser.sdk.bluesky.api.ResolveHandleResponse;
import org.jreleaser.sdk.bluesky.api.features.Feature;
import org.jreleaser.sdk.bluesky.api.features.LinkFeature;
import org.jreleaser.sdk.bluesky.api.features.MentionFeature;
import org.jreleaser.sdk.bluesky.api.features.TagFeature;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.util.StringUtils;

public class BlueskyRecordFactory {
    private static final Pattern URL_PATTERN = Pattern.compile("(?:^|[\\W])((ht|f)tp(s?):\\/\\/|www\\.)(([\\w\\-]+\\.){1,}?([\\w\\-.~]+\\/?)*[\\p{Alnum}.,%_=?&#\\-+()\\[\\]\\*$~@!:/{};']*)", 42);
    private static final Pattern TAG_PATTERN = Pattern.compile("(#[a-zA-Z]{2,})");
    private static final Pattern MENTION_PATTERN = Pattern.compile("(^|\\s|\\()(@)([a-zA-Z0-9.-]+)(\\b)");
    private final BlueskyAPI api;

    public BlueskyRecordFactory(BlueskyAPI api) {
        this.api = api;
    }

    public CreateTextRecordRequest textRecord(String repo, String text) {
        CreateTextRecordRequest request = new CreateTextRecordRequest();
        request.setRepo(StringUtils.requireNonBlank((String)repo, (String)"'repo' must not be blank").trim());
        CreateTextRecordRequest.TextRecord textRecord = new CreateTextRecordRequest.TextRecord();
        textRecord.setText(StringUtils.requireNonBlank((String)text, (String)"'text' must not be blank").trim());
        textRecord.setCreatedAt(Instant.now().toString());
        request.setRecord(textRecord);
        textRecord.setFacets(this.determineFacets(text));
        return request;
    }

    public CreateTextRecordRequest textRecord(String repo, String text, CreateRecordResponse root, CreateRecordResponse parent) {
        CreateTextRecordRequest request = this.textRecord(repo, text);
        CreateTextRecordRequest.ReplyReference reply = new CreateTextRecordRequest.ReplyReference();
        reply.setRoot(root);
        reply.setParent(parent);
        request.getRecord().setReply(reply);
        return request;
    }

    public List<Facet> determineFacets(String text) {
        ArrayList<Facet> facets = new ArrayList<Facet>();
        facets.addAll(BlueskyRecordFactory.parseFeatures(text, URL_PATTERN, link -> {
            LinkFeature linkFeature = new LinkFeature();
            linkFeature.setUri((String)link);
            return Optional.of(linkFeature);
        }));
        facets.addAll(BlueskyRecordFactory.parseFeatures(text, TAG_PATTERN, tag -> {
            TagFeature tagFeature = new TagFeature();
            tagFeature.setTag(tag.replace("#", "").trim());
            return Optional.of(tagFeature);
        }));
        facets.addAll(BlueskyRecordFactory.parseFeatures(text, MENTION_PATTERN, mention -> {
            String handle = mention.replace("@", "").trim();
            MentionFeature mentionFeature = new MentionFeature();
            try {
                ResolveHandleResponse handleResponse = this.api.resolveHandle(handle);
                mentionFeature.setDid(handleResponse.getDid());
            }
            catch (RestAPIException e) {
                return Optional.empty();
            }
            return Optional.of(mentionFeature);
        }));
        return facets;
    }

    private static List<Facet> parseFeatures(String text, Pattern pattern, Function<String, Optional<Feature>> matchedContentToFeature) {
        BlueskyStringEncodingWrapper wrapper = new BlueskyStringEncodingWrapper(text);
        Matcher matcher = pattern.matcher(wrapper);
        ArrayList<Facet> urlFacets = new ArrayList<Facet>();
        while (matcher.find()) {
            int matchStart = matcher.start(1);
            int matchEnd = matcher.end();
            Facet facet = new Facet();
            Index index = new Index();
            index.setByteStart(matchStart);
            index.setByteEnd(matchEnd);
            facet.setIndex(index);
            String matchedSubstring = wrapper.subSequence(matchStart, matchEnd).toString();
            matchedContentToFeature.apply(matchedSubstring).ifPresent(feature -> {
                facet.setFeatures(Collections.singletonList(feature));
                urlFacets.add(facet);
            });
        }
        return urlFacets;
    }

    public static class BlueskyStringEncodingWrapper
    implements CharSequence {
        private final ByteBuffer buffer;
        private final Charset charset = StandardCharsets.UTF_8;

        public BlueskyStringEncodingWrapper(String sourceString) {
            this.buffer = ByteBuffer.wrap(sourceString.getBytes(this.charset));
        }

        private BlueskyStringEncodingWrapper(ByteBuffer sourceBuffer) {
            this.buffer = sourceBuffer;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            ByteBuffer buffer = this.buffer.duplicate();
            buffer.position(buffer.position() + start);
            buffer.limit(buffer.position() + (end - start));
            return new BlueskyStringEncodingWrapper(buffer);
        }

        @Override
        public int length() {
            return this.buffer.limit();
        }

        @Override
        public char charAt(int index) {
            return (char)this.buffer.get(index);
        }

        @Override
        public String toString() {
            return this.charset.decode(this.buffer.duplicate()).toString();
        }
    }
}

