/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.assemble;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.assemble.DistributionAssembler;
import org.jreleaser.extensions.api.workflow.WorkflowListenerException;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.api.hooks.ExecutionEvent;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserSupport;
import org.jreleaser.model.internal.assemble.Assemble;
import org.jreleaser.model.internal.assemble.Assembler;
import org.jreleaser.model.spi.assemble.AssemblerProcessingException;

public final class Assemblers {
    private Assemblers() {
    }

    public static void assemble(JReleaserContext context) {
        context.getLogger().info(RB.$((String)"assemblers.header", (Object[])new Object[0]));
        context.getLogger().increaseIndent();
        context.getLogger().setPrefix("assemble");
        Assemble assemble = context.getModel().getAssemble();
        if (!assemble.isEnabled()) {
            context.getLogger().info(RB.$((String)"assemblers.not.enabled", (Object[])new Object[0]));
            context.getLogger().restorePrefix();
            return;
        }
        try {
            Assemblers.doAssemble(context, assemble);
        }
        finally {
            context.getLogger().decreaseIndent();
            context.getLogger().restorePrefix();
        }
    }

    private static void doAssemble(JReleaserContext context, Assemble assemble) {
        if (!context.getIncludedAssemblers().isEmpty()) {
            for (String assemblerType : context.getIncludedAssemblers()) {
                if (!JReleaserSupport.supportedAssemblers().contains(assemblerType)) {
                    context.getLogger().warn(RB.$((String)"ERROR_unsupported_assembler", (Object[])new Object[]{assemblerType}));
                    continue;
                }
                Map assemblers = assemble.findAssemblersByType(assemblerType);
                if (assemblers.isEmpty()) {
                    context.getLogger().info(RB.$((String)"assemblers.no.match", (Object[])new Object[0]), new Object[]{assemblerType});
                    return;
                }
                if (!context.getIncludedDistributions().isEmpty()) {
                    for (String distributionName : context.getIncludedDistributions()) {
                        boolean[] assembled = new boolean[]{false};
                        if (!assemblers.containsKey(distributionName)) {
                            context.getLogger().error(RB.$((String)"assemblers.distribution.not.configured", (Object[])new Object[0]), new Object[]{assemblerType, distributionName});
                            continue;
                        }
                        assemble.findAllAssemblers().stream().filter(a -> distributionName.equals(a.getName())).peek(assembler -> context.getLogger().info(RB.$((String)"assemblers.assemble.distribution.with", (Object[])new Object[0]), new Object[]{distributionName, assembler.getName()})).forEach(assembler -> {
                            if (Assemblers.assemble(context, assembler)) {
                                assembled[0] = true;
                            }
                        });
                        if (assembled[0]) continue;
                        context.getLogger().info(RB.$((String)"assemblers.not.triggered", (Object[])new Object[0]));
                    }
                    continue;
                }
                context.getLogger().info(RB.$((String)"assemblers.assemble.all.distributions.with", (Object[])new Object[0]), new Object[]{assemblerType});
                boolean[] assembled = new boolean[]{false};
                assemblers.values().forEach(assembler -> {
                    if (Assemblers.assemble(context, assembler)) {
                        assembled[0] = true;
                    }
                });
                if (assembled[0]) continue;
                context.getLogger().info(RB.$((String)"assemblers.not.triggered", (Object[])new Object[0]));
            }
        } else if (!context.getIncludedDistributions().isEmpty()) {
            for (String distributionName : context.getIncludedDistributions()) {
                context.getLogger().info(RB.$((String)"assemblers.assemble.distribution.with.all", (Object[])new Object[0]), new Object[]{distributionName});
                boolean[] assembled = new boolean[]{false};
                assemble.findAllAssemblers().stream().filter(a -> distributionName.equals(a.getName())).forEach(assembler -> {
                    if (Assemblers.assemble(context, assembler)) {
                        assembled[0] = true;
                    }
                });
                if (assembled[0]) continue;
                context.getLogger().info(RB.$((String)"assemblers.not.triggered", (Object[])new Object[0]));
            }
        } else {
            context.getLogger().info(RB.$((String)"assemblers.assemble.all.distributions", (Object[])new Object[0]));
            boolean assembled = false;
            for (Assembler assembler2 : assemble.findAllAssemblers()) {
                String assemblerType = assembler2.getType();
                String distributionName = assembler2.getName();
                if (context.getExcludedAssemblers().contains(assemblerType) || context.getExcludedDistributions().contains(distributionName)) {
                    context.getLogger().info(RB.$((String)"assemblers.assembler.excluded", (Object[])new Object[0]), new Object[]{assemblerType, distributionName});
                    continue;
                }
                if (!Assemblers.assemble(context, assembler2)) continue;
                assembled = true;
            }
            if (!assembled) {
                context.getLogger().info(RB.$((String)"assemblers.not.triggered", (Object[])new Object[0]));
            }
        }
    }

    private static boolean assemble(JReleaserContext context, Assembler<?> assembler) {
        try {
            context.getLogger().increaseIndent();
            context.getLogger().setPrefix(assembler.getType());
            Assemblers.fireAssembleEvent(ExecutionEvent.before((String)JReleaserCommand.ASSEMBLE.toStep()), context, assembler);
            DistributionAssembler processor = Assemblers.createDistributionAssembler(context, assembler);
            boolean assembled = processor.assemble();
            Assemblers.fireAssembleEvent(ExecutionEvent.success((String)JReleaserCommand.ASSEMBLE.toStep()), context, assembler);
            boolean bl = assembled;
            return bl;
        }
        catch (AssemblerProcessingException e) {
            Assemblers.fireAssembleEvent(ExecutionEvent.failure((String)JReleaserCommand.ASSEMBLE.toStep(), (Throwable)e), context, assembler);
            throw new JReleaserException(e.getMessage(), (Throwable)e);
        }
        finally {
            context.getLogger().restorePrefix();
            context.getLogger().decreaseIndent();
        }
    }

    private static DistributionAssembler createDistributionAssembler(JReleaserContext context, Assembler<?> assembler) {
        return DistributionAssembler.builder().context(context).assembler(assembler).build();
    }

    private static void fireAssembleEvent(ExecutionEvent event, JReleaserContext context, Assembler<?> assembler) {
        block4: {
            if (!assembler.isEnabled()) {
                return;
            }
            try {
                context.fireAssembleStepEvent(event, assembler.asImmutable());
            }
            catch (WorkflowListenerException e) {
                context.getLogger().error(RB.$((String)"listener.failure", (Object[])new Object[]{e.getListener().getClass().getName()}));
                context.getLogger().trace((Throwable)e);
                if (event.getType() == ExecutionEvent.Type.FAILURE || e.getListener().isContinueOnError()) break block4;
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), e.getCause());
            }
        }
    }
}

