/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Upload;
import org.jreleaser.model.validation.ArtifactoryValidator;
import org.jreleaser.model.validation.FtpUploaderValidator;
import org.jreleaser.model.validation.HttpUploaderValidator;
import org.jreleaser.model.validation.S3Validator;
import org.jreleaser.model.validation.ScpUploaderValidator;
import org.jreleaser.model.validation.SftpUploaderValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;

public abstract class UploadersValidator
extends Validator {
    public static void validateUploaders(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("upload");
        Upload upload = context.getModel().getUpload();
        ArtifactoryValidator.validateArtifactory(context, mode, errors);
        FtpUploaderValidator.validateFtpUploader(context, mode, errors);
        HttpUploaderValidator.validateHttpUploader(context, mode, errors);
        S3Validator.validateS3(context, mode, errors);
        ScpUploaderValidator.validateScpUploader(context, mode, errors);
        SftpUploaderValidator.validateSftpUploader(context, mode, errors);
        boolean activeSet = upload.isActiveSet();
        if (mode.validateConfig()) {
            upload.resolveEnabled(context.getModel().getProject());
        }
        if (mode.validateConfig() && upload.isEnabled()) {
            boolean enabled;
            boolean bl = enabled = !upload.getActiveArtifactories().isEmpty() || !upload.getActiveFtps().isEmpty() || !upload.getActiveHttps().isEmpty() || !upload.getActiveS3s().isEmpty() || !upload.getActiveScps().isEmpty() || !upload.getActiveSftps().isEmpty();
            if (!activeSet && !enabled) {
                upload.disable();
            }
        }
    }
}

