/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.Packagers;
import org.jreleaser.model.Project;
import org.jreleaser.model.RepositoryPackager;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.model.Sdkman;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class PackagersValidator
extends Validator {
    public static void validatePackagers(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        if (!mode.validateConfig()) {
            return;
        }
        context.getLogger().debug("packagers");
        JReleaserModel model = context.getModel();
        Packagers packagers = model.getPackagers();
        Project project = model.getProject();
        packagers.getBrew().resolveEnabled(project);
        packagers.getBrew().getTap().resolveEnabled(project);
        PackagersValidator.validatePackager(context, packagers.getBrew(), packagers.getBrew().getTap(), errors);
        packagers.getChocolatey().resolveEnabled(project);
        packagers.getChocolatey().getBucket().resolveEnabled(project);
        PackagersValidator.validatePackager(context, packagers.getChocolatey(), packagers.getChocolatey().getBucket(), errors);
        packagers.getDocker().resolveEnabled(project);
        packagers.getDocker().getRepository().resolveEnabled(project);
        PackagersValidator.validatePackager(context, packagers.getDocker(), packagers.getDocker().getRepository(), errors);
        if (!packagers.getDocker().getSpecs().isEmpty()) {
            errors.configuration(RB.$((String)"validation_packagers_docker_specs", (Object[])new Object[0]));
        }
        packagers.getGofish().resolveEnabled(project);
        packagers.getGofish().getRepository().resolveEnabled(project);
        PackagersValidator.validatePackager(context, packagers.getGofish(), packagers.getGofish().getRepository(), errors);
        if (StringUtils.isBlank((String)packagers.getGofish().getRepository().getName())) {
            packagers.getGofish().getRepository().setName(model.getRelease().getGitService().getOwner() + "-fish-food");
        }
        packagers.getGofish().getRepository().setTapName(model.getRelease().getGitService().getOwner() + "-fish-food");
        packagers.getJbang().resolveEnabled(project);
        packagers.getJbang().getCatalog().resolveEnabled(project);
        PackagersValidator.validatePackager(context, packagers.getJbang(), packagers.getJbang().getCatalog(), errors);
        packagers.getMacports().resolveEnabled(project);
        packagers.getMacports().getRepository().resolveEnabled(project);
        PackagersValidator.validatePackager(context, packagers.getMacports(), packagers.getMacports().getRepository(), errors);
        packagers.getScoop().resolveEnabled(project);
        packagers.getScoop().getBucket().resolveEnabled(project);
        PackagersValidator.validatePackager(context, packagers.getScoop(), packagers.getScoop().getBucket(), errors);
        if (StringUtils.isBlank((String)packagers.getScoop().getBucket().getName())) {
            packagers.getScoop().getBucket().setName("scoop-" + model.getRelease().getGitService().getOwner());
        }
        packagers.getScoop().getBucket().setTapName("scoop-" + model.getRelease().getGitService().getOwner());
        packagers.getSnap().resolveEnabled(project);
        packagers.getSnap().getSnap().resolveEnabled(project);
        PackagersValidator.validatePackager(context, packagers.getSnap(), packagers.getSnap().getSnap(), errors);
        packagers.getSpec().resolveEnabled(project);
        packagers.getSpec().getRepository().resolveEnabled(project);
        PackagersValidator.validatePackager(context, packagers.getSpec(), packagers.getSpec().getRepository(), errors);
        if (StringUtils.isBlank((String)packagers.getSpec().getRepository().getName())) {
            packagers.getSpec().getRepository().setName(model.getRelease().getGitService().getOwner() + "-spec");
        }
        packagers.getSpec().getRepository().setTapName(model.getRelease().getGitService().getOwner() + "-spec");
        PackagersValidator.validateSdkman(context, packagers.getSdkman(), errors);
    }

    private static void validateSdkman(JReleaserContext context, Sdkman packager, Errors errors) {
        packager.resolveEnabled(context.getModel().getProject());
        PackagersValidator.validateTimeout(packager);
    }

    private static void validatePackager(JReleaserContext context, RepositoryPackager packager, RepositoryTap tap, Errors errors) {
        GitService service = context.getModel().getRelease().getGitService();
        PackagersValidator.validateCommitAuthor(packager, service);
        PackagersValidator.validateOwner(tap, service);
        tap.setUsername(PackagersValidator.checkProperty(context, Env.toVar((String)(tap.getBasename() + "_" + service.getServiceName())) + "_USERNAME", "<empty>", tap.getUsername(), service.getResolvedUsername()));
        tap.setToken(PackagersValidator.checkProperty(context, Env.toVar((String)(tap.getBasename() + "_" + service.getServiceName())) + "_TOKEN", "<empty>", tap.getToken(), service.getResolvedToken()));
        if (StringUtils.isBlank((String)tap.getTagName())) {
            tap.setTagName(service.getTagName());
        }
        if (StringUtils.isBlank((String)tap.getBranch())) {
            tap.setBranch("HEAD");
        }
    }
}

