/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Downloader;
import org.jreleaser.model.HttpDownloader;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class HttpDownloaderValidator
extends Validator {
    public static void validateHttpDownloader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("http");
        Map<String, HttpDownloader> http = context.getModel().getDownload().getHttp();
        for (Map.Entry<String, HttpDownloader> e : http.entrySet()) {
            e.getValue().setName(e.getKey());
            HttpDownloaderValidator.validateHttp(context, mode, e.getValue(), errors);
        }
    }

    private static void validateHttp(JReleaserContext context, JReleaserContext.Mode mode, HttpDownloader http, Errors errors) {
        context.getLogger().debug("http.{}", new Object[]{http.getName()});
        if (!http.isActiveSet()) {
            http.setActive(Active.ALWAYS);
        }
        if (!http.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        switch (http.resolveAuthorization()) {
            case BEARER: {
                http.setPassword(HttpDownloaderValidator.checkProperty(context, "HTTP_" + Env.toVar((String)http.getName()) + "_PASSWORD", "http.password", http.getPassword(), errors, context.isDryrun()));
                break;
            }
            case BASIC: {
                http.setUsername(HttpDownloaderValidator.checkProperty(context, "HTTP_" + Env.toVar((String)http.getName()) + "_USERNAME", "http.username", http.getUsername(), errors, context.isDryrun()));
                http.setPassword(HttpDownloaderValidator.checkProperty(context, "HTTP_" + Env.toVar((String)http.getName()) + "_PASSWORD", "http.password", http.getPassword(), errors, context.isDryrun()));
                break;
            }
        }
        HttpDownloaderValidator.validateTimeout(http);
        if (http.getAssets().isEmpty()) {
            errors.configuration(RB.$((String)"validation_must_not_be_empty", (Object[])new Object[]{"http." + http.getName() + ".assets"}));
        } else {
            int index = 0;
            for (Downloader.Asset asset : http.getAssets()) {
                if (!StringUtils.isBlank((String)asset.getInput())) continue;
                errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{"http." + http.getName() + ".asset[" + index++ + "].input"}));
            }
        }
    }
}

