/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Archive;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.FileSet;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class ArchiveValidator
extends Validator {
    public static void validateArchive(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("archive");
        Map<String, Archive> archive = context.getModel().getAssemble().getArchive();
        for (Map.Entry<String, Archive> e : archive.entrySet()) {
            e.getValue().setName(e.getKey());
            ArchiveValidator.validateArchive(context, mode, e.getValue(), errors);
        }
    }

    private static void validateArchive(JReleaserContext context, JReleaserContext.Mode mode, Archive archive, Errors errors) {
        context.getLogger().debug("archive.{}", new Object[]{archive.getName()});
        if (!archive.isActiveSet()) {
            archive.setActive(Active.NEVER);
        }
        if (!archive.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        if (StringUtils.isBlank((String)archive.getName())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"archive.name"}));
            return;
        }
        archive.setPlatform(archive.getPlatform().mergeValues(context.getModel().getPlatform()));
        if (null == archive.getDistributionType()) {
            archive.setDistributionType(Distribution.DistributionType.BINARY);
        }
        if (StringUtils.isBlank((String)archive.getArchiveName())) {
            archive.setArchiveName("{{distributionName}}-{{projectVersion}}");
        }
        if (archive.getFormats().isEmpty()) {
            archive.addFormat(Archive.Format.ZIP);
        }
        if (archive.getFileSets().isEmpty()) {
            errors.configuration(RB.$((String)"validation_archive_empty_fileset", (Object[])new Object[]{archive.getName()}));
        } else {
            int i = 0;
            for (FileSet fileSet : archive.getFileSets()) {
                ArchiveValidator.validateFileSet(context, mode, archive, fileSet, i++, errors);
            }
        }
    }
}

