/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.tool;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.sdk.tool.AbstractTool;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.command.Command;
import org.jreleaser.util.command.CommandException;
import org.jreleaser.util.command.CommandExecutor;
import org.jreleaser.util.signing.SigningException;

public class Cosign
extends AbstractTool {
    public Cosign(JReleaserContext context, String version) {
        super(context, "cosign", version, true);
    }

    public boolean checkPassword(Path keyFile, byte[] password) {
        ByteArrayInputStream in = new ByteArrayInputStream(password);
        Command command = this.tool.asCommand().arg("public-key").arg("--key").arg(keyFile.toAbsolutePath().toString());
        try {
            this.executeCommand(() -> new CommandExecutor(this.context.getLogger(), true).executeCommandWithInput(command, (InputStream)in));
            return true;
        }
        catch (CommandException e) {
            this.context.getLogger().debug(RB.$((String)"ERROR_password_incorrect", (Object[])new Object[0]));
            return false;
        }
    }

    public Path generateKeyPair(byte[] password) throws SigningException {
        Command command = this.tool.asCommand().arg("generate-key-pair");
        Path homeDir = this.resolveJReleaserHomeDir();
        try {
            this.executeCommand(() -> new CommandExecutor(this.context.getLogger(), true).environment("COSIGN_PASSWORD", new String(password)).executeCommand(homeDir, command));
        }
        catch (CommandException e) {
            throw new SigningException(RB.$((String)"ERROR_unexpected_generate_key_pair", (Object[])new Object[0]), (Throwable)e);
        }
        this.context.getLogger().info(RB.$((String)"cosign.generated.keys.at", (Object[])new Object[0]), new Object[]{homeDir.toAbsolutePath()});
        return homeDir.resolve("cosign.key");
    }

    public void signBlob(Path keyFile, byte[] password, Path input, Path destinationDir) throws SigningException {
        this.context.getLogger().info("{}", new Object[]{this.context.relativizeToBasedir(input)});
        ByteArrayInputStream in = new ByteArrayInputStream(password);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Command command = this.tool.asCommand().arg("sign-blob").arg("--key").arg(keyFile.toAbsolutePath().toString()).arg(input.toAbsolutePath().toString());
        try {
            this.executeCommand(() -> new CommandExecutor(this.context.getLogger(), true).executeCommandWithInputCapturing(command, (InputStream)in, (OutputStream)out));
        }
        catch (CommandException e) {
            throw new SigningException(RB.$((String)"ERROR_unexpected_error_signing", (Object[])new Object[]{input.toAbsolutePath()}), (Throwable)e);
        }
        try {
            Path signature = destinationDir.resolve(input.getFileName() + ".sig");
            Files.write(signature, out.toByteArray(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new SigningException(RB.$((String)"ERROR_unexpected_error_signing", (Object[])new Object[]{input}), (Throwable)e);
        }
    }

    public void verifyBlob(Path keyFile, Path signature, Path input) throws SigningException {
        this.context.getLogger().debug("{}", new Object[]{this.context.relativizeToBasedir(signature)});
        Command command = this.tool.asCommand().arg("verify-blob").arg("--key").arg(keyFile.toAbsolutePath().toString()).arg("--signature").arg(signature.toAbsolutePath().toString()).arg(input.toAbsolutePath().toString());
        try {
            this.executeCommand(() -> new CommandExecutor(this.context.getLogger(), true).executeCommand(command));
        }
        catch (CommandException e) {
            throw new SigningException(RB.$((String)"ERROR_signing_verify_signature", (Object[])new Object[]{this.context.relativizeToBasedir(signature)}), (Throwable)e);
        }
    }

    private Path resolveJReleaserHomeDir() {
        String home = System.getenv("JRELEASER_USER_HOME");
        if (StringUtils.isBlank((String)home)) {
            home = System.getProperty("user.home") + File.separator + ".jreleaser";
        }
        return Paths.get(home, new String[0]);
    }
}

