/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.tool;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.sdk.tool.DownloadableTool;
import org.jreleaser.sdk.tool.ToolException;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.command.CommandException;

public class AbstractTool {
    protected final JReleaserContext context;
    protected final DownloadableTool tool;
    protected final String name;

    public AbstractTool(JReleaserContext context, String name, String version) {
        StringUtils.requireNonBlank((String)version, (String)"'version' must not be blank");
        this.name = StringUtils.requireNonBlank((String)name, (String)"'name' must not be blank");
        this.context = context;
        this.tool = new DownloadableTool(context.getLogger(), name, version, PlatformUtils.getCurrentFull());
    }

    public boolean setup() throws ToolException {
        if (!this.tool.verify()) {
            if (this.tool.isEnabled()) {
                try {
                    this.tool.download();
                }
                catch (Exception e) {
                    throw new ToolException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), e);
                }
                if (this.tool.verify()) {
                    return true;
                }
            }
            this.context.getLogger().warn(RB.$((String)"tool_verify_error", (Object[])new Object[]{this.name, this.tool.getVersion()}));
            return false;
        }
        return true;
    }

    protected void executeCommand(CommandExecution execution) throws CommandException {
        int exitValue = execution.execute();
        if (exitValue != 0) {
            throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{exitValue}));
        }
    }

    static interface CommandExecution {
        public int execute() throws CommandException;
    }
}

