/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jreleaser.util.StringUtils;

public enum FileType {
    ASC("asc"),
    DEB("deb"),
    DMG("dmg"),
    EXE("exe"),
    JAR("jar"),
    MSI("msi"),
    NUGET("nuget"),
    PKG("pkg"),
    RPM("rpm"),
    SIG("sig"),
    TAR("tar"),
    TAR_BZ2("tar.bz2"),
    TAR_GZ("tar.gz"),
    TAR_XZ("tar.xz"),
    TBZ2("tbz2"),
    TGZ("tgz"),
    TXZ("txz"),
    ZIP("zip");

    private final String type;

    private FileType(String type) {
        this.type = type;
    }

    public String type() {
        return this.type;
    }

    public String extension() {
        return "." + this.type;
    }

    public String toString() {
        return this.type();
    }

    public static FileType of(String str) {
        if (StringUtils.isBlank(str)) {
            return null;
        }
        return FileType.valueOf(str.toUpperCase().trim().replace(".", "_"));
    }

    public static Set<String> getSupportedTypes() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (FileType value : FileType.values()) {
            set.add(value.type());
        }
        return set;
    }

    public static Set<String> getSupportedExtensions() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (FileType value : FileType.values()) {
            set.add(value.extension());
        }
        return set;
    }

    public static String getFileType(Path path) {
        if (null != path) {
            return FileType.getFileType(path.getFileName().toString());
        }
        return "";
    }

    public static String getFileType(String path) {
        if (StringUtils.isBlank(path)) {
            return "";
        }
        for (FileType value : FileType.values()) {
            if (!path.endsWith(value.extension())) continue;
            return value.type();
        }
        return "";
    }

    public static String getFileNameExtension(Path path) {
        if (null != path) {
            return FileType.getFileNameExtension(path.getFileName().toString());
        }
        return "";
    }

    public static String getFileNameExtension(String path) {
        if (StringUtils.isBlank(path)) {
            return "";
        }
        for (FileType value : FileType.values()) {
            if (!path.endsWith(value.extension())) continue;
            return value.extension();
        }
        return "";
    }
}

