/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jreleaser.model.AbstractJavaAssembler;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Domain;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.Templates;

public class Jpackage
extends AbstractJavaAssembler {
    public static final String TYPE = "jpackage";
    private final Set<Artifact> runtimeImages = new LinkedHashSet<Artifact>();
    private final ApplicationPackage applicationPackage = new ApplicationPackage();
    private final Launcher launcher = new Launcher();
    private final Linux linux = new Linux();
    private final Windows windows = new Windows();
    private final Osx osx = new Osx();
    private String jlink;
    private Boolean attachPlatform;
    private Boolean verbose;

    public Jpackage() {
        super(TYPE);
    }

    @Override
    public Distribution.DistributionType getDistributionType() {
        return Distribution.DistributionType.NATIVE_PACKAGE;
    }

    void setAll(Jpackage jpackage) {
        super.setAll(jpackage);
        this.jlink = jpackage.jlink;
        this.attachPlatform = jpackage.attachPlatform;
        this.verbose = jpackage.verbose;
        this.setRuntimeImages(jpackage.runtimeImages);
        this.setApplicationPackage(jpackage.applicationPackage);
        this.setLauncher(jpackage.launcher);
        this.setLinux(jpackage.linux);
        this.setWindows(jpackage.windows);
        this.setOsx(jpackage.osx);
    }

    public String getJlink() {
        return this.jlink;
    }

    public void setJlink(String jlink) {
        this.jlink = jlink;
    }

    public boolean isAttachPlatformSet() {
        return this.attachPlatform != null;
    }

    public boolean isAttachPlatform() {
        return this.attachPlatform != null && this.attachPlatform != false;
    }

    public void setAttachPlatform(Boolean attachPlatform) {
        this.attachPlatform = attachPlatform;
    }

    public boolean isVerboseSet() {
        return this.verbose != null;
    }

    public boolean isVerbose() {
        return this.verbose != null && this.verbose != false;
    }

    public void setVerbose(Boolean verbose) {
        this.verbose = verbose;
    }

    public Set<Artifact> getRuntimeImages() {
        return Artifact.sortArtifacts(this.runtimeImages);
    }

    public void setRuntimeImages(Set<Artifact> runtimeImages) {
        this.runtimeImages.clear();
        this.runtimeImages.addAll(runtimeImages);
    }

    public void addRuntimeImages(Set<Artifact> runtimeImages) {
        this.runtimeImages.addAll(runtimeImages);
    }

    public void addRuntimeImage(Artifact jdk) {
        if (null != jdk) {
            this.runtimeImages.add(jdk);
        }
    }

    public Optional<Artifact> findRuntimeImageByPlatform(String platform) {
        return this.runtimeImages.stream().filter(ri -> ri.getPlatform().equals(platform)).findFirst();
    }

    public ApplicationPackage getApplicationPackage() {
        return this.applicationPackage;
    }

    public void setApplicationPackage(ApplicationPackage applicationPackage) {
        this.applicationPackage.setAll(applicationPackage);
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    public void setLauncher(Launcher launcher) {
        this.launcher.setAll(launcher);
    }

    public Linux getLinux() {
        return this.linux;
    }

    public void setLinux(Linux linux) {
        this.linux.setAll(linux);
    }

    public Windows getWindows() {
        return this.windows;
    }

    public void setWindows(Windows windows) {
        this.windows.setAll(windows);
    }

    public Osx getOsx() {
        return this.osx;
    }

    public void setOsx(Osx osx) {
        this.osx.setAll(osx);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("jlink", this.jlink);
        props.put("attachPlatform", this.isAttachPlatform());
        LinkedHashMap<String, Map<String, Object>> mapped = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (Artifact runtimeImage : this.getRuntimeImages()) {
            mapped.put("runtimeImage " + i++, runtimeImage.asMap(full));
        }
        props.put("runtimeImages", mapped);
        if (this.launcher.isSet()) {
            props.put("launcher", this.launcher.asMap(full));
        }
        props.put("applicationPackage", this.applicationPackage.asMap(full));
        props.putAll(this.linux.asMap(full));
        props.putAll(this.osx.asMap(full));
        props.putAll(this.windows.asMap(full));
    }

    public PlatformPackager getResolvedPlatformPackager() {
        String currentPlatform = PlatformUtils.getCurrentFull();
        if (PlatformUtils.isMac((String)currentPlatform)) {
            return this.getOsx();
        }
        if (PlatformUtils.isWindows((String)currentPlatform)) {
            return this.getWindows();
        }
        return this.getLinux();
    }

    public Set<PlatformPackager> getPlatformPackagers() {
        return CollectionUtils.newSet((Object[])new PlatformPackager[]{this.osx, this.linux, this.windows});
    }

    public static class Osx
    extends AbstractPlatformPackager {
        private String packageIdentifier;
        private String packageName;
        private String packageSigningPrefix;
        private String signingKeychain;
        private String signingKeyUsername;
        private boolean sign;

        public Osx() {
            super("osx", Arrays.asList("dmg", "pkg"));
        }

        void setAll(Osx packager) {
            super.setAll(packager);
            this.packageIdentifier = packager.packageIdentifier;
            this.packageName = packager.packageName;
            this.packageSigningPrefix = packager.packageSigningPrefix;
            this.signingKeychain = packager.signingKeychain;
            this.signingKeyUsername = packager.signingKeyUsername;
            this.sign = packager.sign;
        }

        public String getPackageIdentifier() {
            return this.packageIdentifier;
        }

        public void setPackageIdentifier(String packageIdentifier) {
            this.packageIdentifier = packageIdentifier;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getPackageSigningPrefix() {
            return this.packageSigningPrefix;
        }

        public void setPackageSigningPrefix(String packageSigningPrefix) {
            this.packageSigningPrefix = packageSigningPrefix;
        }

        public String getSigningKeychain() {
            return this.signingKeychain;
        }

        public void setSigningKeychain(String signingKeychain) {
            this.signingKeychain = signingKeychain;
        }

        public String getSigningKeyUsername() {
            return this.signingKeyUsername;
        }

        public void setSigningKeyUsername(String signingKeyUsername) {
            this.signingKeyUsername = signingKeyUsername;
        }

        public boolean isSign() {
            return this.sign;
        }

        public void setSign(boolean sign) {
            this.sign = sign;
        }

        @Override
        protected void asMap(boolean full, Map<String, Object> props) {
            props.put("packageIdentifier", this.packageIdentifier);
            props.put("packageName", this.packageName);
            props.put("packageSigningPrefix", this.packageSigningPrefix);
            props.put("signingKeychain", this.signingKeychain);
            props.put("signingKeyUsername", this.signingKeyUsername);
            props.put("sign", this.sign);
        }
    }

    public static class Windows
    extends AbstractPlatformPackager {
        private boolean console;
        private boolean dirChooser;
        private boolean menu;
        private boolean perUserInstall;
        private boolean shortcut;
        private String menuGroup;
        private String upgradeUuid;

        public Windows() {
            super("windows", Arrays.asList("msi", "exe"));
        }

        void setAll(Windows packager) {
            super.setAll(packager);
            this.console = packager.console;
            this.dirChooser = packager.dirChooser;
            this.menu = packager.menu;
            this.perUserInstall = packager.perUserInstall;
            this.shortcut = packager.shortcut;
            this.menuGroup = packager.menuGroup;
            this.upgradeUuid = packager.upgradeUuid;
        }

        public boolean isConsole() {
            return this.console;
        }

        public void setConsole(boolean console) {
            this.console = console;
        }

        public boolean isDirChooser() {
            return this.dirChooser;
        }

        public void setDirChooser(boolean dirChooser) {
            this.dirChooser = dirChooser;
        }

        public boolean isMenu() {
            return this.menu;
        }

        public void setMenu(boolean menu) {
            this.menu = menu;
        }

        public boolean isPerUserInstall() {
            return this.perUserInstall;
        }

        public void setPerUserInstall(boolean perUserInstall) {
            this.perUserInstall = perUserInstall;
        }

        public boolean isShortcut() {
            return this.shortcut;
        }

        public void setShortcut(boolean shortcut) {
            this.shortcut = shortcut;
        }

        public String getMenuGroup() {
            return this.menuGroup;
        }

        public void setMenuGroup(String menuGroup) {
            this.menuGroup = menuGroup;
        }

        public String getUpgradeUuid() {
            return this.upgradeUuid;
        }

        public void setUpgradeUuid(String upgradeUuid) {
            this.upgradeUuid = upgradeUuid;
        }

        @Override
        protected void asMap(boolean full, Map<String, Object> props) {
            props.put("console", this.console);
            props.put("dirChooser", this.dirChooser);
            props.put("menu", this.menu);
            props.put("perUserInstall", this.perUserInstall);
            props.put("shortcut", this.shortcut);
            props.put("menuGroup", this.menuGroup);
            props.put("upgradeUuid", this.upgradeUuid);
        }
    }

    public static class Linux
    extends AbstractPlatformPackager {
        private final List<String> packageDeps = new ArrayList<String>();
        private String packageName;
        private String maintainer;
        private String menuGroup;
        private String license;
        private String appRelease;
        private String appCategory;
        private boolean shortcut;

        public Linux() {
            super("linux", Arrays.asList("deb", "rpm"));
        }

        void setAll(Linux packager) {
            super.setAll(packager);
            this.packageName = packager.packageName;
            this.maintainer = packager.maintainer;
            this.menuGroup = packager.menuGroup;
            this.license = packager.license;
            this.appRelease = packager.appRelease;
            this.appCategory = packager.appCategory;
            this.shortcut = packager.shortcut;
            this.setPackageDeps(packager.packageDeps);
        }

        public List<String> getPackageDeps() {
            return this.packageDeps;
        }

        public void setPackageDeps(List<String> packageDeps) {
            this.packageDeps.clear();
            this.packageDeps.addAll(packageDeps);
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getMaintainer() {
            return this.maintainer;
        }

        public void setMaintainer(String maintainer) {
            this.maintainer = maintainer;
        }

        public String getMenuGroup() {
            return this.menuGroup;
        }

        public void setMenuGroup(String menuGroup) {
            this.menuGroup = menuGroup;
        }

        public String getLicense() {
            return this.license;
        }

        public void setLicense(String license) {
            this.license = license;
        }

        public String getAppRelease() {
            return this.appRelease;
        }

        public void setAppRelease(String appRelease) {
            this.appRelease = appRelease;
        }

        public String getAppCategory() {
            return this.appCategory;
        }

        public void setAppCategory(String appCategory) {
            this.appCategory = appCategory;
        }

        public boolean isShortcut() {
            return this.shortcut;
        }

        public void setShortcut(boolean shortcut) {
            this.shortcut = shortcut;
        }

        @Override
        protected void asMap(boolean full, Map<String, Object> props) {
            props.put("packageName", this.packageName);
            props.put("maintainer", this.maintainer);
            props.put("menuGroup", this.menuGroup);
            props.put("license", this.license);
            props.put("appRelease", this.appRelease);
            props.put("appCategory", this.appCategory);
            props.put("shortcut", this.shortcut);
            props.put("packageDeps", this.packageDeps);
        }
    }

    private static abstract class AbstractPlatformPackager
    implements PlatformPackager {
        private final Artifact jdk = new Artifact();
        private final List<String> types = new ArrayList<String>();
        private final List<String> validTypes = new ArrayList<String>();
        private final String platform;
        @JsonIgnore
        private boolean enabled;
        private String appName;
        private String icon;
        private String installDir;
        private String resourceDir;

        protected AbstractPlatformPackager(String platform, List<String> validTypes) {
            this.platform = platform;
            this.validTypes.addAll(validTypes);
        }

        void setAll(AbstractPlatformPackager packager) {
            this.icon = packager.icon;
            this.appName = packager.appName;
            this.enabled = packager.enabled;
            this.installDir = packager.installDir;
            this.resourceDir = packager.resourceDir;
            this.setJdk(packager.jdk);
            this.setTypes(packager.types);
        }

        @Override
        public String getResolvedAppName(JReleaserContext context, Jpackage jpackage) {
            Map<String, Object> props = context.getModel().props();
            props.putAll(jpackage.props());
            return Templates.resolveTemplate((String)this.appName, props);
        }

        @Override
        public String getAppName() {
            return this.appName;
        }

        @Override
        public void setAppName(String appName) {
            this.appName = appName;
        }

        @Override
        public String getIcon() {
            return this.icon;
        }

        @Override
        public void setIcon(String icon) {
            this.icon = icon;
        }

        @Override
        public List<String> getValidTypes() {
            return this.validTypes;
        }

        @Override
        public String getPlatform() {
            return this.platform;
        }

        @Override
        public String getResourceDir() {
            return this.resourceDir;
        }

        @Override
        public void setResourceDir(String resourceDir) {
            this.resourceDir = resourceDir;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public void enable() {
            this.enabled = true;
        }

        @Override
        public void disable() {
            this.enabled = false;
        }

        @Override
        public Artifact getJdk() {
            return this.jdk;
        }

        @Override
        public void setJdk(Artifact jdk) {
            this.jdk.setAll(jdk);
        }

        @Override
        public List<String> getTypes() {
            return this.types;
        }

        @Override
        public void setTypes(List<String> types) {
            this.types.clear();
            this.types.addAll(types);
        }

        @Override
        public String getInstallDir() {
            return this.installDir;
        }

        @Override
        public void setInstallDir(String installDir) {
            this.installDir = installDir;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            if (!full && !this.isEnabled()) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("enabled", this.isEnabled());
            props.put("appName", this.appName);
            props.put("icon", this.icon);
            props.put("resourceDir", this.resourceDir);
            props.put("types", this.types);
            props.put("jdk", this.jdk.asMap(full));
            props.put("installDir", this.installDir);
            this.asMap(full, props);
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(this.platform, props);
            return map;
        }

        protected abstract void asMap(boolean var1, Map<String, Object> var2);
    }

    public static class Launcher
    implements Domain {
        private final List<String> arguments = new ArrayList<String>();
        private final List<String> javaOptions = new ArrayList<String>();
        private final List<String> launchers = new ArrayList<String>();

        void setAll(Launcher launcher) {
            this.setArguments(launcher.arguments);
            this.setJavaOptions(launcher.javaOptions);
            this.setLaunchers(launcher.launchers);
        }

        public boolean isSet() {
            return !this.arguments.isEmpty() || !this.javaOptions.isEmpty() || !this.launchers.isEmpty();
        }

        public List<String> getLaunchers() {
            return this.launchers;
        }

        public void setLaunchers(List<String> launchers) {
            this.launchers.clear();
            this.launchers.addAll(launchers);
        }

        public void addLaunchers(List<String> launchers) {
            this.launchers.addAll(launchers);
        }

        public List<String> getArguments() {
            return this.arguments;
        }

        public void setArguments(List<String> arguments) {
            this.arguments.clear();
            this.arguments.addAll(arguments);
        }

        public void addArguments(List<String> arguments) {
            this.arguments.addAll(arguments);
        }

        public List<String> getJavaOptions() {
            return this.javaOptions;
        }

        public void setJavaOptions(List<String> javaOptions) {
            this.javaOptions.clear();
            this.javaOptions.addAll(javaOptions);
        }

        public void addJavaOptions(List<String> javaOptions) {
            this.javaOptions.addAll(javaOptions);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("arguments", this.arguments);
            props.put("javaOptions", this.javaOptions);
            props.put("launchers", this.launchers);
            return props;
        }
    }

    public static class ApplicationPackage
    implements Domain {
        private final List<String> fileAssociations = new ArrayList<String>();
        private String appName;
        private String appVersion;
        private String vendor;
        private String copyright;
        private String licenseFile;

        void setAll(ApplicationPackage applicationPackage) {
            this.appName = applicationPackage.appName;
            this.appVersion = applicationPackage.appVersion;
            this.vendor = applicationPackage.vendor;
            this.copyright = applicationPackage.copyright;
            this.licenseFile = applicationPackage.licenseFile;
            this.setFileAssociations(applicationPackage.fileAssociations);
        }

        public String getResolvedAppVersion(JReleaserContext context, Jpackage jpackage) {
            Map<String, Object> props = context.getModel().props();
            props.putAll(jpackage.props());
            return Templates.resolveTemplate((String)this.appVersion, props);
        }

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public String getAppVersion() {
            return this.appVersion;
        }

        public void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        public String getVendor() {
            return this.vendor;
        }

        public void setVendor(String vendor) {
            this.vendor = vendor;
        }

        public String getCopyright() {
            return this.copyright;
        }

        public void setCopyright(String copyright) {
            this.copyright = copyright;
        }

        public List<String> getFileAssociations() {
            return this.fileAssociations;
        }

        public void setFileAssociations(List<String> fileAssociations) {
            this.fileAssociations.clear();
            this.fileAssociations.addAll(fileAssociations);
        }

        public String getLicenseFile() {
            return this.licenseFile;
        }

        public void setLicenseFile(String licenseFile) {
            this.licenseFile = licenseFile;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("appName", this.appName);
            props.put("appVersion", this.appVersion);
            props.put("copyright", this.copyright);
            props.put("vendor", this.vendor);
            props.put("licenseFile", this.licenseFile);
            props.put("fileAssociations", this.fileAssociations);
            return props;
        }
    }

    public static interface PlatformPackager
    extends Domain {
        public String getAppName();

        public void setAppName(String var1);

        public String getResolvedAppName(JReleaserContext var1, Jpackage var2);

        public String getIcon();

        public void setIcon(String var1);

        public List<String> getValidTypes();

        public String getPlatform();

        public boolean isEnabled();

        public void enable();

        public void disable();

        public Artifact getJdk();

        public void setJdk(Artifact var1);

        public List<String> getTypes();

        public void setTypes(List<String> var1);

        public String getInstallDir();

        public void setInstallDir(String var1);

        public String getResourceDir();

        public void setResourceDir(String var1);
    }
}

