/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import twitter4j.Friendship;
import twitter4j.HttpResponse;
import twitter4j.JSONArray;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.ParseUtil;
import twitter4j.ResponseList;
import twitter4j.ResponseListImpl;
import twitter4j.TwitterException;
import twitter4j.TwitterObjectFactory;
import twitter4j.conf.Configuration;

class FriendshipJSONImpl
implements Friendship {
    private static final long serialVersionUID = 6847273186993125826L;
    private final long id;
    private final String name;
    private final String screenName;
    private boolean following = false;
    private boolean followedBy = false;

    FriendshipJSONImpl(JSONObject json) throws TwitterException {
        try {
            this.id = ParseUtil.getLong("id", json);
            this.name = json.getString("name");
            this.screenName = json.getString("screen_name");
            JSONArray connections = json.getJSONArray("connections");
            for (int i = 0; i < connections.length(); ++i) {
                String connection = connections.getString(i);
                if ("following".equals(connection)) {
                    this.following = true;
                    continue;
                }
                if (!"followed_by".equals(connection)) continue;
                this.followedBy = true;
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone.getMessage() + ":" + json.toString(), jsone);
        }
    }

    static ResponseList<Friendship> createFriendshipList(HttpResponse res, Configuration conf) throws TwitterException {
        try {
            if (conf.isJSONStoreEnabled()) {
                TwitterObjectFactory.clearThreadLocalMap();
            }
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ResponseListImpl<Friendship> friendshipList = new ResponseListImpl<Friendship>(size, res);
            for (int i = 0; i < size; ++i) {
                JSONObject json = list.getJSONObject(i);
                FriendshipJSONImpl friendship = new FriendshipJSONImpl(json);
                if (conf.isJSONStoreEnabled()) {
                    TwitterObjectFactory.registerJSONObject(friendship, json);
                }
                friendshipList.add(friendship);
            }
            if (conf.isJSONStoreEnabled()) {
                TwitterObjectFactory.registerJSONObject(friendshipList, list);
            }
            return friendshipList;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getScreenName() {
        return this.screenName;
    }

    @Override
    public boolean isFollowing() {
        return this.following;
    }

    @Override
    public boolean isFollowedBy() {
        return this.followedBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FriendshipJSONImpl that = (FriendshipJSONImpl)o;
        if (this.followedBy != that.followedBy) {
            return false;
        }
        if (this.following != that.following) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.screenName.equals(that.screenName);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.screenName != null ? this.screenName.hashCode() : 0);
        result = 31 * result + (this.following ? 1 : 0);
        result = 31 * result + (this.followedBy ? 1 : 0);
        return result;
    }

    public String toString() {
        return "FriendshipJSONImpl{id=" + this.id + ", name='" + this.name + '\'' + ", screenName='" + this.screenName + '\'' + ", following=" + this.following + ", followedBy=" + this.followedBy + '}';
    }
}

