/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.context;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.context.ContextCreator;
import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Codeberg;
import org.jreleaser.model.Github;
import org.jreleaser.model.Gitlab;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.JReleaserVersion;
import org.jreleaser.model.UpdateSection;
import org.jreleaser.model.releaser.spi.Repository;
import org.jreleaser.model.util.Artifacts;
import org.jreleaser.sdk.git.GitSdk;
import org.jreleaser.util.JReleaserException;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.StringUtils;

public class ModelAutoConfigurer {
    private static final String GLOB_PREFIX = "glob:";
    private static final String REGEX_PREFIX = "regex:";
    private final List<String> files = new ArrayList<String>();
    private final List<String> globs = new ArrayList<String>();
    private final List<String> selectedPlatforms = new ArrayList<String>();
    private final Set<UpdateSection> updateSections = new LinkedHashSet<UpdateSection>();
    private JReleaserLogger logger;
    private Path basedir;
    private Path outputDirectory;
    private boolean dryrun;
    private boolean gitRootSearch;
    private String projectName;
    private String projectVersion;
    private String projectVersionPattern;
    private String projectSnapshotPattern;
    private String projectSnapshotLabel;
    private boolean projectSnapshotFullChangelog;
    private String tagName;
    private String previousTagName;
    private String releaseName;
    private String milestoneName;
    private String branch;
    private boolean prerelease;
    private String prereleasePattern;
    private boolean draft;
    private boolean overwrite;
    private boolean update;
    private boolean skipTag;
    private boolean skipRelease;
    private String changelog;
    private boolean changelogFormatted;
    private String username;
    private String commitAuthorName;
    private String commitAuthorEmail;
    private boolean signing;
    private boolean armored;

    public ModelAutoConfigurer logger(JReleaserLogger logger) {
        this.logger = logger;
        return this;
    }

    public ModelAutoConfigurer basedir(Path basedir) {
        this.basedir = basedir;
        return this;
    }

    public ModelAutoConfigurer outputDirectory(Path outputDirectory) {
        this.outputDirectory = outputDirectory;
        return this;
    }

    public ModelAutoConfigurer dryrun(boolean dryrun) {
        this.dryrun = dryrun;
        return this;
    }

    public ModelAutoConfigurer gitRootSearch(boolean gitRootSearch) {
        this.gitRootSearch = gitRootSearch;
        return this;
    }

    public ModelAutoConfigurer projectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    public ModelAutoConfigurer projectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
        return this;
    }

    public ModelAutoConfigurer projectVersionPattern(String projectVersionPattern) {
        this.projectVersionPattern = projectVersionPattern;
        return this;
    }

    public ModelAutoConfigurer projectSnapshotPattern(String projectSnapshotPattern) {
        this.projectSnapshotPattern = projectSnapshotPattern;
        return this;
    }

    public ModelAutoConfigurer projectSnapshotLabel(String projectSnapshotLabel) {
        this.projectSnapshotLabel = projectSnapshotLabel;
        return this;
    }

    public ModelAutoConfigurer projectSnapshotFullChangelog(boolean projectSnapshotFullChangelog) {
        this.projectSnapshotFullChangelog = projectSnapshotFullChangelog;
        return this;
    }

    public ModelAutoConfigurer tagName(String tagName) {
        this.tagName = tagName;
        return this;
    }

    public ModelAutoConfigurer previousTagName(String previousTagName) {
        this.previousTagName = previousTagName;
        return this;
    }

    public ModelAutoConfigurer branch(String branch) {
        this.branch = branch;
        return this;
    }

    public ModelAutoConfigurer releaseName(String releaseName) {
        this.releaseName = releaseName;
        return this;
    }

    public ModelAutoConfigurer milestoneName(String milestoneName) {
        this.milestoneName = milestoneName;
        return this;
    }

    public ModelAutoConfigurer prerelease(boolean prerelease) {
        this.prerelease = prerelease;
        return this;
    }

    public ModelAutoConfigurer prereleasePattern(String prereleasePattern) {
        this.prereleasePattern = prereleasePattern;
        return this;
    }

    public ModelAutoConfigurer draft(boolean draft) {
        this.draft = draft;
        return this;
    }

    public ModelAutoConfigurer overwrite(boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    public ModelAutoConfigurer update(boolean update) {
        this.update = update;
        return this;
    }

    public ModelAutoConfigurer updateSections(Set<UpdateSection> updateSections) {
        this.updateSections.clear();
        if (null != updateSections && !updateSections.isEmpty()) {
            updateSections.forEach(this::updateSection);
        }
        return this;
    }

    public ModelAutoConfigurer updateSection(UpdateSection updateSection) {
        if (null != updateSection) {
            this.updateSections.add(updateSection);
        }
        return this;
    }

    public ModelAutoConfigurer skipTag(boolean skipTag) {
        this.skipTag = skipTag;
        return this;
    }

    public ModelAutoConfigurer skipRelease(boolean skipRelease) {
        this.skipRelease = skipRelease;
        return this;
    }

    public ModelAutoConfigurer changelog(String changelog) {
        this.changelog = changelog;
        return this;
    }

    public ModelAutoConfigurer changelogFormatted(boolean changelogFormatted) {
        this.changelogFormatted = changelogFormatted;
        return this;
    }

    public ModelAutoConfigurer username(String username) {
        this.username = username;
        return this;
    }

    public ModelAutoConfigurer commitAuthorName(String commitAuthorName) {
        this.commitAuthorName = commitAuthorName;
        return this;
    }

    public ModelAutoConfigurer commitAuthorEmail(String commitAuthorEmail) {
        this.commitAuthorEmail = commitAuthorEmail;
        return this;
    }

    public ModelAutoConfigurer signing(boolean signing) {
        this.signing = signing;
        return this;
    }

    public ModelAutoConfigurer armored(boolean armored) {
        this.armored = armored;
        return this;
    }

    public ModelAutoConfigurer files(List<String> files) {
        this.files.clear();
        if (null != files && !files.isEmpty()) {
            files.forEach(this::file);
        }
        return this;
    }

    public ModelAutoConfigurer file(String file) {
        if (StringUtils.isNotBlank((String)file)) {
            this.files.add(file.trim());
        }
        return this;
    }

    public ModelAutoConfigurer globs(List<String> globs) {
        this.globs.clear();
        if (null != globs && !globs.isEmpty()) {
            globs.forEach(this::glob);
        }
        return this;
    }

    public ModelAutoConfigurer glob(String glob) {
        if (StringUtils.isNotBlank((String)glob)) {
            if (glob.startsWith(GLOB_PREFIX) || glob.startsWith(REGEX_PREFIX)) {
                this.globs.add(glob.trim());
            } else {
                this.globs.add(GLOB_PREFIX + glob.trim());
            }
        }
        return this;
    }

    public ModelAutoConfigurer selectedPlatforms(List<String> platforms) {
        this.selectedPlatforms.clear();
        if (null != platforms && !platforms.isEmpty()) {
            platforms.forEach(this::selectedPlatform);
        }
        return this;
    }

    public ModelAutoConfigurer selectedPlatform(String platform) {
        if (StringUtils.isNotBlank((String)platform)) {
            this.selectedPlatforms.add(platform.trim());
        }
        return this;
    }

    public JReleaserContext autoConfigure() {
        Objects.requireNonNull(this.logger, "Argument 'logger' ust not be null");
        Objects.requireNonNull(this.basedir, "Argument 'basedir' ust not be null");
        Objects.requireNonNull(this.outputDirectory, "Argument 'outputDirectory' ust not be null");
        this.logger.info("JReleaser {}", new Object[]{JReleaserVersion.getPlainVersion()});
        JReleaserVersion.banner((PrintWriter)this.logger.getTracer());
        this.logger.info(RB.$((String)"context.configurer.auto-config.on", (Object[])new Object[0]));
        this.logger.increaseIndent();
        this.logger.info(RB.$((String)"context.configurer.basedir.set", (Object[])new Object[0]), new Object[]{this.basedir.toAbsolutePath()});
        this.dumpAutoConfig();
        this.logger.decreaseIndent();
        return this.createAutoConfiguredContext();
    }

    private JReleaserContext createAutoConfiguredContext() {
        return ContextCreator.create(this.logger, JReleaserContext.Configurer.CLI, JReleaserContext.Mode.FULL, this.autoConfiguredModel(this.basedir), this.basedir, this.outputDirectory, this.dryrun, this.gitRootSearch, this.selectedPlatforms);
    }

    private void dumpAutoConfig() {
        if (StringUtils.isNotBlank((String)this.projectName)) {
            this.logger.info("- project.name: {}", new Object[]{this.projectName});
        }
        if (StringUtils.isNotBlank((String)this.projectVersion)) {
            this.logger.info("- project.version: {}", new Object[]{this.projectVersion});
        }
        if (StringUtils.isNotBlank((String)this.projectVersionPattern)) {
            this.logger.info("- project.version.pattern: {}", new Object[]{this.projectVersionPattern});
        }
        if (StringUtils.isNotBlank((String)this.projectSnapshotPattern)) {
            this.logger.info("- project.snapshot.pattern: {}", new Object[]{this.projectSnapshotPattern});
        }
        if (StringUtils.isNotBlank((String)this.projectSnapshotLabel)) {
            this.logger.info("- project.snapshot.label: {}", new Object[]{this.projectSnapshotLabel});
        }
        if (this.projectSnapshotFullChangelog) {
            this.logger.info("- project.snapshot.full.changelog: true");
        }
        if (StringUtils.isNotBlank((String)this.username)) {
            this.logger.info("- release.username: {}", new Object[]{this.username});
        }
        if (StringUtils.isNotBlank((String)this.tagName)) {
            this.logger.info("- release.tagName: {}", new Object[]{this.tagName});
        }
        if (StringUtils.isNotBlank((String)this.previousTagName)) {
            this.logger.info("- release.previousTagName: {}", new Object[]{this.previousTagName});
        }
        if (StringUtils.isNotBlank((String)this.branch)) {
            this.logger.info("- release.branch: {}", new Object[]{this.branch});
        }
        if (StringUtils.isNotBlank((String)this.releaseName)) {
            this.logger.info("- release.releaseName: {}", new Object[]{this.releaseName});
        }
        if (StringUtils.isNotBlank((String)this.milestoneName)) {
            this.logger.info("- release.milestone.name: {}", new Object[]{this.milestoneName});
        }
        if (this.overwrite) {
            this.logger.info("- release.overwrite: true");
        }
        if (this.update) {
            this.logger.info("- release.update: true");
        }
        if (!this.updateSections.isEmpty()) {
            this.logger.info("- release.updateSections: " + this.updateSections);
        }
        if (this.skipTag) {
            this.logger.info("- release.skipTag: true");
        }
        if (this.skipRelease) {
            this.logger.info("- release.skipRelease: true");
        }
        if (this.prerelease) {
            this.logger.info("- release.prerelease: true");
        }
        if (StringUtils.isNotBlank((String)this.prereleasePattern)) {
            this.logger.info("- release.prerelease.pattern: {}", new Object[]{this.prereleasePattern});
        }
        if (this.draft) {
            this.logger.info("- release.draft: true");
        }
        if (StringUtils.isNotBlank((String)this.changelog)) {
            this.logger.info(" - release.changelog: {}", new Object[]{this.changelog});
        }
        if (this.changelogFormatted) {
            this.logger.info("- release.changelog.formatted: true");
        }
        if (StringUtils.isNotBlank((String)this.commitAuthorName)) {
            this.logger.info("- release.commitAuthor.name: {}", new Object[]{this.commitAuthorName});
        }
        if (StringUtils.isNotBlank((String)this.commitAuthorEmail)) {
            this.logger.info("- release.commitAuthor.email: {}", new Object[]{this.commitAuthorEmail});
        }
        if (this.signing) {
            this.logger.info("- signing.enabled: true");
        }
        if (this.armored) {
            this.logger.info("- signing.armored: true");
        }
        if (!this.files.isEmpty()) {
            for (String file : this.files) {
                this.logger.info("- file: {}", new Object[]{this.basedir.relativize(this.basedir.resolve(file))});
            }
        }
        if (!this.globs.isEmpty()) {
            for (String glob : this.globs) {
                this.logger.info("- glob: {}", new Object[]{glob});
            }
        }
        if (!this.selectedPlatforms.isEmpty()) {
            for (String platform : this.selectedPlatforms) {
                this.logger.info("- platform: {}", new Object[]{platform});
            }
        }
    }

    private JReleaserModel autoConfiguredModel(Path basedir) {
        JReleaserModel model = new JReleaserModel();
        model.getProject().setName(this.projectName);
        model.getProject().setVersion(this.projectVersion);
        model.getProject().setVersionPattern(this.projectVersionPattern);
        model.getProject().getSnapshot().setPattern(this.projectSnapshotPattern);
        model.getProject().getSnapshot().setLabel(this.projectSnapshotLabel);
        model.getProject().getSnapshot().setFullChangelog(Boolean.valueOf(this.projectSnapshotFullChangelog));
        try {
            Repository repository = GitSdk.of((Path)basedir, (boolean)this.gitRootSearch).getRemote();
            Github service = null;
            switch (repository.getKind()) {
                case GITHUB: {
                    service = new Github();
                    model.getRelease().setGithub(service);
                    if (this.prerelease) {
                        service.getPrerelease().setEnabled(Boolean.valueOf(true));
                    }
                    service.getPrerelease().setPattern(this.prereleasePattern);
                    service.setDraft(Boolean.valueOf(this.draft));
                    break;
                }
                case GITLAB: {
                    service = new Gitlab();
                    model.getRelease().setGitlab((Gitlab)service);
                    break;
                }
                case CODEBERG: {
                    service = new Codeberg();
                    model.getRelease().setCodeberg((Codeberg)service);
                    if (this.prerelease) {
                        ((Codeberg)service).getPrerelease().setEnabled(Boolean.valueOf(true));
                    }
                    ((Codeberg)service).getPrerelease().setPattern(this.prereleasePattern);
                    ((Codeberg)service).setDraft(Boolean.valueOf(this.draft));
                    break;
                }
                default: {
                    throw new JReleaserException(RB.$((String)"ERROR_context_configurer_unsupported_url", (Object[])new Object[]{repository.getHttpUrl()}));
                }
            }
            service.setUsername(this.username);
            service.setTagName(this.tagName);
            service.setPreviousTagName(this.previousTagName);
            service.setReleaseName(this.releaseName);
            service.getMilestone().setName(this.milestoneName);
            service.setOverwrite(Boolean.valueOf(this.overwrite));
            service.getUpdate().setEnabled(Boolean.valueOf(this.update));
            if (!this.updateSections.isEmpty()) {
                if (!this.update) {
                    throw new JReleaserException(RB.$((String)"ERROR_context_configurer_update_not_set", (Object[])new Object[0]));
                }
                service.getUpdate().setSections(this.updateSections);
            }
            service.setSkipTag(Boolean.valueOf(this.skipTag));
            service.setSkipRelease(Boolean.valueOf(this.skipRelease));
            if (StringUtils.isNotBlank((String)this.branch)) {
                service.setBranch(this.branch);
            }
            if (StringUtils.isNotBlank((String)this.changelog)) {
                service.getChangelog().setExternal(this.changelog);
            }
            if (StringUtils.isNotBlank((String)this.commitAuthorName)) {
                service.getCommitAuthor().setName(this.commitAuthorName);
            }
            if (StringUtils.isNotBlank((String)this.commitAuthorEmail)) {
                service.getCommitAuthor().setEmail(this.commitAuthorEmail);
            }
            if (this.changelogFormatted) {
                service.getChangelog().setFormatted(Active.ALWAYS);
            }
        }
        catch (IOException e) {
            throw new JReleaserException(e.getMessage());
        }
        if (this.signing) {
            model.getSigning().setActive(Active.ALWAYS);
            model.getSigning().setArmored(Boolean.valueOf(this.armored));
        }
        if (!this.files.isEmpty()) {
            for (String file : this.files) {
                model.getFiles().addArtifact(Artifact.of((Path)basedir.resolve(file)));
            }
        }
        if (!this.globs.isEmpty()) {
            model.getFiles().addArtifacts(Artifacts.resolveFiles((JReleaserLogger)this.logger, (Path)basedir, this.globs));
        }
        return model;
    }

    public static ModelAutoConfigurer builder() {
        return new ModelAutoConfigurer();
    }
}

