/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.AbstractAnnouncer;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.JReleaserException;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.Templates;

public class Discussions
extends AbstractAnnouncer {
    public static final String NAME = "discussions";
    private String organization;
    private String team;
    private String title;
    private String message;
    private String messageTemplate;

    public Discussions() {
        super(NAME);
    }

    void setAll(Discussions discussions) {
        super.setAll(discussions);
        this.organization = discussions.organization;
        this.team = discussions.team;
        this.title = discussions.title;
        this.message = discussions.message;
        this.messageTemplate = discussions.messageTemplate;
    }

    public String getResolvedTitle(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.title, props);
    }

    public String getResolvedMessage(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.message, props);
    }

    public String getResolvedMessageTemplate(JReleaserContext context, Map<String, Object> extraProps) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        props.put("tagName", context.getModel().getRelease().getGitService().getEffectiveTagName(context.getModel()));
        props.putAll(extraProps);
        Path templatePath = context.getBasedir().resolve(this.messageTemplate);
        try {
            BufferedReader reader = Files.newBufferedReader(templatePath);
            return MustacheUtils.applyTemplate((Reader)reader, props);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_reading_template", (Object[])new Object[]{context.relativizeToBasedir(templatePath)}));
        }
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getTeam() {
        return this.team;
    }

    public void setTeam(String team) {
        this.team = team;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public void setMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    @Override
    protected void asMap(Map<String, Object> props, boolean full) {
        props.put("organization", this.organization);
        props.put("team", this.team);
        props.put("title", this.title);
        props.put("message", this.message);
        props.put("messageTemplate", this.messageTemplate);
    }
}

