/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Zulip;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class ZulipValidator
extends Validator {
    private static final String DEFAULT_ZULIP_TPL = "src/jreleaser/templates/zulip.tpl";

    public static void validateZulip(JReleaserContext context, Zulip zulip, Errors errors) {
        if (!zulip.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        context.getLogger().debug("announce.zulip");
        if (StringUtils.isBlank((String)zulip.getAccount())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"zulip.account"}));
        }
        zulip.setApiKey(ZulipValidator.checkProperty(context, "ZULIP_API_KEY", "zulip.apiKey", zulip.getApiKey(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)zulip.getApiHost())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"zulip.apiHost"}));
        }
        if (StringUtils.isBlank((String)zulip.getSubject())) {
            zulip.setSubject(RB.$((String)"default.discussion.title", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((String)zulip.getChannel())) {
            zulip.setChannel("announce");
        }
        if (StringUtils.isBlank((String)zulip.getMessage()) && StringUtils.isBlank((String)zulip.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_ZULIP_TPL), new LinkOption[0])) {
                zulip.setMessageTemplate(DEFAULT_ZULIP_TPL);
            } else {
                zulip.setMessage(RB.$((String)"default.release.message", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((String)zulip.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(zulip.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"zulip.messageTemplate", zulip.getMessageTemplate()}));
        }
        ZulipValidator.validateTimeout(zulip);
    }
}

