/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.jreleaser.cli.AbstractCommand;
import org.jreleaser.cli.internal.ColorizedJReleaserLoggerAdapter;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.StringUtils;
import picocli.CommandLine;

abstract class AbstractLoggingCommand
extends AbstractCommand
implements Callable<Integer> {
    protected JReleaserLogger logger;
    @CommandLine.Option(names={"-g", "--debug"})
    boolean debug;
    @CommandLine.Option(names={"-i", "--info"})
    boolean info;
    @CommandLine.Option(names={"-w", "--warn"})
    boolean warn;
    @CommandLine.Option(names={"-q", "--quiet"})
    boolean quiet;
    @CommandLine.Option(names={"-b", "--basedir"})
    Path basedir;
    @CommandLine.Option(names={"-od", "--output-directory"})
    Path outputdir;

    AbstractLoggingCommand() {
    }

    protected void initLogger() {
        ColorizedJReleaserLoggerAdapter.Level level = ColorizedJReleaserLoggerAdapter.Level.INFO;
        if (this.debug) {
            level = ColorizedJReleaserLoggerAdapter.Level.DEBUG;
            System.setProperty("org.slf4j.simpleLogger.org.jreleaser", "debug");
        } else if (this.info) {
            level = ColorizedJReleaserLoggerAdapter.Level.INFO;
            System.setProperty("org.slf4j.simpleLogger.org.jreleaser", "info");
        } else if (this.warn) {
            level = ColorizedJReleaserLoggerAdapter.Level.WARN;
            System.setProperty("org.slf4j.simpleLogger.org.jreleaser", "warn");
        } else if (this.quiet) {
            level = ColorizedJReleaserLoggerAdapter.Level.ERROR;
            System.setProperty("org.slf4j.simpleLogger.org.jreleaser", "error");
        }
        this.logger = new ColorizedJReleaserLoggerAdapter(this.createTracer(), this.parent().out, level);
    }

    protected PrintWriter createTracer() {
        try {
            Files.createDirectories(this.getOutputDirectory(), new FileAttribute[0]);
            return new PrintWriter(new FileOutputStream(this.getOutputDirectory().resolve("trace.log").toFile()), true);
        }
        catch (IOException e) {
            throw new IllegalStateException(this.$("ERROR_trace_file_init", new Object[0]), e);
        }
    }

    protected abstract Path getOutputDirectory();

    protected List<String> collectEntries(String[] input) {
        return this.collectEntries(input, false);
    }

    protected List<String> collectEntries(String[] input, boolean lowerCase) {
        ArrayList<String> list = new ArrayList<String>();
        if (input != null && input.length > 0) {
            for (String s : input) {
                if (!StringUtils.isNotBlank((String)s)) continue;
                if (!s.contains("-") && lowerCase) {
                    s = StringUtils.getHyphenatedName((String)s);
                }
                list.add(lowerCase ? s.toLowerCase() : s);
            }
        }
        return list;
    }
}

