/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.releaser.spi;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.releaser.spi.Releaser;
import org.jreleaser.model.releaser.spi.ReleaserBuilder;
import org.jreleaser.model.util.Artifacts;
import org.jreleaser.util.Algorithm;
import org.jreleaser.util.StringUtils;

public abstract class AbstractReleaserBuilder<R extends Releaser>
implements ReleaserBuilder<R> {
    protected final List<Path> assets = new ArrayList<Path>();
    protected JReleaserContext context;

    @Override
    public ReleaserBuilder<R> addReleaseAsset(Path asset) {
        if (null != asset && asset.toFile().exists()) {
            this.assets.add(asset);
        }
        return this;
    }

    @Override
    public ReleaserBuilder<R> addReleaseAssets(Path assets) {
        if (assets.toFile().exists()) {
            for (File asset : assets.toFile().listFiles()) {
                this.addReleaseAsset(asset.toPath().toAbsolutePath());
            }
        }
        return this;
    }

    @Override
    public ReleaserBuilder<R> setReleaseAssets(List<Path> assets) {
        if (null != assets) {
            this.assets.addAll(assets);
        }
        return this;
    }

    protected void validate() {
        Objects.requireNonNull(this.context, "'context' must not be null");
    }

    @Override
    public ReleaserBuilder<R> configureWith(JReleaserContext context) {
        this.context = context;
        GitService service = context.getModel().getRelease().getGitService();
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        if (service.isFiles().booleanValue()) {
            for (Artifact artifact : Artifacts.resolveFiles(context)) {
                if (!artifact.isActive() || artifact.extraPropertyIsTrue("skipRelease")) continue;
                Path path = artifact.getEffectivePath(context);
                artifacts.add(Artifact.of(path, artifact.getExtraProperties()));
                if (!service.isChecksums().booleanValue() || !this.isIndividual(context, artifact) || artifact.extraPropertyIsTrue("skipChecksum")) continue;
                for (Algorithm algorithm : context.getModel().getChecksum().getAlgorithms()) {
                    artifacts.add(Artifact.of(context.getChecksumsDirectory().resolve(path.getFileName() + "." + algorithm.formatted())));
                }
            }
        }
        if (service.isArtifacts().booleanValue()) {
            for (Distribution distribution : context.getModel().getActiveDistributions()) {
                if (!context.isDistributionIncluded(distribution) || distribution.extraPropertyIsTrue("skipRelease")) continue;
                for (Artifact artifact : distribution.getArtifacts()) {
                    if (!artifact.isActive() || artifact.extraPropertyIsTrue("skipRelease")) continue;
                    Path path = artifact.getEffectivePath(context, distribution);
                    artifacts.add(Artifact.of(path, artifact.getExtraProperties()));
                    if (!service.isChecksums().booleanValue() || !this.isIndividual(context, distribution, artifact)) continue;
                    for (Algorithm algorithm : context.getModel().getChecksum().getAlgorithms()) {
                        artifacts.add(Artifact.of(context.getChecksumsDirectory().resolve(distribution.getName()).resolve(path.getFileName() + "." + algorithm.formatted())));
                    }
                }
            }
        }
        if (service.isChecksums().booleanValue()) {
            for (Algorithm algorithm : context.getModel().getChecksum().getAlgorithms()) {
                Path checksums = context.getChecksumsDirectory().resolve(context.getModel().getChecksum().getResolvedName(context, algorithm));
                if (!Files.exists(checksums, new LinkOption[0])) continue;
                artifacts.add(Artifact.of(checksums));
            }
        }
        if (context.getModel().getSigning().isEnabled() && service.isSignatures().booleanValue()) {
            ArrayList artifactsCopy = new ArrayList(artifacts);
            for (Artifact artifact : artifactsCopy) {
                Path signature;
                if (artifact.extraPropertyIsTrue("skipSigning") || artifact.extraPropertyIsTrue("skipReleaseSignatures") || !Files.exists(signature = context.getSignaturesDirectory().resolve(artifact.getResolvedPath().getFileName().toString() + (context.getModel().getSigning().isArmored() != false ? ".asc" : ".sig")), new LinkOption[0])) continue;
                artifacts.add(Artifact.of(signature));
            }
        }
        artifacts.stream().map(Artifact::getResolvedPath).forEach(this::addReleaseAsset);
        return this;
    }

    private boolean isIndividual(JReleaserContext context, Artifact artifact) {
        if (artifact.getExtraProperties().containsKey("individualChecksum")) {
            return StringUtils.isTrue((Object)artifact.getExtraProperties().get("individualChecksum"));
        }
        return context.getModel().getChecksum().isIndividual();
    }

    private boolean isIndividual(JReleaserContext context, Distribution distribution, Artifact artifact) {
        if (artifact.getExtraProperties().containsKey("individualChecksum")) {
            return StringUtils.isTrue((Object)artifact.getExtraProperties().get("individualChecksum"));
        }
        if (distribution.getExtraProperties().containsKey("individualChecksum")) {
            return StringUtils.isTrue((Object)distribution.getExtraProperties().get("individualChecksum"));
        }
        return context.getModel().getChecksum().isIndividual();
    }
}

