/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Map;
import org.jreleaser.model.AbstractAnnouncer;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.Env;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;

public class Twitter
extends AbstractAnnouncer {
    public static final String NAME = "twitter";
    public static final String TWITTER_CONSUMER_KEY = "TWITTER_CONSUMER_KEY";
    public static final String TWITTER_CONSUMER_SECRET = "TWITTER_CONSUMER_SECRET";
    public static final String TWITTER_ACCESS_TOKEN = "TWITTER_ACCESS_TOKEN";
    public static final String TWITTER_ACCESS_TOKEN_SECRET = "TWITTER_ACCESS_TOKEN_SECRET";
    private String consumerKey;
    private String consumerSecret;
    private String accessToken;
    private String accessTokenSecret;
    private String status;

    public Twitter() {
        super(NAME);
    }

    void setAll(Twitter twitter) {
        super.setAll(twitter);
        this.consumerKey = twitter.consumerKey;
        this.consumerSecret = twitter.consumerSecret;
        this.accessToken = twitter.accessToken;
        this.accessTokenSecret = twitter.accessTokenSecret;
        this.status = twitter.status;
    }

    public String getResolvedStatus(JReleaserContext context) {
        Map<String, Object> props = context.props();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        context.getModel().getRelease().getGitService().fillProps(props, context.getModel());
        return MustacheUtils.applyTemplate((String)this.status, props);
    }

    public String getResolvedConsumerKey() {
        return Env.resolve((String)TWITTER_CONSUMER_KEY, (String)this.consumerKey);
    }

    public String getResolvedConsumerSecret() {
        return Env.resolve((String)TWITTER_CONSUMER_SECRET, (String)this.consumerSecret);
    }

    public String getResolvedAccessToken() {
        return Env.resolve((String)TWITTER_ACCESS_TOKEN, (String)this.accessToken);
    }

    public String getResolvedAccessTokenSecret() {
        return Env.resolve((String)TWITTER_ACCESS_TOKEN_SECRET, (String)this.accessTokenSecret);
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessTokenSecret() {
        return this.accessTokenSecret;
    }

    public void setAccessTokenSecret(String accessTokenSecret) {
        this.accessTokenSecret = accessTokenSecret;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    protected void asMap(Map<String, Object> props, boolean full) {
        props.put("consumerKey", StringUtils.isNotBlank((String)this.getResolvedConsumerKey()) ? "************" : "**unset**");
        props.put("consumerSecret", StringUtils.isNotBlank((String)this.getResolvedConsumerSecret()) ? "************" : "**unset**");
        props.put("accessToken", StringUtils.isNotBlank((String)this.getResolvedAccessToken()) ? "************" : "**unset**");
        props.put("accessTokenSecret", StringUtils.isNotBlank((String)this.getResolvedAccessTokenSecret()) ? "************" : "**unset**");
        props.put("status", this.status);
    }
}

