/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Map;
import org.jreleaser.model.AbstractHttpUploader;
import org.jreleaser.model.HttpUploader;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public class Artifactory
extends AbstractHttpUploader {
    public static final String TYPE = "artifactory";
    private String username;
    private String password;
    private HttpUploader.Authorization authorization;

    public Artifactory() {
        super(TYPE);
    }

    void setAll(Artifactory artifactory) {
        super.setAll(artifactory);
        this.username = artifactory.username;
        this.password = artifactory.password;
        this.authorization = artifactory.authorization;
    }

    public HttpUploader.Authorization resolveAuthorization() {
        if (null == this.authorization) {
            this.authorization = HttpUploader.Authorization.BEARER;
        }
        return this.authorization;
    }

    public String getResolvedUsername() {
        return Env.resolve((String)("ARTIFACTORY_" + Env.toVar((String)this.name) + "_USERNAME"), (String)this.username);
    }

    public String getResolvedPassword() {
        return Env.resolve((String)("ARTIFACTORY_" + Env.toVar((String)this.name) + "_PASSWORD"), (String)this.password);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Deprecated
    public String getTarget() {
        System.out.println("artifactory.target has been deprecated since 0.6.0 and will be removed in the future. Use artifactory.uploadUrl instead");
        return this.getUploadUrl();
    }

    @Deprecated
    public void setTarget(String target) {
        System.out.println("artifactory.target has been deprecated since 0.6.0 and will be removed in the future. Use artifactory.uploadUrl instead");
        this.setUploadUrl(target);
    }

    public HttpUploader.Authorization getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(HttpUploader.Authorization authorization) {
        this.authorization = authorization;
    }

    public void setAuthorization(String authorization) {
        this.authorization = HttpUploader.Authorization.of(authorization);
    }

    @Override
    protected void asMap(Map<String, Object> props, boolean full) {
        props.put("authorization", (Object)this.authorization);
        props.put("username", StringUtils.isNotBlank((String)this.getResolvedUsername()) ? "************" : "**unset**");
        props.put("password", StringUtils.isNotBlank((String)this.getResolvedPassword()) ? "************" : "**unset**");
    }
}

