/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StringUtils {
    private static final String PROPERTY_SET_PREFIX = "set";
    private static final String PROPERTY_GET_PREFIX = "get";
    private static final Pattern GETTER_PATTERN_1 = Pattern.compile("^get[A-Z][\\w]*$");
    private static final Pattern GETTER_PATTERN_2 = Pattern.compile("^is[A-Z][\\w]*$");
    private static final Pattern SETTER_PATTERN = Pattern.compile("^set[A-Z][\\w]*$");
    private static final String ERROR_METHOD_NULL = "Argument 'method' must not be null";
    private static final Pattern REGEX_CHARS = Pattern.compile("[{}()\\[\\].+*?^$\\\\|]");

    public static String capitalize(String str) {
        if (StringUtils.isBlank(str)) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase(Locale.ENGLISH) + str.substring(1);
    }

    public static String getFilenameExtension(String path) {
        if (path == null) {
            return null;
        }
        int extIndex = path.lastIndexOf(".");
        if (extIndex == -1) {
            return null;
        }
        int folderIndex = path.lastIndexOf(File.separator);
        if (folderIndex > extIndex) {
            return null;
        }
        return path.substring(extIndex + 1);
    }

    public static String getFilename(String path) {
        if (path == null) {
            return null;
        }
        int extIndex = path.lastIndexOf(".");
        if (extIndex == -1) {
            return null;
        }
        int folderIndex = path.lastIndexOf(File.separator);
        if (folderIndex > extIndex) {
            return null;
        }
        folderIndex = folderIndex < 0 ? 0 : folderIndex;
        return path.substring(folderIndex, extIndex);
    }

    public static String getFilename(String path, Collection<String> extensions) {
        for (String extension : extensions) {
            extension = extension.startsWith(".") ? extension : "." + extension;
            if (!path.endsWith(extension)) continue;
            return path.substring(0, path.length() - extension.length());
        }
        return path;
    }

    public static String getSetterName(String propertyName) {
        return PROPERTY_SET_PREFIX + StringUtils.capitalize(propertyName);
    }

    public static String getGetterName(String propertyName) {
        return PROPERTY_GET_PREFIX + StringUtils.capitalize(propertyName);
    }

    public static String getClassName(String logicalName, String trailingName) {
        if (StringUtils.isBlank(logicalName)) {
            throw new IllegalArgumentException("Argument [logicalName] must not be null or blank");
        }
        String className = StringUtils.capitalize(logicalName);
        if (trailingName != null) {
            className = className + trailingName;
        }
        return className;
    }

    public static String getClassNameRepresentation(String name) {
        StringBuilder buf = new StringBuilder();
        if (name != null && name.length() > 0) {
            String[] tokens;
            for (String token1 : tokens = name.split("[^\\w\\d]")) {
                String token = token1.trim();
                buf.append(StringUtils.capitalize(token));
            }
        }
        return buf.toString();
    }

    public static String getClassNameForLowerCaseHyphenSeparatedName(String name) {
        if (StringUtils.isBlank(name)) {
            return name;
        }
        if (name.contains("-")) {
            String[] tokens;
            StringBuilder buf = new StringBuilder();
            for (String token : tokens = name.split("-")) {
                if (token == null || token.length() == 0) continue;
                buf.append(StringUtils.capitalize(token));
            }
            return buf.toString();
        }
        return StringUtils.capitalize(name);
    }

    public static String getLogicalName(Class<?> clazz, String trailingName) {
        return StringUtils.getLogicalName(clazz.getName(), trailingName);
    }

    public static String getLogicalName(String name, String trailingName) {
        String shortName;
        if (StringUtils.isNotBlank(name) && StringUtils.isNotBlank(trailingName) && (shortName = StringUtils.getShortName(name)).endsWith(trailingName)) {
            return shortName.substring(0, shortName.length() - trailingName.length());
        }
        return name;
    }

    public static String getLogicalPropertyName(String className, String trailingName) {
        if (StringUtils.isNotBlank(className) && StringUtils.isNotBlank(trailingName) && className.length() == trailingName.length() + 1 && className.endsWith(trailingName)) {
            return className.substring(0, 1).toLowerCase();
        }
        return StringUtils.getLogicalName(StringUtils.getPropertyName(className), trailingName);
    }

    public static String getPropertyName(String name) {
        return StringUtils.getPropertyNameRepresentation(name);
    }

    public static String getPropertyName(Class<?> clazz) {
        return StringUtils.getPropertyNameRepresentation(clazz);
    }

    public static String getPropertyName(Method method) {
        Objects.requireNonNull(method, ERROR_METHOD_NULL);
        String name = method.getName();
        if (GETTER_PATTERN_1.matcher(name).matches() || SETTER_PATTERN.matcher(name).matches()) {
            return StringUtils.uncapitalize(name.substring(3));
        }
        if (GETTER_PATTERN_2.matcher(name).matches()) {
            return StringUtils.uncapitalize(name.substring(2));
        }
        return name;
    }

    public static String getPropertyNameRepresentation(Class<?> targetClass) {
        String shortName = StringUtils.getShortName(targetClass);
        return StringUtils.getPropertyNameRepresentation(shortName);
    }

    public static String getPropertyNameRepresentation(String name) {
        if (StringUtils.isBlank(name)) {
            return name;
        }
        int pos = name.lastIndexOf(".");
        if (pos != -1) {
            name = name.substring(pos + 1);
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(0)) && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        String propertyName = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        if (propertyName.contains(" ")) {
            propertyName = propertyName.replaceAll("\\s", "");
        }
        return propertyName;
    }

    public static String getPropertyNameForLowerCaseHyphenSeparatedName(String name) {
        return StringUtils.getPropertyName(StringUtils.getClassNameForLowerCaseHyphenSeparatedName(name));
    }

    public static String getShortName(Class<?> targetClass) {
        String className = targetClass.getName();
        return StringUtils.getShortName(className);
    }

    public static String getShortName(String className) {
        if (StringUtils.isBlank(className)) {
            return className;
        }
        int i = className.lastIndexOf(".");
        if (i > -1) {
            className = className.substring(i + 1, className.length());
        }
        return className;
    }

    public static String getNaturalName(String name) {
        char[] chars;
        if (StringUtils.isBlank(name = StringUtils.getShortName(name))) {
            return name;
        }
        ArrayList<String> words = new ArrayList<String>();
        int i = 0;
        for (char c : chars = name.toCharArray()) {
            String w;
            if (i >= words.size()) {
                w = "";
                words.add(i, w);
            } else {
                w = (String)words.get(i);
            }
            if (Character.isLowerCase(c) || Character.isDigit(c)) {
                if (Character.isLowerCase(c) && w.length() == 0) {
                    c = Character.toUpperCase(c);
                } else if (w.length() > 1 && Character.isUpperCase(w.charAt(w.length() - 1))) {
                    w = "";
                    words.add(++i, w);
                }
                words.set(i, w + c);
                continue;
            }
            if (!Character.isUpperCase(c)) continue;
            if (i == 0 && w.length() == 0 || Character.isUpperCase(w.charAt(w.length() - 1))) {
                words.set(i, w + c);
                continue;
            }
            words.add(++i, String.valueOf(c));
        }
        StringBuilder buf = new StringBuilder();
        Iterator j = words.iterator();
        while (j.hasNext()) {
            String word = (String)j.next();
            buf.append(word);
            if (!j.hasNext()) continue;
            buf.append(" ");
        }
        return buf.toString();
    }

    public static boolean isBlank(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        for (char c : str.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static String requireNonBlank(String str) {
        if (StringUtils.isBlank(str)) {
            throw new IllegalArgumentException();
        }
        return str;
    }

    public static String requireNonBlank(String str, String message) {
        if (StringUtils.isBlank(str)) {
            throw new IllegalArgumentException(message);
        }
        return str;
    }

    public static String getHyphenatedName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return StringUtils.getHyphenatedName(clazz.getName());
    }

    public static String getHyphenatedName(String name) {
        if (StringUtils.isBlank(name)) {
            return name;
        }
        if (name.endsWith(".groovy")) {
            name = name.substring(0, name.length() - 7);
        }
        String naturalName = StringUtils.getNaturalName(StringUtils.getShortName(name));
        return naturalName.replaceAll("\\s", "-").toLowerCase();
    }

    public static String uncapitalize(String str) {
        if (StringUtils.isBlank(str)) {
            return str;
        }
        if (str.length() == 1) {
            return String.valueOf(Character.toLowerCase(str.charAt(0)));
        }
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public static Object splitValue(String value) {
        if (StringUtils.isBlank(value) || value.length() == 1) {
            return value;
        }
        char splitter = value.charAt(value.length() - 1);
        return Arrays.asList(value.substring(0, value.length() - 1).split(StringUtils.escape(splitter)));
    }

    private static String escape(char character) {
        switch (character) {
            case '$': 
            case '(': 
            case ')': 
            case '.': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                return "\\" + character;
            }
        }
        return "" + character;
    }

    public static String padLeft(String str, int numChars) {
        return StringUtils.padLeft(str, numChars, " ");
    }

    public static String padLeft(String str, int numChars, String padding) {
        return numChars <= str.length() ? str : StringUtils.getPadding(padding.toString(), numChars - str.length()) + str;
    }

    public static String padRight(String str, int numChars) {
        return StringUtils.padRight(str, numChars, " ");
    }

    public static String padRight(String str, int numChars, String padding) {
        return numChars <= str.length() ? str : str + StringUtils.getPadding(padding, numChars - str.length());
    }

    private static String getPadding(String padding, int length) {
        return padding.length() < length ? StringUtils.times(padding, length / padding.length() + 1).substring(0, length) : "" + padding.subSequence(0, length);
    }

    public static String times(String str, int num) {
        if (num < 0) {
            throw new IllegalArgumentException("times() should be called with a number >= 0, got " + num);
        }
        if (num == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder(str);
        for (int i = 1; i < num; ++i) {
            b.append(str);
        }
        return b.toString();
    }

    public static String stripMargin(String str) {
        return Stream.of(str.split(System.lineSeparator())).map(String::trim).collect(Collectors.joining(System.lineSeparator()));
    }

    public static String escapeRegexChars(String str) {
        boolean start = false;
        boolean end = false;
        String s = str;
        if (s.charAt(0) == '^' && s.length() > 1) {
            start = true;
            s = s.substring(1);
        }
        if (s.charAt(s.length() - 1) == '$' && s.length() > 1) {
            end = true;
            s = s.substring(0, s.length() - 2);
        }
        String replaced = REGEX_CHARS.matcher(s).replaceAll("\\\\$0");
        return (start ? "^" : "") + replaced + (end ? "$" : "");
    }

    public static String toSafeRegexPattern(String str) {
        StringBuilder b = new StringBuilder();
        if (!str.startsWith("^")) {
            b.append(".*");
        }
        b.append(StringUtils.escapeRegexChars(str));
        if (!str.endsWith("$")) {
            b.append(".*");
        }
        return b.toString();
    }

    public static String normalizeRegexPattern(String str) {
        StringBuilder b = new StringBuilder();
        if (!str.startsWith("^")) {
            b.append(".*");
        }
        b.append(str);
        if (!str.endsWith("$")) {
            b.append(".*");
        }
        return b.toString();
    }

    public static Pattern toSafePattern(String str) {
        return Pattern.compile(StringUtils.toSafeRegexPattern(str));
    }

    public static boolean isTrue(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return "true".equalsIgnoreCase(String.valueOf(o).trim());
    }

    public static String quote(String str) {
        if (StringUtils.isBlank(str)) {
            return str;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            str = StringUtils.applyQuotes(str);
            break;
        }
        return str;
    }

    public static String unquote(String str) {
        if (StringUtils.isBlank(str)) {
            return str;
        }
        if (str.startsWith("'") && str.endsWith("'") || str.startsWith("\"") && str.endsWith("\"")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    private static String applyQuotes(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len * 2);
        char[] chars = string.toCharArray();
        char[] buffer = new char[1030];
        int bufferIndex = 0;
        sb.append('\"');
        block11: for (int i = 0; i < len; ++i) {
            if (bufferIndex > 1024) {
                sb.append(buffer, 0, bufferIndex);
                bufferIndex = 0;
            }
            char b = c;
            c = chars[i];
            switch (c) {
                case '\"': 
                case '\\': {
                    buffer[bufferIndex++] = 92;
                    buffer[bufferIndex++] = c;
                    continue block11;
                }
                case '/': {
                    if (b == '<') {
                        buffer[bufferIndex++] = 92;
                    }
                    buffer[bufferIndex++] = c;
                    continue block11;
                }
                default: {
                    if (c < ' ') {
                        switch (c) {
                            case '\b': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 98;
                                continue block11;
                            }
                            case '\t': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 116;
                                continue block11;
                            }
                            case '\n': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 110;
                                continue block11;
                            }
                            case '\f': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 102;
                                continue block11;
                            }
                            case '\r': {
                                buffer[bufferIndex++] = 92;
                                buffer[bufferIndex++] = 114;
                                continue block11;
                            }
                        }
                        String t = "000" + Integer.toHexString(c);
                        int tLength = t.length();
                        buffer[bufferIndex++] = 92;
                        buffer[bufferIndex++] = 117;
                        buffer[bufferIndex++] = t.charAt(tLength - 4);
                        buffer[bufferIndex++] = t.charAt(tLength - 3);
                        buffer[bufferIndex++] = t.charAt(tLength - 2);
                        buffer[bufferIndex++] = t.charAt(tLength - 1);
                        continue block11;
                    }
                    buffer[bufferIndex++] = c;
                }
            }
        }
        sb.append(buffer, 0, bufferIndex);
        sb.append('\"');
        return sb.toString();
    }
}

