/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.tools;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Project;
import org.jreleaser.model.Spec;
import org.jreleaser.model.tool.spi.ToolProcessingException;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.tools.AbstractRepositoryToolProcessor;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.StringUtils;

public class SpecToolProcessor
extends AbstractRepositoryToolProcessor<Spec> {
    public SpecToolProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPrepareDistribution(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
        this.setupJavaBinary(distribution, props);
        super.doPrepareDistribution(distribution, props);
    }

    private void setupJavaBinary(Distribution distribution, Map<String, Object> props) throws ToolProcessingException {
        Artifact artifact = (Artifact)props.get("distributionArtifact");
        Path artifactPath = artifact.getResolvedPath();
        String artifactName = StringUtils.getFilename((String)artifactPath.getFileName().toString(), (Collection)((Spec)this.tool).getSupportedExtensions());
        try {
            List entries = FileUtils.inspectArchive((Path)artifactPath);
            LinkedHashSet directories = new LinkedHashSet();
            ArrayList binaries = new ArrayList();
            ArrayList files = new ArrayList();
            entries.stream().filter(e -> !e.endsWith(distribution.getExecutableExtension())).filter(e -> !e.endsWith("/")).map(e -> e.substring(artifactName.length() + 1)).filter(e -> e.startsWith("bin/")).sorted().forEach(entry -> {
                String[] parts = entry.split("/");
                binaries.add(parts[1]);
            });
            entries.stream().filter(e -> !e.endsWith(distribution.getExecutableExtension())).filter(e -> !e.endsWith("/")).map(e -> e.substring(artifactName.length() + 1)).filter(e -> !e.startsWith("bin/")).sorted().forEach(entry -> {
                String[] parts = entry.split("/");
                if (parts.length > 1) {
                    directories.add(parts[0]);
                }
                files.add(entry.replace(this.context.getModel().getProject().getResolvedVersion(), "%{version}").replace(this.context.getModel().getProject().getEffectiveVersion(), "%{version}"));
            });
            props.put("specDirectories", directories);
            props.put("specBinaries", binaries);
            props.put("specFiles", files);
        }
        catch (IOException e2) {
            throw new ToolProcessingException("ERROR", (Throwable)e2);
        }
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, Map<String, Object> props, Path packageDirectory) throws ToolProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(distribution, props);
    }

    @Override
    protected void fillToolProperties(Map<String, Object> props, Distribution distribution) throws ToolProcessingException {
        props.put("specPackageName", ((Spec)this.tool).getPackageName());
        props.put("specRelease", ((Spec)this.tool).getRelease());
        props.put("specRequires", ((Spec)this.tool).getRequires());
    }

    @Override
    protected void writeFile(Project project, Distribution distribution, String content, Map<String, Object> props, Path outputDirectory, String fileName) throws ToolProcessingException {
        Path outputFile = "app.spec".equals(fileName = TemplateUtils.trimTplExtension((String)fileName)) ? outputDirectory.resolve(((Spec)this.tool).getPackageName().concat(".spec")) : outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }

    @Override
    protected boolean isSkipped(Artifact artifact) {
        return StringUtils.isTrue(artifact.getExtraProperties().get("skipSpec"));
    }
}

