/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.util.bootstrap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.objectweb.carol.util.bootstrap.JVMConfiguration;
import org.objectweb.carol.util.bootstrap.RemoteProcessesManager;

public class RemoteShell {
    private static Options cmdLineOptions = null;
    private static RemoteProcessesManager procServer;
    public static String HOST_LOCATION;
    public static int PORT_NUMBER;

    public static void printHelp(Options cmdLineOptions) {
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp("Remot Proc Daemon Shell [options...]", cmdLineOptions);
    }

    public static void main(String[] args) {
        cmdLineOptions = new Options();
        cmdLineOptions.addOption('l', "host location", true, "Host location", false, false);
        cmdLineOptions.addOption('p', "port", true, "daemon rmi port number", false, false);
        cmdLineOptions.addOption('c', "command", true, "start a command and exit", false, false);
        cmdLineOptions.addOption('h', "help", false, "print this message and exit", false, false);
        CommandLine cmd = null;
        try {
            cmd = cmdLineOptions.parse(args, true);
        }
        catch (ParseException e) {
            System.err.println("\n" + e.getMessage());
            RemoteShell.printHelp(cmdLineOptions);
            System.err.println();
            System.exit(1);
        }
        if (cmd.hasOption('h')) {
            RemoteShell.printHelp(cmdLineOptions);
            System.exit(1);
        }
        if (cmd.hasOption('p')) {
            PORT_NUMBER = new Integer(cmd.getOptionValue('p'));
        }
        if (cmd.hasOption('l')) {
            HOST_LOCATION = cmd.getOptionValue('l');
        }
        Properties iprop = new Properties();
        iprop.put("java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory");
        iprop.put("java.naming.provider.url", "rmi://" + HOST_LOCATION + ":" + PORT_NUMBER);
        try {
            InitialContext in = new InitialContext(iprop);
            procServer = (RemoteProcessesManager)in.lookup("proc");
        }
        catch (Exception e) {
            System.out.println("Can not start shell, can not contact rproc server" + e);
        }
        if (cmd.hasOption('c')) {
            String procCmd = cmd.getOptionValue('c');
            RemoteShell.startCommandLine(procCmd);
            System.exit(0);
        }
        try {
            System.out.println("Connecting to remote proc : rmi://" + HOST_LOCATION + ":" + PORT_NUMBER);
            System.out.println("Start entering lines to manage remote processes");
            System.out.println("(use \"stop\" to stop)...");
            BufferedReader infile = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("proc>");
            String line = infile.readLine();
            while (!(line.equalsIgnoreCase("stop") || line.equalsIgnoreCase("quit") || line.equalsIgnoreCase("exit"))) {
                RemoteShell.startCommandLine(line);
                System.out.print("proc>");
                line = infile.readLine();
            }
            System.out.println("ciao !");
            infile.close();
        }
        catch (Exception e) {
            System.err.println(e);
            return;
        }
    }

    public static void startCommandLine(String line) {
        block18: {
            try {
                if (line.trim().equals("")) break block18;
                if (line.trim().startsWith("help") || line.trim().startsWith("?")) {
                    RemoteShell.printHelpProcess();
                    break block18;
                }
                if (line.trim().equalsIgnoreCase("list")) {
                    RemoteShell.printList();
                    break block18;
                }
                if (line.trim().startsWith("conf")) {
                    RemoteShell.printConf(line);
                    break block18;
                }
                if (line.trim().startsWith("ping")) {
                    RemoteShell.printPing(line);
                    break block18;
                }
                if (line.trim().startsWith("exitv")) {
                    RemoteShell.printExitValue(line);
                    break block18;
                }
                if (line.trim().equalsIgnoreCase("killall")) {
                    procServer.killAllProcesses();
                    break block18;
                }
                if (line.trim().startsWith("kill")) {
                    RemoteShell.killProcess(line);
                    break block18;
                }
                if (line.trim().startsWith("java") || line.trim().startsWith("dirjava")) {
                    RemoteShell.launchJVM(line);
                    break block18;
                }
                if (line.trim().startsWith("proc") || line.trim().startsWith("dirproc")) {
                    RemoteShell.launchProcess(line);
                    break block18;
                }
                if (line.trim().startsWith("errput")) {
                    RemoteShell.printError(line);
                    break block18;
                }
                if (line.trim().startsWith("output")) {
                    RemoteShell.printOutput(line);
                    break block18;
                }
                if (line.trim().startsWith("input")) {
                    RemoteShell.writeInput(line);
                    break block18;
                }
                if (line.trim().startsWith("copy")) {
                    RemoteShell.copyFile(line);
                    break block18;
                }
                if (line.trim().startsWith("stopd")) {
                    try {
                        procServer.stop();
                    }
                    catch (Exception e) {
                        System.out.println("deamon stopped, get out of the shell");
                        System.exit(0);
                    }
                    break block18;
                }
                System.out.println("Unreconized function:" + line);
                RemoteShell.printHelpProcess();
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    private static void printList() throws Exception {
        try {
            Hashtable procHash = procServer.getAllProcess();
            Enumeration e = procHash.keys();
            while (e.hasMoreElements()) {
                String skey = (String)e.nextElement();
                System.out.println("Process : " + skey + " command : " + (String)procHash.get(skey));
            }
        }
        catch (Exception e) {
            System.out.println("Error in printlist: " + e);
        }
    }

    private static void printConf(String line) throws Exception {
        block3: {
            try {
                StringTokenizer st = new StringTokenizer(line);
                if (st.countTokens() < 2) {
                    System.out.println("the conf function take a process name parametter:");
                    System.out.println("conf <process name>");
                    break block3;
                }
                st.nextToken();
                String procName = st.nextToken();
                System.out.println("The process " + procName + " is launch in directory: " + procServer.getProcessDirectory(procName));
                System.out.println("The process " + procName + " is launch with the command: " + procServer.getProcessCommand(procName));
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    private static void printPing(String line) throws Exception {
        block3: {
            try {
                StringTokenizer st = new StringTokenizer(line);
                if (st.countTokens() < 2) {
                    System.out.println("the ping function take a process name parametter:");
                    System.out.println("ping <process name>");
                    break block3;
                }
                st.nextToken();
                String procName = st.nextToken();
                System.out.println("" + procServer.pingProcess(procName));
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    private static void printExitValue(String line) throws Exception {
        block3: {
            try {
                StringTokenizer st = new StringTokenizer(line);
                if (st.countTokens() < 2) {
                    System.out.println("the exitv function take a process name parametter:");
                    System.out.println("exitv <process name>");
                    break block3;
                }
                st.nextToken();
                String procName = st.nextToken();
                System.out.println("" + procServer.getProcessExitValue(procName));
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    private static void killProcess(String line) throws Exception {
        block3: {
            try {
                StringTokenizer st = new StringTokenizer(line);
                if (st.countTokens() < 2) {
                    System.out.println("the kill function take a process name parametter:");
                    System.out.println("kill <process name>");
                    break block3;
                }
                st.nextToken();
                String procName = st.nextToken();
                procServer.killProcess(procName);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    private static void launchJVM(String line) throws Exception {
        if (line.trim().startsWith("java")) {
            StringTokenizer st = new StringTokenizer(line);
            st.nextToken();
            String jvmLine = "";
            while (st.hasMoreTokens()) {
                jvmLine = jvmLine + " " + st.nextToken();
            }
            System.out.println("jvm name: " + procServer.startJVM(new JVMConfiguration(jvmLine), null));
        } else if (line.trim().startsWith("dirjava")) {
            StringTokenizer st = new StringTokenizer(line);
            st.nextToken();
            String dirName = st.nextToken();
            String jvmLine = "";
            while (st.hasMoreTokens()) {
                jvmLine = jvmLine + " " + st.nextToken();
            }
            System.out.println("jvm name: " + procServer.startJVM(new JVMConfiguration(jvmLine), null, dirName));
        }
    }

    private static void launchProcess(String line) throws Exception {
        if (line.trim().startsWith("proc")) {
            StringTokenizer st = new StringTokenizer(line);
            st.nextToken();
            String procLine = "";
            while (st.hasMoreTokens()) {
                procLine = procLine + " " + st.nextToken();
            }
            System.out.println("process name: " + procServer.startProcess(procLine, null));
        } else if (line.trim().startsWith("dirproc")) {
            StringTokenizer st = new StringTokenizer(line);
            st.nextToken();
            String dirName = st.nextToken();
            String procLine = "";
            while (st.hasMoreTokens()) {
                procLine = procLine + " " + st.nextToken();
            }
            System.out.println("process name: " + procServer.startProcess(procLine, null, dirName));
        }
    }

    public static void printError(String line) throws Exception {
        StringTokenizer st = new StringTokenizer(line);
        if (st.countTokens() >= 2) {
            st.nextToken();
            String procName = st.nextToken();
            System.out.println("make ^C or kill the process for stop this process");
            while (true) {
                try {
                    Thread.sleep(3000L);
                    String es = procServer.readProcessError(procName);
                    if (es.trim().length() == 0) continue;
                    System.out.println(es);
                }
                catch (Exception e) {
                    System.out.println("Process connection killed");
                    System.exit(0);
                }
            }
        }
        System.out.println("the errput function take a process name parametter:");
        System.out.println("errput <process name>");
    }

    public static void printOutput(String line) throws Exception {
        StringTokenizer st = new StringTokenizer(line);
        if (st.countTokens() >= 2) {
            st.nextToken();
            String procName = st.nextToken();
            System.out.println("make ^C or kill the process for stop this process");
            while (true) {
                try {
                    Thread.sleep(3000L);
                    String es = procServer.readProcessOutput(procName);
                    if (es.trim().length() == 0) continue;
                    System.out.println(es);
                }
                catch (Exception e) {
                    System.out.println("Process connection killed");
                    System.exit(0);
                }
            }
        }
        System.out.println("the output function take a process name parametter:");
        System.out.println("output <process name>");
    }

    public static void writeInput(String line) throws Exception {
        StringTokenizer st = new StringTokenizer(line);
        if (st.countTokens() < 3) {
            System.out.println("the input function take a process name and line parametter:");
            System.out.println("input <process name> <line>");
        } else {
            st.nextToken();
            String procName = st.nextToken();
            String procLine = "";
            while (st.hasMoreTokens()) {
                procLine = procLine + " " + st.nextToken();
            }
            procServer.writeProcessInput(procName, procLine + "\n");
            System.out.println(procLine + " sended to " + procName);
        }
    }

    public static void copyFile(String line) throws Exception {
        StringTokenizer st = new StringTokenizer(line);
        if (st.countTokens() < 4) {
            System.out.println("the copy function take a process name and line parametter:");
            System.out.println("copy <local file> <remote dir> <remote name>");
        } else {
            st.nextToken();
            String asciiFile = st.nextToken();
            File f = new File(asciiFile);
            if (!f.exists() || f.isDirectory()) {
                throw new Exception("File not existed");
            }
            FileInputStream aInput = new FileInputStream(f);
            byte[] b = new byte[aInput.available()];
            aInput.read(b);
            aInput.close();
            String remoteDir = st.nextToken();
            String remoteName = st.nextToken();
            procServer.sendFile(remoteDir, remoteName, b);
        }
    }

    public static void printHelpProcess() {
        System.out.println("Remote Process shell commands:");
        System.out.println("help or ?                            -> print this help");
        System.out.println("list                                 -> list process names and command");
        System.out.println("conf   <process name>                -> get <process name> configuration");
        System.out.println("ping   <process name>                -> true if the process is alive");
        System.out.println("exitv  <process name>                -> exit value of the process (-1) if the process is alive");
        System.out.println("killall                              -> kill all process");
        System.out.println("kill     <process name>              -> kill the process <process name>");
        System.out.println("java     <cmd>                       -> launch a java command in arbitrary directory");
        System.out.println("proc     <string>                    -> launch a new process in arbitrary directory");
        System.out.println("dirjava  <dir>        <cmd>          -> launch a java command in dir (create if necessary)");
        System.out.println("dirproc  <dir>        <string>       -> launch a new process in dir (create if necessary)");
        System.out.println("output   <process name>              -> get output stream of the process every 3 seconds");
        System.out.println("errput   <process name>              -> get error stream of the process every 3 seconds");
        System.out.println("input    <process name> <string>     -> send a string to the input stream of a process");
        System.out.println("copy     <local file> <remote dir>");
        System.out.println("                      <remote name> -> copy ascii fille in dir (create if necessary)");
    }

    static {
        HOST_LOCATION = "localhost";
        PORT_NUMBER = 9090;
    }
}

