/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.compiler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.compiler.CodeGenerator;
import org.stringtemplate.v4.compiler.CompiledST;
import org.stringtemplate.v4.compiler.FormalArgument;
import org.stringtemplate.v4.compiler.STException;
import org.stringtemplate.v4.compiler.STLexer;
import org.stringtemplate.v4.compiler.STParser;
import org.stringtemplate.v4.misc.ErrorType;

public class Compiler {
    public static final String SUBTEMPLATE_PREFIX = "_sub";
    public static final int TEMPLATE_INITIAL_CODE_SIZE = 15;
    public static final Map<String, Interpreter.Option> supportedOptions = new HashMap<String, Interpreter.Option>(){
        {
            this.put("anchor", Interpreter.Option.ANCHOR);
            this.put("format", Interpreter.Option.FORMAT);
            this.put("null", Interpreter.Option.NULL);
            this.put("separator", Interpreter.Option.SEPARATOR);
            this.put("wrap", Interpreter.Option.WRAP);
        }
    };
    public static final int NUM_OPTIONS = supportedOptions.size();
    public static final Map<String, String> defaultOptionValues = new HashMap<String, String>(){
        {
            this.put("anchor", "true");
            this.put("wrap", "\n");
        }
    };
    public static Map<String, Short> funcs = new HashMap<String, Short>(){
        {
            this.put("first", (short)27);
            this.put("last", (short)28);
            this.put("rest", (short)29);
            this.put("trunc", (short)30);
            this.put("strip", (short)31);
            this.put("trim", (short)32);
            this.put("length", (short)33);
            this.put("strlen", (short)34);
            this.put("reverse", (short)35);
        }
    };
    public static int subtemplateCount = 0;
    public STGroup group;

    public Compiler() {
        this(STGroup.defaultGroup);
    }

    public Compiler(STGroup group) {
        this.group = group;
    }

    public CompiledST compile(String template) {
        CompiledST code = this.compile(null, null, null, template, null);
        code.hasFormalArgs = false;
        return code;
    }

    public CompiledST compile(String name, String template) {
        CompiledST code = this.compile(null, name, null, template, null);
        code.hasFormalArgs = false;
        return code;
    }

    public CompiledST compile(String srcName, String name, List<FormalArgument> args, String template, Token templateToken) {
        STParser.templateAndEOF_return r;
        ANTLRStringStream is = new ANTLRStringStream(template);
        is.name = srcName != null ? srcName : name;
        STLexer lexer = templateToken != null && templateToken.getType() == 6 ? new STLexer(this.group.errMgr, (CharStream)is, templateToken, this.group.delimiterStartChar, this.group.delimiterStopChar){

            @Override
            public Token nextToken() {
                Token t = super.nextToken();
                while (t.getType() == 32 || t.getType() == 31) {
                    t = super.nextToken();
                }
                return t;
            }
        } : new STLexer(this.group.errMgr, (CharStream)is, templateToken, this.group.delimiterStartChar, this.group.delimiterStopChar);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        STParser p = new STParser((TokenStream)tokens, this.group.errMgr, templateToken);
        try {
            r = p.templateAndEOF();
        }
        catch (RecognitionException re) {
            this.reportMessageAndThrowSTException((TokenStream)tokens, templateToken, p, re);
            return null;
        }
        if (p.getNumberOfSyntaxErrors() > 0 || r.getTree() == null) {
            CompiledST impl = new CompiledST();
            impl.defineFormalArgs(args);
            return impl;
        }
        CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)r.getTree());
        nodes.setTokenStream((TokenStream)tokens);
        CodeGenerator gen = new CodeGenerator((TreeNodeStream)nodes, this.group.errMgr, name, template, templateToken);
        CompiledST impl = null;
        try {
            impl = gen.template(name, args);
            impl.nativeGroup = this.group;
            impl.template = template;
            impl.ast = r.getTree();
            impl.ast.setUnknownTokenBoundaries();
            impl.tokens = tokens;
        }
        catch (RecognitionException re) {
            this.group.errMgr.internalError(null, "bad tree structure", re);
        }
        return impl;
    }

    public static CompiledST defineBlankRegion(CompiledST outermostImpl, Token nameToken) {
        String outermostTemplateName = outermostImpl.name;
        String mangled = STGroup.getMangledRegionName(outermostTemplateName, nameToken.getText());
        CompiledST blank = new CompiledST();
        blank.isRegion = true;
        blank.templateDefStartToken = nameToken;
        blank.regionDefType = ST.RegionType.IMPLICIT;
        blank.name = mangled;
        outermostImpl.addImplicitlyDefinedTemplate(blank);
        return blank;
    }

    public static String getNewSubtemplateName() {
        return SUBTEMPLATE_PREFIX + ++subtemplateCount;
    }

    protected void reportMessageAndThrowSTException(TokenStream tokens, Token templateToken, Parser parser, RecognitionException re) {
        if (re.token.getType() == -1) {
            String msg = "premature EOF";
            this.group.errMgr.compileTimeError(ErrorType.SYNTAX_ERROR, templateToken, re.token, msg);
        } else if (re instanceof NoViableAltException) {
            String msg = "'" + re.token.getText() + "' came as a complete surprise to me";
            this.group.errMgr.compileTimeError(ErrorType.SYNTAX_ERROR, templateToken, re.token, msg);
        } else if (tokens.index() == 0) {
            String msg = "this doesn't look like a template: \"" + tokens + "\"";
            this.group.errMgr.compileTimeError(ErrorType.SYNTAX_ERROR, templateToken, re.token, msg);
        } else if (tokens.LA(1) == 23) {
            String msg = "doesn't look like an expression";
            this.group.errMgr.compileTimeError(ErrorType.SYNTAX_ERROR, templateToken, re.token, msg);
        } else {
            String msg = parser.getErrorMessage(re, parser.getTokenNames());
            this.group.errMgr.compileTimeError(ErrorType.SYNTAX_ERROR, templateToken, re.token, msg);
        }
        throw new STException();
    }
}

