/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.classgen.BytecodeSequence;

public class ReturnAdder {
    private static final ReturnStatementListener DEFAULT_LISTENER = returnStatement -> {};
    private final ReturnStatementListener listener;
    private final boolean doAdd;

    public ReturnAdder() {
        this.listener = DEFAULT_LISTENER;
        this.doAdd = true;
    }

    public ReturnAdder(ReturnStatementListener listener) {
        this.listener = Objects.requireNonNull(listener);
        this.doAdd = false;
    }

    @Deprecated
    public static void addReturnIfNeeded(MethodNode node) {
        new ReturnAdder().visitMethod(node);
    }

    public void visitMethod(MethodNode node) {
        Statement code;
        if (!node.isVoidMethod() && (code = node.getCode()) != null) {
            code = this.addReturnsIfNeeded(code, node.getVariableScope());
            if (this.doAdd) {
                node.setCode(code);
            }
        }
    }

    private Statement addReturnsIfNeeded(Statement statement, VariableScope scope) {
        if (statement instanceof ReturnStatement || statement instanceof ThrowStatement || statement instanceof BytecodeSequence) {
            return statement;
        }
        if (statement instanceof EmptyStatement || statement == null) {
            ReturnStatement returnStatement2 = new ReturnStatement(GeneralUtils.nullX());
            this.listener.returnStatementAdded(returnStatement2);
            return returnStatement2;
        }
        if (statement instanceof ExpressionStatement) {
            Expression expression = ((ExpressionStatement)statement).getExpression();
            ReturnStatement returnStatement3 = new ReturnStatement(expression);
            returnStatement3.copyStatementLabels(statement);
            returnStatement3.setSourcePosition(statement);
            this.listener.returnStatementAdded(returnStatement3);
            return returnStatement3;
        }
        if (statement instanceof SynchronizedStatement) {
            SynchronizedStatement syncStatement = (SynchronizedStatement)statement;
            Statement code = this.addReturnsIfNeeded(syncStatement.getCode(), scope);
            if (this.doAdd) {
                syncStatement.setCode(code);
            }
            return syncStatement;
        }
        if (statement instanceof IfStatement) {
            IfStatement ifElseStatement = (IfStatement)statement;
            Statement ifBlock = this.addReturnsIfNeeded(ifElseStatement.getIfBlock(), scope);
            Statement elseBlock = this.addReturnsIfNeeded(ifElseStatement.getElseBlock(), scope);
            if (this.doAdd) {
                ifElseStatement.setIfBlock(ifBlock);
                ifElseStatement.setElseBlock(elseBlock);
            }
            return ifElseStatement;
        }
        if (statement instanceof SwitchStatement) {
            SwitchStatement switchStatement = (SwitchStatement)statement;
            for (CaseStatement caseStatement : switchStatement.getCaseStatements()) {
                Statement code = this.adjustSwitchCaseCode(caseStatement.getCode(), scope, false);
                if (!this.doAdd) continue;
                caseStatement.setCode(code);
            }
            Statement defaultStatement = this.adjustSwitchCaseCode(switchStatement.getDefaultStatement(), scope, true);
            if (this.doAdd) {
                switchStatement.setDefaultStatement(defaultStatement);
            }
            return switchStatement;
        }
        if (statement instanceof TryCatchStatement) {
            boolean hasFinally;
            TryCatchStatement tryCatchFinally = (TryCatchStatement)statement;
            boolean[] missesReturn = new boolean[1];
            new ReturnAdder(returnStatement -> {
                missesReturn[0] = true;
            }).addReturnsIfNeeded(tryCatchFinally.getFinallyStatement(), scope);
            boolean bl = hasFinally = !(tryCatchFinally.getFinallyStatement() instanceof EmptyStatement);
            if (hasFinally && !missesReturn[0]) {
                return tryCatchFinally;
            }
            Statement tryStatement = this.addReturnsIfNeeded(tryCatchFinally.getTryStatement(), scope);
            if (this.doAdd) {
                tryCatchFinally.setTryStatement(tryStatement);
            }
            for (CatchStatement catchStatement : tryCatchFinally.getCatchStatements()) {
                Statement code = this.addReturnsIfNeeded(catchStatement.getCode(), scope);
                if (!this.doAdd) continue;
                catchStatement.setCode(code);
            }
            return tryCatchFinally;
        }
        if (statement instanceof BlockStatement) {
            BlockStatement blockStatement = (BlockStatement)statement;
            if (blockStatement.isEmpty()) {
                ReturnStatement returnStatement4 = new ReturnStatement(GeneralUtils.nullX());
                returnStatement4.copyStatementLabels(blockStatement);
                returnStatement4.setSourcePosition(blockStatement);
                this.listener.returnStatementAdded(returnStatement4);
                return returnStatement4;
            }
            List<Statement> statements = blockStatement.getStatements();
            int lastIndex = statements.size() - 1;
            Statement last = this.addReturnsIfNeeded(statements.get(lastIndex), blockStatement.getVariableScope());
            if (this.doAdd) {
                statements.set(lastIndex, last);
            }
            if (!ReturnAdder.returns(last)) {
                ReturnStatement returnStatement5 = new ReturnStatement(GeneralUtils.nullX());
                this.listener.returnStatementAdded(returnStatement5);
                if (this.doAdd) {
                    statements.add(returnStatement5);
                }
            }
            return blockStatement;
        }
        ArrayList<Statement> statements = new ArrayList<Statement>(2);
        statements.add(statement);
        ReturnStatement returnStatement6 = new ReturnStatement(GeneralUtils.nullX());
        this.listener.returnStatementAdded(returnStatement6);
        statements.add(returnStatement6);
        BlockStatement blockStatement = new BlockStatement(statements, new VariableScope(scope));
        blockStatement.setSourcePosition(statement);
        return blockStatement;
    }

    private Statement adjustSwitchCaseCode(Statement statement, VariableScope scope, boolean defaultCase) {
        List<Statement> statements;
        if (statement instanceof BlockStatement && !(statements = ((BlockStatement)statement).getStatements()).isEmpty()) {
            int lastIndex = statements.size() - 1;
            Statement last = statements.get(lastIndex);
            if (last instanceof BreakStatement) {
                if (this.doAdd) {
                    statements.remove(lastIndex);
                    return this.addReturnsIfNeeded(statement, scope);
                }
                BlockStatement newBlock = new BlockStatement();
                for (int i = 0; i < lastIndex; ++i) {
                    newBlock.addStatement(statements.get(i));
                }
                return this.addReturnsIfNeeded(newBlock, scope);
            }
            if (defaultCase) {
                return this.addReturnsIfNeeded(statement, scope);
            }
        }
        return statement;
    }

    private static boolean returns(Statement statement) {
        return statement instanceof ReturnStatement || statement instanceof BlockStatement || statement instanceof IfStatement || statement instanceof ExpressionStatement || statement instanceof EmptyStatement || statement instanceof TryCatchStatement || statement instanceof ThrowStatement || statement instanceof SynchronizedStatement || statement instanceof BytecodeSequence;
    }

    @FunctionalInterface
    public static interface ReturnStatementListener {
        public void returnStatementAdded(ReturnStatement var1);
    }
}

