/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjaropenbeans;

import groovyjarjaropenbeans.BeanInfo;
import groovyjarjaropenbeans.IntrospectionException;
import groovyjarjaropenbeans.StandardBeanInfo;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public class Introspector {
    public static final int IGNORE_ALL_BEANINFO = 3;
    public static final int IGNORE_IMMEDIATE_BEANINFO = 2;
    public static final int USE_ALL_BEANINFO = 1;
    private static final String DEFAULT_BEANINFO_SEARCHPATH = "sun.beans.infos";
    private static String[] searchPath = new String[]{"sun.beans.infos"};
    private static final int DEFAULT_CAPACITY = 128;
    private static Map<Class<?>, StandardBeanInfo> theCache = Collections.synchronizedMap(new WeakHashMap(128));

    private Introspector() {
    }

    public static String decapitalize(String name) {
        if (name == null) {
            return null;
        }
        if (name.length() == 0 || name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static void flushCaches() {
        theCache.clear();
    }

    public static void flushFromCaches(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        theCache.remove(clazz);
    }

    public static BeanInfo getBeanInfo(Class<?> beanClass) throws IntrospectionException {
        StandardBeanInfo beanInfo = theCache.get(beanClass);
        if (beanInfo == null) {
            beanInfo = Introspector.getBeanInfoImplAndInit(beanClass, null, 1);
            theCache.put(beanClass, beanInfo);
        }
        return beanInfo;
    }

    public static BeanInfo getBeanInfo(Class<?> beanClass, Class<?> stopClass) throws IntrospectionException {
        if (stopClass == null) {
            return Introspector.getBeanInfo(beanClass);
        }
        return Introspector.getBeanInfoImplAndInit(beanClass, stopClass, 1);
    }

    public static BeanInfo getBeanInfo(Class<?> beanClass, int flags) throws IntrospectionException {
        if (flags == 1) {
            return Introspector.getBeanInfo(beanClass);
        }
        return Introspector.getBeanInfoImplAndInit(beanClass, null, flags);
    }

    public static String[] getBeanInfoSearchPath() {
        String[] path = new String[searchPath.length];
        System.arraycopy(searchPath, 0, path, 0, searchPath.length);
        return path;
    }

    public static void setBeanInfoSearchPath(String[] path) {
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPropertiesAccess();
        }
        searchPath = path;
    }

    private static StandardBeanInfo getBeanInfoImpl(Class<?> beanClass, Class<?> stopClass, int flags) throws IntrospectionException {
        Class<?> beanSuperClass;
        BeanInfo explicitInfo = null;
        if (flags == 1) {
            explicitInfo = Introspector.getExplicitBeanInfo(beanClass);
        }
        StandardBeanInfo beanInfo = new StandardBeanInfo(beanClass, explicitInfo, stopClass);
        if (beanInfo.additionalBeanInfo != null) {
            int i = beanInfo.additionalBeanInfo.length - 1;
            while (i >= 0) {
                BeanInfo info = beanInfo.additionalBeanInfo[i];
                beanInfo.mergeBeanInfo(info, true);
                --i;
            }
        }
        if ((beanSuperClass = beanClass.getSuperclass()) != stopClass) {
            if (beanSuperClass == null) {
                throw new IntrospectionException("Stop class is not super class of bean class");
            }
            int superflags = flags == 2 ? 1 : flags;
            StandardBeanInfo superBeanInfo = Introspector.getBeanInfoImpl(beanSuperClass, stopClass, superflags);
            if (superBeanInfo != null) {
                beanInfo.mergeBeanInfo(superBeanInfo, false);
            }
        }
        return beanInfo;
    }

    /*
     * Unable to fully structure code
     */
    private static BeanInfo getExplicitBeanInfo(Class<?> beanClass) {
        beanInfoClassName = String.valueOf(beanClass.getName()) + "BeanInfo";
        try {
            return Introspector.loadBeanInfo(beanInfoClassName, beanClass);
        }
        catch (Exception var2_2) {
            index = beanInfoClassName.lastIndexOf(46);
            beanInfoName = index >= 0 ? beanInfoClassName.substring(index + 1) : beanInfoClassName;
            theBeanInfo = null;
            beanDescriptor = null;
            i = 0;
            ** while (i < Introspector.searchPath.length)
        }
lbl-1000:
        // 1 sources

        {
            block9: {
                beanInfoClassName = String.valueOf(Introspector.searchPath[i]) + "." + beanInfoName;
                try {
                    theBeanInfo = Introspector.loadBeanInfo(beanInfoClassName, beanClass);
                }
                catch (Exception e) {
                    break block9;
                }
                beanDescriptor = theBeanInfo.getBeanDescriptor();
                if (beanDescriptor != null && beanClass == beanDescriptor.getBeanClass()) {
                    return theBeanInfo;
                }
            }
            ++i;
            continue;
        }
lbl23:
        // 1 sources

        if (BeanInfo.class.isAssignableFrom(beanClass)) {
            try {
                return Introspector.loadBeanInfo(beanClass.getName(), beanClass);
            }
            catch (Exception var6_8) {
                // empty catch block
            }
        }
        return null;
    }

    private static BeanInfo loadBeanInfo(String beanInfoClassName, Class<?> beanClass) throws Exception {
        try {
            ClassLoader cl = beanClass.getClassLoader();
            if (cl != null) {
                return (BeanInfo)Class.forName(beanInfoClassName, true, beanClass.getClassLoader()).newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return (BeanInfo)Class.forName(beanInfoClassName, true, ClassLoader.getSystemClassLoader()).newInstance();
        }
        catch (Exception exception) {
            return (BeanInfo)Class.forName(beanInfoClassName, true, Thread.currentThread().getContextClassLoader()).newInstance();
        }
    }

    private static StandardBeanInfo getBeanInfoImplAndInit(Class<?> beanClass, Class<?> stopClass, int flag) throws IntrospectionException {
        StandardBeanInfo standardBeanInfo = Introspector.getBeanInfoImpl(beanClass, stopClass, flag);
        standardBeanInfo.init();
        return standardBeanInfo;
    }
}

