/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.collect;

import java.util.Objects;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.DependencyCollector;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DependencyCollectorDelegate
implements DependencyCollector {
    protected static final String CONFIG_PROP_MAX_EXCEPTIONS = "aether.dependencyCollector.maxExceptions";
    protected static final int CONFIG_PROP_MAX_EXCEPTIONS_DEFAULT = 50;
    protected static final String CONFIG_PROP_MAX_CYCLES = "aether.dependencyCollector.maxCycles";
    protected static final int CONFIG_PROP_MAX_CYCLES_DEFAULT = 10;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected RemoteRepositoryManager remoteRepositoryManager;
    protected ArtifactDescriptorReader descriptorReader;
    protected VersionRangeResolver versionRangeResolver;

    public DependencyCollectorDelegate() {
    }

    protected DependencyCollectorDelegate(RemoteRepositoryManager remoteRepositoryManager, ArtifactDescriptorReader artifactDescriptorReader, VersionRangeResolver versionRangeResolver) {
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setArtifactDescriptorReader(artifactDescriptorReader);
        this.setVersionRangeResolver(versionRangeResolver);
    }

    public void initService(ServiceLocator locator) {
        this.setRemoteRepositoryManager((RemoteRepositoryManager)locator.getService(RemoteRepositoryManager.class));
        this.setArtifactDescriptorReader((ArtifactDescriptorReader)locator.getService(ArtifactDescriptorReader.class));
        this.setVersionRangeResolver((VersionRangeResolver)locator.getService(VersionRangeResolver.class));
    }

    public DependencyCollector setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remote repository manager cannot be null");
        return this;
    }

    public DependencyCollector setArtifactDescriptorReader(ArtifactDescriptorReader artifactDescriptorReader) {
        this.descriptorReader = Objects.requireNonNull(artifactDescriptorReader, "artifact descriptor reader cannot be null");
        return this;
    }

    public DependencyCollector setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        this.versionRangeResolver = Objects.requireNonNull(versionRangeResolver, "version range resolver cannot be null");
        return this;
    }
}

