/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.AnnotationUtils;
import io.micronaut.annotation.processing.ModelUtils;
import io.micronaut.annotation.processing.PublicMethodVisitor;
import io.micronaut.annotation.processing.SuperclassAwareTypeVisitor;
import io.micronaut.annotation.processing.visitor.AbstractJavaElement;
import io.micronaut.annotation.processing.visitor.JavaConstructorElement;
import io.micronaut.annotation.processing.visitor.JavaElementFactory;
import io.micronaut.annotation.processing.visitor.JavaGenericPlaceholderElement;
import io.micronaut.annotation.processing.visitor.JavaMethodElement;
import io.micronaut.annotation.processing.visitor.JavaPackageElement;
import io.micronaut.annotation.processing.visitor.JavaPropertyElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AccessorsStyle;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ArrayableClassElement;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.WildcardElement;
import io.micronaut.inject.processing.JavaModelUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@Internal
public class JavaClassElement
extends AbstractJavaElement
implements ArrayableClassElement {
    protected final TypeElement classElement;
    protected final JavaVisitorContext visitorContext;
    final List<? extends TypeMirror> typeArguments;
    private final int arrayDimensions;
    private final boolean isTypeVariable;
    private List<PropertyElement> beanProperties;
    private Map<String, Map<String, TypeMirror>> genericTypeInfo;
    private List<? extends javax.lang.model.element.Element> enclosedElements;
    private String simpleName;
    private String name;
    private String packageName;

    @Internal
    public JavaClassElement(TypeElement classElement, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext) {
        this(classElement, annotationMetadata, visitorContext, Collections.emptyList(), null, 0, false);
    }

    JavaClassElement(TypeElement classElement, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext, List<? extends TypeMirror> typeArguments, Map<String, Map<String, TypeMirror>> genericsInfo) {
        this(classElement, annotationMetadata, visitorContext, typeArguments, genericsInfo, 0, false);
    }

    JavaClassElement(TypeElement classElement, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext, List<? extends TypeMirror> typeArguments, Map<String, Map<String, TypeMirror>> genericsInfo, int arrayDimensions) {
        this(classElement, annotationMetadata, visitorContext, typeArguments, genericsInfo, arrayDimensions, false);
    }

    JavaClassElement(TypeElement classElement, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext, List<? extends TypeMirror> typeArguments, Map<String, Map<String, TypeMirror>> genericsInfo, boolean isTypeVariable) {
        this(classElement, annotationMetadata, visitorContext, typeArguments, genericsInfo, 0, isTypeVariable);
    }

    JavaClassElement(TypeElement classElement, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext, List<? extends TypeMirror> typeArguments, Map<String, Map<String, TypeMirror>> genericsInfo, int arrayDimensions, boolean isTypeVariable) {
        super(classElement, annotationMetadata, visitorContext);
        this.classElement = classElement;
        this.visitorContext = visitorContext;
        this.typeArguments = typeArguments;
        this.genericTypeInfo = genericsInfo;
        this.arrayDimensions = arrayDimensions;
        this.isTypeVariable = isTypeVariable;
    }

    public boolean isTypeVariable() {
        return this.isTypeVariable;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public boolean isInner() {
        return this.classElement.getNestingKind().isNested();
    }

    public boolean isRecord() {
        return JavaModelUtils.isRecord((javax.lang.model.element.Element)this.classElement);
    }

    @NonNull
    public Map<String, ClassElement> getTypeArguments(@NonNull String type) {
        Map<String, Map<String, TypeMirror>> data;
        Map<String, TypeMirror> forType;
        if (StringUtils.isNotEmpty((CharSequence)type) && (forType = (data = this.visitorContext.getGenericUtils().buildGenericTypeArgumentElementInfo(this.classElement, null, this.getBoundTypeMirrors())).get(type)) != null) {
            LinkedHashMap<String, ClassElement> typeArgs = new LinkedHashMap<String, ClassElement>(forType.size());
            for (Map.Entry<String, TypeMirror> entry : forType.entrySet()) {
                ClassElement ce;
                TypeMirror v = entry.getValue();
                ClassElement classElement = ce = v != null ? this.mirrorToClassElement(v, this.visitorContext, Collections.emptyMap(), this.visitorContext.getConfiguration().includeTypeLevelAnnotationsInGenericArguments()) : null;
                if (ce == null) {
                    return Collections.emptyMap();
                }
                typeArgs.put(entry.getKey(), ce);
            }
            return Collections.unmodifiableMap(typeArgs);
        }
        return Collections.emptyMap();
    }

    public boolean isPrimitive() {
        return ClassUtils.getPrimitiveType((String)this.getName()).isPresent();
    }

    public Collection<ClassElement> getInterfaces() {
        List<? extends TypeMirror> interfaces = this.classElement.getInterfaces();
        if (!interfaces.isEmpty()) {
            return Collections.unmodifiableList(interfaces.stream().map(mirror -> this.mirrorToClassElement((TypeMirror)mirror, this.visitorContext, this.genericTypeInfo)).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    public Optional<ClassElement> getSuperType() {
        javax.lang.model.element.Element element;
        TypeMirror superclass = this.classElement.getSuperclass();
        if (superclass != null && (element = this.visitorContext.getTypes().asElement(superclass)) instanceof TypeElement) {
            TypeElement superElement = (TypeElement)element;
            if (!Object.class.getName().equals(superElement.getQualifiedName().toString())) {
                if (superclass instanceof DeclaredType && !((DeclaredType)superclass).getTypeArguments().isEmpty()) {
                    return Optional.of(this.parameterizedClassElement(superclass, this.visitorContext, this.visitorContext.getGenericUtils().buildGenericTypeArgumentElementInfo(this.classElement, null, this.getBoundTypeMirrors())));
                }
                return Optional.of(new JavaClassElement(superElement, this.visitorContext.getAnnotationUtils().getAnnotationMetadata(superElement), this.visitorContext));
            }
        }
        return Optional.empty();
    }

    @Override
    public boolean isAbstract() {
        return this.classElement.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public boolean isInterface() {
        return JavaModelUtils.isInterface((javax.lang.model.element.Element)this.classElement);
    }

    public List<PropertyElement> getBeanProperties() {
        if (this.beanProperties == null) {
            final LinkedHashMap props = new LinkedHashMap();
            final LinkedHashMap fields = new LinkedHashMap();
            if (this.isRecord()) {
                this.classElement.asType().accept(new SuperclassAwareTypeVisitor<Object, Object>(this.visitorContext){

                    @Override
                    protected boolean isAcceptable(javax.lang.model.element.Element element) {
                        return JavaModelUtils.isRecord((javax.lang.model.element.Element)element);
                    }

                    @Override
                    public Object visitDeclared(DeclaredType type, Object o) {
                        javax.lang.model.element.Element element = type.asElement();
                        if (this.isAcceptable(element)) {
                            List<? extends javax.lang.model.element.Element> enclosedElements = element.getEnclosedElements();
                            for (javax.lang.model.element.Element element2 : enclosedElements) {
                                if (!JavaModelUtils.isRecordComponent((javax.lang.model.element.Element)element2) && !(element2 instanceof ExecutableElement) || element2.getKind() == ElementKind.CONSTRUCTOR) continue;
                                this.accept(type, element2, o);
                            }
                        }
                        return o;
                    }

                    @Override
                    protected void accept(DeclaredType type, javax.lang.model.element.Element element, Object o) {
                        String name = element.getSimpleName().toString();
                        if (element instanceof ExecutableElement) {
                            BeanPropertyData beanPropertyData = (BeanPropertyData)props.get(name);
                            if (beanPropertyData != null) {
                                beanPropertyData.getter = (ExecutableElement)element;
                            }
                        } else {
                            props.computeIfAbsent(name, propertyName -> {
                                BeanPropertyData beanPropertyData = new BeanPropertyData((String)propertyName);
                                beanPropertyData.declaringType = JavaClassElement.this;
                                beanPropertyData.type = JavaClassElement.this.mirrorToClassElement(element.asType(), JavaClassElement.this.visitorContext, JavaClassElement.this.genericTypeInfo, true);
                                return beanPropertyData;
                            });
                        }
                    }
                }, null);
            } else {
                this.classElement.asType().accept(new PublicMethodVisitor<Object, Object>(this.visitorContext){
                    final String[] readPrefixes;
                    final String[] writePrefixes;
                    {
                        super(visitorContext);
                        this.readPrefixes = JavaClassElement.this.getValue(AccessorsStyle.class, "readPrefixes", String[].class).orElse(new String[]{"get"});
                        this.writePrefixes = JavaClassElement.this.getValue(AccessorsStyle.class, "writePrefixes", String[].class).orElse(new String[]{"set"});
                    }

                    @Override
                    protected boolean isAcceptable(javax.lang.model.element.Element element) {
                        Set<Modifier> modifiers;
                        if (element.getKind() == ElementKind.FIELD) {
                            return true;
                        }
                        if (element.getKind() == ElementKind.METHOD && element instanceof ExecutableElement && (modifiers = element.getModifiers()).contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.STATIC)) {
                            ExecutableElement executableElement = (ExecutableElement)element;
                            String methodName = executableElement.getSimpleName().toString();
                            if (methodName.contains("$")) {
                                return false;
                            }
                            if (NameUtils.isReaderName((String)methodName, (String[])this.readPrefixes) && executableElement.getParameters().isEmpty()) {
                                return true;
                            }
                            return NameUtils.isWriterName((String)methodName, (String[])this.writePrefixes) && executableElement.getParameters().size() == 1;
                        }
                        return false;
                    }

                    @Override
                    protected void accept(DeclaredType declaringType, javax.lang.model.element.Element element, Object o) {
                        if (element instanceof VariableElement) {
                            fields.put(element.getSimpleName().toString(), (VariableElement)element);
                            return;
                        }
                        ExecutableElement executableElement = (ExecutableElement)element;
                        String methodName = executableElement.getSimpleName().toString();
                        TypeElement declaringTypeElement = (TypeElement)executableElement.getEnclosingElement();
                        if (NameUtils.isReaderName((String)methodName, (String[])this.readPrefixes) && executableElement.getParameters().isEmpty()) {
                            TypeMirror typeMirror;
                            ClassElement setterParameterType;
                            ClassElement getterReturnType;
                            String propertyName = NameUtils.getPropertyNameForGetter((String)methodName, (String[])this.readPrefixes);
                            TypeMirror returnType = executableElement.getReturnType();
                            if (returnType instanceof TypeVariable) {
                                TypeVariable tv = (TypeVariable)returnType;
                                String tvn = tv.toString();
                                ClassElement classElement = JavaClassElement.this.getTypeArguments().get(tvn);
                                getterReturnType = classElement != null ? classElement : JavaClassElement.this.mirrorToClassElement(returnType, JavaClassElement.this.visitorContext, JavaClassElement.this.genericTypeInfo, true);
                            } else {
                                getterReturnType = JavaClassElement.this.mirrorToClassElement(returnType, JavaClassElement.this.visitorContext, JavaClassElement.this.genericTypeInfo, true);
                            }
                            BeanPropertyData beanPropertyData = props.computeIfAbsent(propertyName, BeanPropertyData::new);
                            this.configureDeclaringType(declaringTypeElement, beanPropertyData);
                            beanPropertyData.type = getterReturnType;
                            beanPropertyData.getter = executableElement;
                            if (beanPropertyData.setter != null && !(setterParameterType = JavaClassElement.this.mirrorToClassElement(typeMirror = beanPropertyData.setter.getParameters().get(0).asType(), JavaClassElement.this.visitorContext, JavaClassElement.this.genericTypeInfo, true)).isAssignable(getterReturnType)) {
                                beanPropertyData.setter = null;
                            }
                        } else if (NameUtils.isWriterName((String)methodName, (String[])this.writePrefixes) && executableElement.getParameters().size() == 1) {
                            String propertyName = NameUtils.getPropertyNameForSetter((String)methodName, (String[])this.writePrefixes);
                            TypeMirror typeMirror = executableElement.getParameters().get(0).asType();
                            ClassElement setterParameterType = JavaClassElement.this.mirrorToClassElement(typeMirror, JavaClassElement.this.visitorContext, JavaClassElement.this.genericTypeInfo, true);
                            BeanPropertyData beanPropertyData = props.computeIfAbsent(propertyName, BeanPropertyData::new);
                            this.configureDeclaringType(declaringTypeElement, beanPropertyData);
                            ClassElement propertyType = beanPropertyData.type;
                            if (propertyType != null) {
                                if (propertyType.getName().equals(setterParameterType.getName())) {
                                    beanPropertyData.setter = executableElement;
                                }
                            } else {
                                beanPropertyData.setter = executableElement;
                            }
                        }
                    }

                    private void configureDeclaringType(TypeElement declaringTypeElement, BeanPropertyData beanPropertyData) {
                        if (beanPropertyData.declaringType == null && !JavaClassElement.this.classElement.equals(declaringTypeElement)) {
                            beanPropertyData.declaringType = JavaClassElement.this.mirrorToClassElement(declaringTypeElement.asType(), JavaClassElement.this.visitorContext, JavaClassElement.this.genericTypeInfo, true);
                        } else if (beanPropertyData.declaringType == null) {
                            beanPropertyData.declaringType = JavaClassElement.this.mirrorToClassElement(declaringTypeElement.asType(), JavaClassElement.this.visitorContext, JavaClassElement.this.genericTypeInfo, false);
                        }
                    }
                }, null);
            }
            if (!props.isEmpty()) {
                this.beanProperties = new ArrayList<PropertyElement>(props.size());
                for (Map.Entry entry : props.entrySet()) {
                    String propertyName = (String)entry.getKey();
                    final BeanPropertyData value = (BeanPropertyData)entry.getValue();
                    final VariableElement fieldElement = (VariableElement)fields.get(propertyName);
                    if (value.getter == null) continue;
                    ArrayList<javax.lang.model.element.Element> parents = new ArrayList<javax.lang.model.element.Element>();
                    if (fieldElement != null) {
                        parents.add(fieldElement);
                    }
                    if (value.setter != null) {
                        parents.add(value.setter);
                    }
                    final AnnotationMetadata annotationMetadata = !parents.isEmpty() ? this.visitorContext.getAnnotationUtils().getAnnotationMetadata(parents, (javax.lang.model.element.Element)value.getter) : this.visitorContext.getAnnotationUtils().newAnnotationBuilder().buildForMethod(value.getter);
                    JavaPropertyElement propertyElement = new JavaPropertyElement((ClassElement)(value.declaringType == null ? this : value.declaringType), value.getter, annotationMetadata, propertyName, value.type, value.setter == null, this.visitorContext){

                        @Override
                        public ClassElement getGenericType() {
                            TypeMirror propertyType = value.getter.getReturnType();
                            if (fieldElement != null) {
                                TypeMirror fieldType = fieldElement.asType();
                                if (JavaClassElement.this.visitorContext.getTypes().isAssignable(fieldType, propertyType)) {
                                    propertyType = fieldType;
                                }
                            }
                            Map<String, Map<String, TypeMirror>> declaredGenericInfo = JavaClassElement.this.getGenericTypeInfo();
                            return this.parameterizedClassElement(propertyType, JavaClassElement.this.visitorContext, declaredGenericInfo);
                        }

                        public Optional<String> getDocumentation() {
                            Elements elements = JavaClassElement.this.visitorContext.getElements();
                            String docComment = elements.getDocComment(value.getter);
                            return Optional.ofNullable(docComment);
                        }

                        public Optional<MethodElement> getWriteMethod() {
                            if (value.setter != null) {
                                return Optional.of(new JavaMethodElement(JavaClassElement.this, value.setter, JavaClassElement.this.visitorContext.getAnnotationUtils().newAnnotationBuilder().buildForMethod(value.setter), JavaClassElement.this.visitorContext));
                            }
                            return Optional.empty();
                        }

                        public Optional<MethodElement> getReadMethod() {
                            return Optional.of(new JavaMethodElement(JavaClassElement.this, value.getter, annotationMetadata, JavaClassElement.this.visitorContext));
                        }
                    };
                    this.beanProperties.add(propertyElement);
                }
                this.beanProperties = Collections.unmodifiableList(this.beanProperties);
            } else {
                this.beanProperties = Collections.emptyList();
            }
        }
        return Collections.unmodifiableList(this.beanProperties);
    }

    public <T extends Element> List<T> getEnclosedElements(@NonNull ElementQuery<T> query) {
        Objects.requireNonNull(query, "Query cannot be null");
        ElementQuery.Result result = query.result();
        ElementKind kind = this.getElementKind(result.getElementType());
        ArrayList<JavaClassElement> resultingElements = new ArrayList<JavaClassElement>();
        ArrayList<? extends javax.lang.model.element.Element> enclosedElements = new ArrayList<javax.lang.model.element.Element>(this.getDeclaredEnclosedElements());
        boolean onlyDeclared = result.isOnlyDeclared();
        boolean onlyAbstract = result.isOnlyAbstract();
        boolean onlyConcrete = result.isOnlyConcrete();
        boolean onlyInstance = result.isOnlyInstance();
        if (!onlyDeclared) {
            DeclaredType dt;
            TypeElement element;
            Elements elements = this.visitorContext.getElements();
            TypeMirror superclass = this.classElement.getSuperclass();
            while (superclass instanceof DeclaredType && !(element = (TypeElement)(dt = (DeclaredType)superclass).asElement()).getQualifiedName().toString().startsWith("java.lang.")) {
                List<? extends javax.lang.model.element.Element> superElements = element.getEnclosedElements();
                ArrayList<Object> elementsToAdd = new ArrayList<Object>(superElements.size());
                Iterator iterator = superElements.iterator();
                block7: while (iterator.hasNext()) {
                    javax.lang.model.element.Element superElement = (javax.lang.model.element.Element)iterator.next();
                    ElementKind elementKind = superElement.getKind();
                    if (elementKind != kind) continue;
                    for (javax.lang.model.element.Element element2 : enclosedElements) {
                        ExecutableElement executableElement;
                        if (!elements.hides(element2, superElement) && (element2.getKind() != ElementKind.METHOD || superElement.getKind() != ElementKind.METHOD || !elements.overrides((ExecutableElement)element2, executableElement = (ExecutableElement)superElement, this.classElement))) continue;
                        continue block7;
                    }
                    if (result.isOnlyInjected() && superElement.getKind() == ElementKind.METHOD) {
                        ExecutableElement methodCandidate = (ExecutableElement)superElement;
                        String string = this.classElement.getQualifiedName().toString();
                        String string2 = element.getQualifiedName().toString();
                        boolean isParent = !string2.equals(string);
                        ModelUtils javaModelUtils = this.visitorContext.getModelUtils();
                        ExecutableElement overridingMethod = javaModelUtils.overridingOrHidingMethod(methodCandidate, this.classElement, false).orElse(methodCandidate);
                        TypeElement overridingClass = javaModelUtils.classElementFor(overridingMethod);
                        boolean overridden = isParent && overridingClass != null && !overridingClass.getQualifiedName().toString().equals(string2);
                        boolean isPackagePrivate = javaModelUtils.isPackagePrivate(methodCandidate);
                        boolean isPrivate = methodCandidate.getModifiers().contains((Object)Modifier.PRIVATE);
                        if (overridden && !isPrivate && !isPackagePrivate) continue;
                        if (isParent && overridden) {
                            boolean isPackagePrivateAndPackagesDiffer;
                            boolean overriddenInjected = overridden && this.visitorContext.getAnnotationUtils().getAnnotationMetadata(overridingMethod).hasDeclaredAnnotation("javax.inject.Inject");
                            String packageOfOverridingClass = this.visitorContext.getElements().getPackageOf(overridingMethod).getQualifiedName().toString();
                            String packageOfDeclaringClass = this.visitorContext.getElements().getPackageOf(element).getQualifiedName().toString();
                            boolean bl = isPackagePrivateAndPackagesDiffer = overridden && isPackagePrivate && !packageOfOverridingClass.equals(packageOfDeclaringClass);
                            if (!overriddenInjected && !isPackagePrivateAndPackagesDiffer && !isPrivate) continue;
                        }
                    }
                    if (onlyAbstract && !superElement.getModifiers().contains((Object)Modifier.ABSTRACT) || onlyConcrete && superElement.getModifiers().contains((Object)Modifier.ABSTRACT) || onlyInstance && superElement.getModifiers().contains((Object)Modifier.STATIC)) continue;
                    elementsToAdd.add(superElement);
                }
                enclosedElements.addAll(elementsToAdd);
                superclass = element.getSuperclass();
            }
            if (kind == ElementKind.METHOD) {
                Set<TypeElement> allInterfaces = this.visitorContext.getModelUtils().getAllInterfaces(this.classElement);
                ArrayList<javax.lang.model.element.Element> elementsToAdd = new ArrayList<javax.lang.model.element.Element>(allInterfaces.size());
                for (TypeElement itfe : allInterfaces) {
                    List<? extends javax.lang.model.element.Element> interfaceElements = itfe.getEnclosedElements();
                    block10: for (javax.lang.model.element.Element element3 : interfaceElements) {
                        if (element3.getKind() != ElementKind.METHOD) continue;
                        ExecutableElement ee = (ExecutableElement)element3;
                        if (onlyAbstract && ee.getModifiers().contains((Object)Modifier.DEFAULT) || onlyConcrete && !ee.getModifiers().contains((Object)Modifier.DEFAULT)) continue;
                        for (javax.lang.model.element.Element element4 : enclosedElements) {
                            if (element4.getKind() != ElementKind.METHOD || !elements.overrides((ExecutableElement)element4, ee, this.classElement)) continue;
                            continue block10;
                        }
                        elementsToAdd.add(element3);
                    }
                }
                enclosedElements.addAll(elementsToAdd);
                elementsToAdd.clear();
            }
        }
        boolean onlyAccessible = result.isOnlyAccessible();
        if (kind == ElementKind.METHOD) {
            if (onlyAbstract) {
                if (this.isInterface()) {
                    enclosedElements.removeIf(e -> e.getModifiers().contains((Object)Modifier.DEFAULT));
                } else {
                    enclosedElements.removeIf(e -> !e.getModifiers().contains((Object)Modifier.ABSTRACT));
                }
            } else if (onlyConcrete) {
                if (this.isInterface()) {
                    enclosedElements.removeIf(e -> !e.getModifiers().contains((Object)Modifier.DEFAULT));
                } else {
                    enclosedElements.removeIf(e -> e.getModifiers().contains((Object)Modifier.ABSTRACT));
                }
            }
        }
        if (onlyInstance) {
            enclosedElements.removeIf(e -> e.getModifiers().contains((Object)Modifier.STATIC));
        }
        List modifierPredicates = result.getModifierPredicates();
        List namePredicates = result.getNamePredicates();
        List annotationPredicates = result.getAnnotationPredicates();
        List typePredicates = result.getTypePredicates();
        boolean hasNamePredicates = !namePredicates.isEmpty();
        boolean hasModifierPredicates = !modifierPredicates.isEmpty();
        boolean hasAnnotationPredicates = !annotationPredicates.isEmpty();
        boolean bl = !typePredicates.isEmpty();
        JavaElementFactory elementFactory = this.visitorContext.getElementFactory();
        block12: for (javax.lang.model.element.Element element : enclosedElements) {
            List elementPredicates;
            AbstractJavaElement element5;
            Name qualifiedName;
            String packageName;
            ClassElement onlyAccessibleFrom;
            Object accessibleFrom;
            javax.lang.model.element.Element enclosingElement;
            ElementKind enclosedElementKind = element.getKind();
            if (enclosedElementKind != kind && (enclosedElementKind != ElementKind.ENUM || kind != ElementKind.CLASS)) continue;
            String elementName = element.getSimpleName().toString();
            if (onlyAccessible && (element.getModifiers().contains((Object)Modifier.PRIVATE) || elementName.startsWith("$") || (enclosingElement = element.getEnclosingElement()) != (accessibleFrom = (onlyAccessibleFrom = (ClassElement)result.getOnlyAccessibleFromType().orElse(this)).getNativeType()) && this.visitorContext.getModelUtils().isPackagePrivate(element) && enclosingElement instanceof TypeElement && !(packageName = NameUtils.getPackageName((String)(qualifiedName = ((TypeElement)enclosingElement).getQualifiedName()).toString())).equals(onlyAccessibleFrom.getPackageName()))) continue;
            if (hasModifierPredicates) {
                Set modifiers = element.getModifiers().stream().map(m -> ElementModifier.valueOf((String)m.name())).collect(Collectors.toSet());
                onlyAccessibleFrom = modifierPredicates.iterator();
                while (onlyAccessibleFrom.hasNext()) {
                    Predicate modifierPredicate = (Predicate)onlyAccessibleFrom.next();
                    if (modifierPredicate.test(modifiers)) continue;
                    continue block12;
                }
            }
            if (hasNamePredicates) {
                for (Object namePredicate : namePredicates) {
                    if (namePredicate.test(elementName)) continue;
                    continue block12;
                }
            }
            AnnotationMetadata metadata = this.visitorContext.getAnnotationUtils().getAnnotationMetadata(element);
            if (hasAnnotationPredicates) {
                Object namePredicate;
                namePredicate = annotationPredicates.iterator();
                while (namePredicate.hasNext()) {
                    Predicate annotationPredicate = (Predicate)namePredicate.next();
                    if (annotationPredicate.test(metadata)) continue;
                    continue block12;
                }
            }
            switch (enclosedElementKind) {
                case METHOD: {
                    ExecutableElement executableElement = (ExecutableElement)element;
                    element5 = elementFactory.newMethodElement((ClassElement)this, executableElement, metadata, this.genericTypeInfo);
                    break;
                }
                case FIELD: {
                    element5 = elementFactory.newFieldElement((ClassElement)this, (VariableElement)element, metadata);
                    break;
                }
                case CONSTRUCTOR: {
                    element5 = elementFactory.newConstructorElement((ClassElement)this, (ExecutableElement)element, metadata);
                    break;
                }
                case CLASS: 
                case ENUM: {
                    element5 = elementFactory.newClassElement((TypeElement)element, metadata);
                    break;
                }
                default: {
                    element5 = null;
                }
            }
            if (element5 == null) continue;
            if (bl) {
                for (Predicate typePredicate : typePredicates) {
                    JavaClassElement classElement;
                    if (typePredicate.test(classElement = element5 instanceof ConstructorElement ? this : (element5 instanceof MethodElement ? ((MethodElement)element5).getGenericReturnType() : (element5 instanceof ClassElement ? (ClassElement)element5 : ((FieldElement)element5).getGenericField())))) continue;
                    continue block12;
                }
            }
            if (!(elementPredicates = result.getElementPredicates()).isEmpty()) {
                for (Predicate elementPredicate : elementPredicates) {
                    if (elementPredicate.test(element5)) continue;
                    continue block12;
                }
            }
            resultingElements.add((JavaClassElement)element5);
        }
        return Collections.unmodifiableList(resultingElements);
    }

    private List<? extends javax.lang.model.element.Element> getDeclaredEnclosedElements() {
        if (this.enclosedElements == null) {
            this.enclosedElements = this.classElement.getEnclosedElements();
        }
        return this.enclosedElements;
    }

    private <T extends Element> ElementKind getElementKind(Class<T> elementType) {
        if (elementType == MethodElement.class) {
            return ElementKind.METHOD;
        }
        if (elementType == FieldElement.class) {
            return ElementKind.FIELD;
        }
        if (elementType == ConstructorElement.class) {
            return ElementKind.CONSTRUCTOR;
        }
        if (elementType == ClassElement.class) {
            return ElementKind.CLASS;
        }
        throw new IllegalArgumentException("Unsupported element type for query: " + elementType);
    }

    public boolean isArray() {
        return this.arrayDimensions > 0;
    }

    public int getArrayDimensions() {
        return this.arrayDimensions;
    }

    public ClassElement withArrayDimensions(int arrayDimensions) {
        if (arrayDimensions == this.arrayDimensions) {
            return this;
        }
        return new JavaClassElement(this.classElement, this.getAnnotationMetadata(), this.visitorContext, this.typeArguments, this.getGenericTypeInfo(), arrayDimensions, false);
    }

    public String getSimpleName() {
        if (this.simpleName == null) {
            this.simpleName = JavaModelUtils.getClassNameWithoutPackage((TypeElement)this.classElement);
        }
        return this.simpleName;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = JavaModelUtils.getClassName((TypeElement)this.classElement);
        }
        return this.name;
    }

    public String getPackageName() {
        if (this.packageName == null) {
            this.packageName = JavaModelUtils.getPackageName((TypeElement)this.classElement);
        }
        return this.packageName;
    }

    public io.micronaut.inject.ast.PackageElement getPackage() {
        javax.lang.model.element.Element enclosingElement;
        for (enclosingElement = this.classElement.getEnclosingElement(); enclosingElement != null && enclosingElement.getKind() != ElementKind.PACKAGE; enclosingElement = enclosingElement.getEnclosingElement()) {
        }
        if (enclosingElement instanceof PackageElement) {
            return new JavaPackageElement((PackageElement)enclosingElement, this.visitorContext.getAnnotationUtils().getAnnotationMetadata(enclosingElement), this.visitorContext);
        }
        return io.micronaut.inject.ast.PackageElement.DEFAULT_PACKAGE;
    }

    public boolean isAssignable(String type) {
        TypeElement otherElement = this.visitorContext.getElements().getTypeElement(type);
        if (otherElement != null) {
            Types types = this.visitorContext.getTypes();
            TypeMirror thisType = types.erasure(this.classElement.asType());
            TypeMirror thatType = types.erasure(otherElement.asType());
            return types.isAssignable(thisType, thatType);
        }
        return false;
    }

    public boolean isAssignable(ClassElement type) {
        if (type.isPrimitive()) {
            return this.isAssignable(type.getName());
        }
        Object nativeType = type.getNativeType();
        if (nativeType instanceof TypeElement) {
            Types types = this.visitorContext.getTypes();
            TypeMirror thisType = types.erasure(this.classElement.asType());
            TypeMirror thatType = types.erasure(((TypeElement)nativeType).asType());
            return types.isAssignable(thisType, thatType);
        }
        return false;
    }

    @NonNull
    public Optional<MethodElement> getPrimaryConstructor() {
        AnnotationUtils annotationUtils = this.visitorContext.getAnnotationUtils();
        ModelUtils modelUtils = this.visitorContext.getModelUtils();
        ExecutableElement method = modelUtils.staticCreatorFor(this.classElement, annotationUtils);
        if (method == null) {
            if (this.isInner() && !this.isStatic()) {
                return Optional.empty();
            }
            method = modelUtils.concreteConstructorFor(this.classElement, annotationUtils);
        }
        return this.createMethodElement(annotationUtils, method);
    }

    public Optional<MethodElement> getDefaultConstructor() {
        AnnotationUtils annotationUtils = this.visitorContext.getAnnotationUtils();
        ModelUtils modelUtils = this.visitorContext.getModelUtils();
        ExecutableElement method = modelUtils.defaultStaticCreatorFor(this.classElement, annotationUtils);
        if (method == null) {
            if (this.isInner() && !this.isStatic()) {
                return Optional.empty();
            }
            method = modelUtils.defaultConstructorFor(this.classElement);
        }
        return this.createMethodElement(annotationUtils, method);
    }

    public Optional<ClassElement> getEnclosingType() {
        javax.lang.model.element.Element enclosingElement;
        if (this.isInner() && (enclosingElement = this.classElement.getEnclosingElement()) instanceof TypeElement) {
            return Optional.of(this.visitorContext.getElementFactory().newClassElement((TypeElement)enclosingElement, this.visitorContext.getAnnotationUtils().getAnnotationMetadata(enclosingElement)));
        }
        return Optional.empty();
    }

    private Optional<MethodElement> createMethodElement(AnnotationUtils annotationUtils, ExecutableElement method) {
        return Optional.ofNullable(method).map(executableElement -> {
            AnnotationMetadata annotationMetadata = annotationUtils.getAnnotationMetadata((javax.lang.model.element.Element)executableElement);
            if (executableElement.getKind() == ElementKind.CONSTRUCTOR) {
                return new JavaConstructorElement(this, (ExecutableElement)executableElement, annotationMetadata, this.visitorContext);
            }
            return new JavaMethodElement(this, (ExecutableElement)executableElement, annotationMetadata, this.visitorContext);
        });
    }

    @NonNull
    public List<ClassElement> getBoundGenericTypes() {
        return this.typeArguments.stream().map(tm -> this.mirrorToClassElement((TypeMirror)tm, this.visitorContext, this.getGenericTypeInfo())).collect(Collectors.toList());
    }

    @NonNull
    public List<? extends GenericPlaceholderElement> getDeclaredGenericPlaceholders() {
        return this.classElement.getTypeParameters().stream().map(tpe -> (GenericPlaceholderElement)this.mirrorToClassElement(tpe.asType(), this.visitorContext)).collect(Collectors.toList());
    }

    @NonNull
    public ClassElement getRawClassElement() {
        return this.visitorContext.getElementFactory().newClassElement(this.classElement, this.visitorContext.getAnnotationUtils().getAnnotationMetadata(this.classElement)).withArrayDimensions(this.getArrayDimensions());
    }

    private static TypeMirror toTypeMirror(JavaVisitorContext visitorContext, ClassElement element) {
        if (element.isArray()) {
            return visitorContext.getTypes().getArrayType(JavaClassElement.toTypeMirror(visitorContext, element.fromArray()));
        }
        if (element.isWildcard()) {
            List lowerBounds;
            WildcardElement wildcardElement = (WildcardElement)element;
            List upperBounds = wildcardElement.getUpperBounds();
            if (upperBounds.size() != 1) {
                throw new UnsupportedOperationException("Multiple upper bounds not supported");
            }
            TypeMirror upperBound = JavaClassElement.toTypeMirror(visitorContext, (ClassElement)upperBounds.get(0));
            if (upperBound.toString().equals("java.lang.Object")) {
                upperBound = null;
            }
            if ((lowerBounds = wildcardElement.getLowerBounds()).size() > 1) {
                throw new UnsupportedOperationException("Multiple upper bounds not supported");
            }
            TypeMirror lowerBound = lowerBounds.isEmpty() ? null : JavaClassElement.toTypeMirror(visitorContext, (ClassElement)lowerBounds.get(0));
            return visitorContext.getTypes().getWildcardType(upperBound, lowerBound);
        }
        if (element.isGenericPlaceholder()) {
            if (!(element instanceof JavaGenericPlaceholderElement)) {
                throw new UnsupportedOperationException("Free type variable on non-java class");
            }
            return ((JavaGenericPlaceholderElement)element).realTypeVariable;
        }
        if (element instanceof JavaClassElement) {
            return visitorContext.getTypes().getDeclaredType(((JavaClassElement)element).classElement, ((JavaClassElement)element).typeArguments.toArray(new TypeMirror[0]));
        }
        return visitorContext.getTypes().getDeclaredType(((JavaClassElement)visitorContext.getClassElement((String)element.getName()).get()).classElement, (TypeMirror[])element.getBoundGenericTypes().stream().map(ce -> JavaClassElement.toTypeMirror(visitorContext, ce)).toArray(TypeMirror[]::new));
    }

    @NonNull
    public ClassElement withBoundGenericTypes(@NonNull List<? extends ClassElement> typeArguments) {
        if (typeArguments.isEmpty() && this.typeArguments.isEmpty()) {
            return this;
        }
        List typeMirrors = typeArguments.stream().map(ce -> JavaClassElement.toTypeMirror(this.visitorContext, ce)).collect(Collectors.toList());
        if (typeMirrors.equals(this.typeArguments)) {
            return this;
        }
        LinkedHashMap<String, TypeMirror> boundByName = new LinkedHashMap<String, TypeMirror>();
        Iterator<? extends TypeParameterElement> tpes = this.classElement.getTypeParameters().iterator();
        Iterator args = typeMirrors.iterator();
        while (tpes.hasNext() && args.hasNext()) {
            boundByName.put(tpes.next().getSimpleName().toString(), (TypeMirror)args.next());
        }
        Map<String, Map<String, TypeMirror>> genericsInfo = this.visitorContext.getGenericUtils().buildGenericTypeArgumentElementInfo(this.classElement, null, boundByName);
        return new JavaClassElement(this.classElement, this.getAnnotationMetadata(), this.visitorContext, typeMirrors, genericsInfo, this.arrayDimensions);
    }

    @NonNull
    public Map<String, ClassElement> getTypeArguments() {
        List<? extends TypeParameterElement> typeParameters = this.classElement.getTypeParameters();
        Iterator<? extends TypeParameterElement> tpi = typeParameters.iterator();
        LinkedHashMap<String, ClassElement> map = new LinkedHashMap<String, ClassElement>();
        while (tpi.hasNext()) {
            TypeParameterElement tpe = tpi.next();
            ClassElement classElement = this.mirrorToClassElement(tpe.asType(), this.visitorContext, this.genericTypeInfo, this.visitorContext.getConfiguration().includeTypeLevelAnnotationsInGenericArguments());
            map.put(tpe.toString(), classElement);
        }
        return Collections.unmodifiableMap(map);
    }

    private Map<String, TypeMirror> getBoundTypeMirrors() {
        List<? extends TypeParameterElement> typeParameters = this.classElement.getTypeParameters();
        Iterator<? extends TypeParameterElement> tpi = typeParameters.iterator();
        LinkedHashMap<String, TypeMirror> map = new LinkedHashMap<String, TypeMirror>();
        while (tpi.hasNext()) {
            TypeParameterElement tpe = tpi.next();
            TypeMirror t = tpe.asType();
            map.put(tpe.toString(), t);
        }
        return Collections.unmodifiableMap(map);
    }

    @NonNull
    public Map<String, Map<String, ClassElement>> getAllTypeArguments() {
        Map<String, TypeMirror> typeArguments = this.getBoundTypeMirrors();
        Map<String, Map<String, TypeMirror>> info = this.visitorContext.getGenericUtils().buildGenericTypeArgumentElementInfo(this.classElement, null, typeArguments);
        LinkedHashMap<String, Map<String, ClassElement>> result = new LinkedHashMap<String, Map<String, ClassElement>>(info.size());
        info.forEach((name, generics) -> {
            LinkedHashMap resolved = new LinkedHashMap(generics.size());
            generics.forEach((variable, mirror) -> {
                TypeMirror tm;
                Map<String, TypeMirror> typeInfo = this.genericTypeInfo != null ? this.genericTypeInfo.get(this.getName()) : null;
                TypeMirror resolvedType = mirror;
                if (mirror instanceof TypeVariable && typeInfo != null && (tm = typeInfo.get(mirror.toString())) != null) {
                    resolvedType = tm;
                }
                ClassElement classElement = this.mirrorToClassElement(resolvedType, this.visitorContext, info, this.visitorContext.getConfiguration().includeTypeLevelAnnotationsInGenericArguments(), mirror instanceof TypeVariable);
                resolved.put(variable, classElement);
            });
            result.put((String)name, resolved);
        });
        if (!typeArguments.isEmpty()) {
            result.put(JavaModelUtils.getClassName((TypeElement)this.classElement), this.getTypeArguments());
        }
        return result;
    }

    Map<String, Map<String, TypeMirror>> getGenericTypeInfo() {
        if (this.genericTypeInfo == null) {
            this.genericTypeInfo = this.visitorContext.getGenericUtils().buildGenericTypeArgumentElementInfo(this.classElement, null, this.getBoundTypeMirrors());
        }
        return this.genericTypeInfo;
    }

    private static class BeanPropertyData {
        ClassElement type;
        ClassElement declaringType;
        ExecutableElement getter;
        ExecutableElement setter;
        final String propertyName;

        public BeanPropertyData(String propertyName) {
            this.propertyName = propertyName;
        }
    }
}

