/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.annotation.Any;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.qualifiers.NameQualifier;
import io.micronaut.inject.qualifiers.NamedAnnotationStereotypeQualifier;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
class AnnotationMetadataQualifier<T>
extends NameQualifier<T> {
    private static final String NAMED_SIMPLE = "Named";
    final AnnotationValue<Annotation> qualifierAnn;
    final String qualifiedName;
    private final AnnotationMetadata annotationMetadata;
    private final Set<String> nonBinding;

    AnnotationMetadataQualifier(AnnotationMetadata metadata, String name) {
        super(metadata, name);
        this.annotationMetadata = metadata;
        String string = this.qualifiedName = this.annotationType != null ? this.annotationType.getName() : name;
        if ("javax.inject.Named".equals(name) || Named.class.getName().equals(name)) {
            this.nonBinding = null;
            this.qualifierAnn = null;
        } else {
            this.nonBinding = this.resolveNonBindingMembers(this.annotationMetadata);
            Map<CharSequence, Object> bindingValues = this.resolveBindingValues(this.annotationMetadata, this.qualifiedName, this.nonBinding);
            this.qualifierAnn = CollectionUtils.isNotEmpty(bindingValues) ? new AnnotationValue(this.qualifiedName, bindingValues) : null;
        }
    }

    AnnotationMetadataQualifier(AnnotationMetadata metadata, Class<? extends Annotation> annotationType) {
        super(annotationType);
        this.annotationMetadata = metadata;
        this.qualifiedName = annotationType.getName();
        if (!this.getName().equals(NAMED_SIMPLE)) {
            this.nonBinding = this.resolveNonBindingMembers(this.annotationMetadata);
            Map<CharSequence, Object> bindingValues = this.resolveBindingValues(this.annotationMetadata, this.qualifiedName, this.nonBinding);
            this.qualifierAnn = CollectionUtils.isNotEmpty(bindingValues) ? new AnnotationValue(this.qualifiedName, bindingValues) : null;
        } else {
            this.nonBinding = null;
            this.qualifierAnn = null;
        }
    }

    @Override
    public <BT extends BeanType<T>> Stream<BT> reduce(Class<T> beanType, Stream<BT> candidates) {
        if (beanType != Object.class && this.annotationMetadata.hasDeclaredAnnotation(Any.class)) {
            return candidates;
        }
        String v = this.annotationMetadata.stringValue("javax.inject.Named").orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)v)) {
            String name = Character.toUpperCase(v.charAt(0)) + v.substring(1);
            return this.reduceByName(beanType, candidates, name);
        }
        String name = this.getName();
        Stream<BT> reduced = this.reduceByAnnotation(beanType, candidates, name, this.qualifiedName);
        if (this.qualifierAnn != null) {
            return reduced.filter(candidate -> {
                if (beanType != Object.class && candidate.getAnnotationMetadata().hasDeclaredAnnotation(Any.class)) {
                    return true;
                }
                AnnotationMetadata annotationMetadata = candidate.getAnnotationMetadata();
                AnnotationValue av = candidate.getAnnotation(this.qualifiedName);
                if (av != null) {
                    Set<String> nonBinding = this.resolveNonBindingMembers(annotationMetadata);
                    Map<CharSequence, Object> values = this.resolveBindingValues(annotationMetadata, this.qualifiedName, nonBinding);
                    return this.qualifierAnn.equals((Object)new AnnotationValue(this.qualifiedName, values));
                }
                return false;
            });
        }
        return reduced;
    }

    @Nullable
    private Map<CharSequence, Object> resolveBindingValues(AnnotationMetadata annotationMetadata, String qualifierName, Set<String> nonBinding) {
        Map<CharSequence, Object> bindingValues = annotationMetadata.getValues(qualifierName);
        if (nonBinding != null && !bindingValues.isEmpty() && !nonBinding.isEmpty()) {
            bindingValues = bindingValues.entrySet().stream().filter(entry -> !nonBinding.contains(((CharSequence)entry.getKey()).toString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return bindingValues;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (o instanceof AnnotationMetadataQualifier) {
            AnnotationMetadataQualifier that = (AnnotationMetadataQualifier)o;
            return this.qualifiedName.equals(that.qualifiedName) && Objects.equals(this.qualifierAnn, that.qualifierAnn);
        }
        if (this.qualifierAnn == null && o instanceof NamedAnnotationStereotypeQualifier) {
            NamedAnnotationStereotypeQualifier that = (NamedAnnotationStereotypeQualifier)o;
            return this.qualifiedName.equals(that.stereotype);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.qualifiedName, this.qualifierAnn);
    }

    @NonNull
    private Set<String> resolveNonBindingMembers(AnnotationMetadata annotationMetadata) {
        Object[] nonBindingArray = annotationMetadata.stringValues("javax.inject.Qualifier", "nonBinding");
        return ArrayUtils.isNotEmpty((Object[])nonBindingArray) ? new HashSet<Object>(Arrays.asList(nonBindingArray)) : Collections.emptySet();
    }

    @Override
    public String toString() {
        String annName;
        String string = annName = this.annotationType == null ? super.toString() : "@" + this.annotationType.getSimpleName();
        if (this.qualifierAnn != null) {
            Map values = this.qualifierAnn.getValues();
            annName = annName + "(" + values.entrySet().stream().map(entry -> entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining(", ")) + ")";
        }
        return annName;
    }
}

