package org.springframework.uaa.client.util;

import java.util.Collection;

/**
 * Simple assertion utility methods.
 * 
 * @author Ben Alex
 *
 */
public abstract class Assert {
	public static void hasLength(String text, String message) {
		if (text == null || text.length() == 0) throw new IllegalArgumentException(message);
	}
	public static void notNull(Object object, String message) {
		if (object == null) throw new IllegalArgumentException(message);
	}
	public static void notEmpty(Collection<?> object, String message) {
		if (object == null || object.size() == 0) throw new IllegalArgumentException(message);
	}
	public static void isTrue(Boolean expression, String message) {
		if (!expression) throw new IllegalArgumentException(message);
	}
}
