/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.util.i18n;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceManager {
    private static Log log = LogFactory.getLog(ResourceManager.class);
    private static ThreadLocal instance = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new ResourceManager();
        }
    };
    private Locale locale = null;
    private Enumeration fallback = null;
    private Map resourceBundles = new HashMap();

    public static ResourceManager forceGet() {
        instance.set(null);
        return ResourceManager.get();
    }

    public static ResourceManager get() {
        ResourceManager resourceManager = (ResourceManager)instance.get();
        if (null == resourceManager) {
            resourceManager = new ResourceManager();
            instance.set(resourceManager);
        }
        return resourceManager;
    }

    public static ResourceBundle getBundle(String baseName) {
        return ResourceManager.get().getResourceBundle(baseName);
    }

    public static Locale getLocale(String baseName) {
        return ResourceManager.get().getResourceBundle(baseName).getLocale();
    }

    public static String getString(String baseName, String key) {
        try {
            ResourceBundle bundle = ResourceManager.getBundle(baseName);
            return bundle.getString(key);
        }
        catch (Exception e) {
            log.warn((Object)("missing resource for bundle '" + baseName + "', key '" + key + "'"), (Throwable)e);
            return "???" + key + "???";
        }
    }

    public void setLocale(Locale locale, Enumeration fallback) {
        this.locale = locale;
        this.fallback = fallback;
    }

    public ResourceBundle getResourceBundle(String baseName) {
        ResourceBundle bundle = (ResourceBundle)this.resourceBundles.get(baseName);
        if (null == bundle) {
            bundle = this.findBundle(baseName);
            this.resourceBundles.put(baseName, bundle);
        }
        return bundle;
    }

    private ResourceBundle findBundle(String baseName) {
        ResourceBundle resourceBundle = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (null != this.locale) {
            try {
                resourceBundle = ResourceBundle.getBundle(baseName, this.locale, cl);
            }
            catch (Exception e) {
                log.fatal((Object)("unable to load a default bundle: " + baseName + "_" + this.locale));
            }
            if (!resourceBundle.getLocale().equals(this.locale)) {
                resourceBundle = null;
            }
        }
        if (null == resourceBundle) {
            if (null != this.fallback) {
                while (this.fallback.hasMoreElements()) {
                    Locale testLocale = (Locale)this.fallback.nextElement();
                    log.debug((Object)("looking up locale " + testLocale));
                    ResourceBundle testBundle = ResourceBundle.getBundle(baseName, testLocale, cl);
                    String language = testBundle.getLocale().getLanguage();
                    String country = testBundle.getLocale().getCountry();
                    if (testBundle.getLocale().equals(testLocale)) {
                        resourceBundle = testBundle;
                        log.debug((Object)("found bundle for locale " + baseName + "_" + testBundle.getLocale()));
                        break;
                    }
                    if (!testLocale.getLanguage().equals(language)) continue;
                    if (testLocale.getCountry().equals(country)) {
                        resourceBundle = testBundle;
                        log.debug((Object)("potential bundle: " + baseName + "_" + testBundle.getLocale()));
                        continue;
                    }
                    if (null != resourceBundle) continue;
                    resourceBundle = testBundle;
                    log.debug((Object)("potential bundle: " + baseName + "_" + testBundle.getLocale()));
                }
            }
            if (null == resourceBundle && null != (resourceBundle = ResourceBundle.getBundle(baseName))) {
                log.debug((Object)("system locale bundle taken: " + baseName + "_" + resourceBundle.getLocale()));
            }
        }
        return resourceBundle;
    }
}

