/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded.ri;

import java.util.Collection;
import java.util.List;
import org.springsource.loaded.ReloadableType;
import org.springsource.loaded.TypeDescriptor;
import org.springsource.loaded.TypeRegistry;
import org.springsource.loaded.Utils;
import org.springsource.loaded.ri.DynamicLookup;
import org.springsource.loaded.ri.GetDeclaredMethodLookup;
import org.springsource.loaded.ri.GetMethodLookup;
import org.springsource.loaded.ri.GetMethodsLookup;
import org.springsource.loaded.ri.Invoker;
import org.springsource.loaded.ri.JavaClassMethodProvider;
import org.springsource.loaded.ri.ReloadableTypeMethodProvider;
import org.springsource.loaded.ri.StaticLookup;
import sl.org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodProvider {
    public static MethodProvider create(ReloadableType rtype) {
        return new ReloadableTypeMethodProvider(rtype);
    }

    public static MethodProvider create(TypeRegistry registry, TypeDescriptor typeDescriptor) {
        if (typeDescriptor.isReloadable()) {
            ReloadableType rtype = registry.getReloadableType(typeDescriptor.getName(), false);
            if (rtype == null) {
                TypeRegistry tr = registry;
                while (rtype == null) {
                    ClassLoader pcl = tr.getClassLoader().getParent();
                    if (pcl == null || (tr = TypeRegistry.getTypeRegistryFor(pcl)) == null) break;
                    rtype = tr.getReloadableType(typeDescriptor.getName(), false);
                }
            }
            if (rtype != null) {
                return new ReloadableTypeMethodProvider(rtype);
            }
        }
        try {
            try {
                ClassLoader cl;
                TypeRegistry tr;
                ReloadableType rtype;
                Type objectType = Type.getObjectType(typeDescriptor.getName());
                Class<?> class1 = Utils.toClass(objectType, registry.getClassLoader());
                if (typeDescriptor.isReloadable() && (rtype = (tr = TypeRegistry.getTypeRegistryFor(cl = class1.getClassLoader())).getReloadableType(typeDescriptor.getName(), true)) != null) {
                    return new ReloadableTypeMethodProvider(rtype);
                }
                return MethodProvider.create(class1);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("We have a type descriptor for '" + typeDescriptor.getName() + " but no corresponding Java class", e);
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            throw re;
        }
    }

    public static MethodProvider create(Class<?> clazz) {
        return new JavaClassMethodProvider(clazz);
    }

    public abstract List<Invoker> getDeclaredMethods();

    public abstract MethodProvider getSuper();

    public abstract MethodProvider[] getInterfaces();

    public abstract boolean isInterface();

    public abstract String getSlashedName();

    public String getDottedName() {
        return this.getSlashedName().replace('/', '.');
    }

    public Invoker dynamicLookup(int mods, String name, String methodDescriptor) {
        return new DynamicLookup(name, methodDescriptor).lookup(this);
    }

    public Invoker staticLookup(int mods, String name, String methodDescriptor) {
        return new StaticLookup(name, methodDescriptor).lookup(this);
    }

    public Invoker getMethod(String name, Class<?>[] params) {
        return new GetMethodLookup(name, params).lookup(this);
    }

    public Invoker getDeclaredMethod(String name, String paramsDescriptor) {
        return new GetDeclaredMethodLookup(name, paramsDescriptor).lookup(this);
    }

    public Invoker getDeclaredMethod(String name, Class<?>[] params) {
        return this.getDeclaredMethod(name, Utils.toParamDescriptor(params));
    }

    public Collection<Invoker> getMethods() {
        return new GetMethodsLookup().lookup(this);
    }

    public String toString() {
        return "MethodProvider(" + this.getDottedName() + ")";
    }
}

