/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springsource.loaded.Constants;
import org.springsource.loaded.FieldMember;
import org.springsource.loaded.GlobalConfiguration;
import org.springsource.loaded.MethodMember;
import org.springsource.loaded.ReloadableType;
import org.springsource.loaded.TypeDescriptor;
import org.springsource.loaded.TypeRegistry;
import org.springsource.loaded.Utils;
import sl.org.objectweb.asm.ClassAdapter;
import sl.org.objectweb.asm.ClassReader;
import sl.org.objectweb.asm.ClassVisitor;
import sl.org.objectweb.asm.ClassWriter;
import sl.org.objectweb.asm.FieldVisitor;
import sl.org.objectweb.asm.Label;
import sl.org.objectweb.asm.MethodAdapter;
import sl.org.objectweb.asm.MethodVisitor;
import sl.org.objectweb.asm.Opcodes;

public class TypeRewriter
implements Constants {
    private static Logger log = Logger.getLogger(TypeRewriter.class.getName());

    public static byte[] rewrite(ReloadableType rtype, byte[] bytes) {
        ClassReader fileReader = new ClassReader(bytes);
        RewriteClassAdaptor classAdaptor = new RewriteClassAdaptor(rtype);
        fileReader.accept(classAdaptor, 0);
        return classAdaptor.getBytes();
    }

    static class RewriteClassAdaptor
    extends ClassAdapter
    implements Constants {
        private ClassWriter cw;
        private String slashedname;
        private ReloadableType rtype;
        private TypeDescriptor typeDescriptor;
        private boolean clinitDone = false;
        private String supertypeName;
        private boolean isInterface;
        private boolean isEnum;
        private boolean isGroovy;
        private static final int lvThis = 0;

        public RewriteClassAdaptor(ReloadableType rtype) {
            this(rtype, new ClassWriter(1));
        }

        public RewriteClassAdaptor(ReloadableType rtype, ClassWriter classWriter) {
            super(classWriter);
            this.rtype = rtype;
            this.slashedname = rtype.getSlashedName();
            this.cw = (ClassWriter)this.cv;
            this.typeDescriptor = rtype.getTypeDescriptor();
            this.isInterface = this.typeDescriptor.isInterface();
            this.isEnum = this.typeDescriptor.isEnum();
            this.isGroovy = this.typeDescriptor.isGroovyType();
        }

        public byte[] getBytes() {
            return this.cw.toByteArray();
        }

        public ClassVisitor getClassVisitor() {
            return this.cw;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            access = Utils.promoteDefaultOrPrivateOrProtectedToPublic(access);
            super.visit(version, access, name, signature, superName, interfaces);
            this.supertypeName = superName;
            this.createReloadableTypeField();
            if (!this.isInterface) {
                if (this.isTopmostReloadable()) {
                    this.createInstanceStateManagerInstance();
                }
                this.createInstanceFieldGetterMethod();
                this.createInstanceFieldSetterMethod();
                this.createStaticFieldSetterMethod();
                this.createStaticFieldGetterMethod();
                this.createStaticInitializerForwarderMethod();
            }
            if (this.isTopmostReloadable()) {
                this.createStaticStateManagerInstance();
            }
            if (!this.isInterface) {
                this.createManagedConstructors();
                this.createDispatcherCallingInitCtors();
            }
        }

        private boolean isTopmostReloadable() {
            TypeRegistry typeRegistry = this.rtype.getTypeRegistry();
            return !typeRegistry.isReloadableTypeName(this.typeDescriptor.getSupertypeName());
        }

        private void createStaticInitializerForwarderMethod() {
            MethodVisitor mv = this.cw.visitMethod(9, "___clinit___", "()V", null, null);
            mv.visitFieldInsn(178, this.slashedname, "r$type", "Lorg/springsource/loaded/ReloadableType;");
            mv.visitMethodInsn(182, "org/springsource/loaded/ReloadableType", "fetchLatest", "()Ljava/lang/Object;");
            mv.visitTypeInsn(192, Utils.getInterfaceName(this.slashedname));
            mv.visitMethodInsn(185, Utils.getInterfaceName(this.slashedname), "___clinit___", "()V");
            mv.visitInsn(177);
            mv.visitMaxs(1, 0);
            mv.visitEnd();
        }

        private void createStaticFieldGetterMethod() {
            MethodVisitor mv = this.cw.visitMethod(9, "r$gets", "(Ljava/lang/String;)Ljava/lang/Object;", null, null);
            mv.visitFieldInsn(178, this.slashedname, "r$sfields", "Lorg/springsource/loaded/SSMgr;");
            Label l2 = new Label();
            mv.visitJumpInsn(199, l2);
            mv.visitTypeInsn(187, "org/springsource/loaded/SSMgr");
            mv.visitInsn(89);
            mv.visitMethodInsn(183, "org/springsource/loaded/SSMgr", "<init>", "()V");
            mv.visitFieldInsn(179, this.slashedname, "r$sfields", "Lorg/springsource/loaded/SSMgr;");
            mv.visitLabel(l2);
            mv.visitFieldInsn(178, this.slashedname, "r$sfields", "Lorg/springsource/loaded/SSMgr;");
            mv.visitFieldInsn(178, this.slashedname, "r$type", "Lorg/springsource/loaded/ReloadableType;");
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, "org/springsource/loaded/SSMgr", "getValue", "(Lorg/springsource/loaded/ReloadableType;Ljava/lang/String;)Ljava/lang/Object;");
            mv.visitInsn(176);
            mv.visitMaxs(3, 2);
            mv.visitEnd();
        }

        private void createDispatcherCallingInitCtors() {
            MethodMember[] ctors;
            MethodMember[] methodMemberArray = ctors = this.typeDescriptor.getConstructors();
            int n = ctors.length;
            int n2 = 0;
            while (n2 < n) {
                MethodMember ctor = methodMemberArray[n2];
                String desc = ctor.getDescriptor();
                MethodVisitor mv = this.cw.visitMethod(1, "___init___", desc, null, null);
                mv.visitFieldInsn(178, this.slashedname, "r$type", "Lorg/springsource/loaded/ReloadableType;");
                mv.visitInsn(4);
                mv.visitMethodInsn(182, "org/springsource/loaded/ReloadableType", "getLatestDispatcherInstance", "(Z)Ljava/lang/Object;");
                mv.visitTypeInsn(192, Utils.getInterfaceName(this.slashedname));
                String desc2 = new StringBuffer("(L").append(this.slashedname).append(";").append(desc.substring(1)).toString();
                mv.visitVarInsn(25, 0);
                Utils.createLoadsBasedOnDescriptor(mv, desc, 1);
                mv.visitMethodInsn(185, Utils.getInterfaceName(this.slashedname), "___init___", desc2);
                mv.visitInsn(177);
                mv.visitMaxs(3, Utils.getParameterCount(desc) + 1);
                mv.visitEnd();
                ++n2;
            }
        }

        private void createManagedConstructors() {
            String slashedSupertypeName = this.typeDescriptor.getSupertypeName();
            if (slashedSupertypeName.equals("java/lang/Enum")) {
                MethodVisitor mv = this.cw.visitMethod(1, "<init>", "(Ljava/lang/String;ILorg/springsource/loaded/C;)V", null, null);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(21, 2);
                mv.visitMethodInsn(183, "java/lang/Enum", "<init>", "(Ljava/lang/String;I)V");
                mv.visitInsn(177);
                mv.visitMaxs(3, 3);
                mv.visitEnd();
                return;
            }
            if (slashedSupertypeName.equals("groovy/lang/Closure")) {
                MethodVisitor mv = this.cw.visitMethod(1, "<init>", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/springsource/loaded/C;)V", null, null);
                TypeDescriptor superDescriptor = this.rtype.getTypeRegistry().getDescriptorFor(this.supertypeName);
                MethodMember ctor = superDescriptor.getConstructor("(Ljava/lang/Object;Ljava/lang/Object;)V");
                if (ctor == null) {
                    throw new IllegalStateException("Unable to find expected constructor on Closure type");
                }
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(183, "groovy/lang/Closure", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;)V");
                mv.visitInsn(177);
                mv.visitMaxs(3, 4);
                mv.visitEnd();
            } else {
                MethodVisitor mv = this.cw.visitMethod(1, "<init>", "(Lorg/springsource/loaded/C;)V", null, null);
                mv.visitVarInsn(25, 0);
                if (slashedSupertypeName.equals("java/lang/Object")) {
                    mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
                    mv.visitInsn(177);
                    mv.visitMaxs(1, 2);
                } else if (slashedSupertypeName.equals("java/lang/Enum")) {
                    mv.visitInsn(1);
                    mv.visitLdcInsn(0);
                    mv.visitMethodInsn(183, "java/lang/Enum", "<init>", "(Ljava/lang/String;I)V");
                    mv.visitInsn(177);
                    mv.visitMaxs(3, 3);
                } else {
                    ReloadableType superRtype = this.rtype.getTypeRegistry().getReloadableType(slashedSupertypeName);
                    if (superRtype == null) {
                        TypeDescriptor superDescriptor = this.rtype.getTypeRegistry().getDescriptorFor(this.supertypeName);
                        MethodMember ctor = superDescriptor.getConstructor("()V");
                        if (ctor != null) {
                            mv.visitMethodInsn(183, slashedSupertypeName, "<init>", "()V");
                        } else {
                            String warningMessage = "SERIOUS WARNING (current limitation): At reloadable boundary of " + this.typeDescriptor.getDottedName() + " supertype=" + this.supertypeName + " - no available default ctor for that supertype, problems may occur on reload if constructor changes";
                            if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.SEVERE)) {
                                log.log(Level.SEVERE, warningMessage);
                            }
                            if (!this.supertypeName.equals("groovy/lang/Closure") && !this.supertypeName.startsWith("org/codehaus/groovy/runtime/callsite") && GlobalConfiguration.verboseMode) {
                                System.out.println(warningMessage);
                            }
                        }
                    } else {
                        mv.visitInsn(1);
                        mv.visitMethodInsn(183, slashedSupertypeName, "<init>", "(Lorg/springsource/loaded/C;)V");
                    }
                    mv.visitInsn(177);
                    mv.visitMaxs(2, 2);
                }
                mv.visitEnd();
            }
        }

        private void createStaticFieldSetterMethod() {
            MethodVisitor mv = this.cw.visitMethod(9, "r$sets", "(Ljava/lang/Object;Ljava/lang/String;)V", null, null);
            mv.visitFieldInsn(178, this.slashedname, "r$sfields", "Lorg/springsource/loaded/SSMgr;");
            Label l2 = new Label();
            mv.visitJumpInsn(199, l2);
            mv.visitTypeInsn(187, "org/springsource/loaded/SSMgr");
            mv.visitInsn(89);
            mv.visitMethodInsn(183, "org/springsource/loaded/SSMgr", "<init>", "()V");
            mv.visitFieldInsn(179, this.slashedname, "r$sfields", "Lorg/springsource/loaded/SSMgr;");
            mv.visitLabel(l2);
            mv.visitFieldInsn(178, this.slashedname, "r$sfields", "Lorg/springsource/loaded/SSMgr;");
            mv.visitFieldInsn(178, this.slashedname, "r$type", "Lorg/springsource/loaded/ReloadableType;");
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, "org/springsource/loaded/SSMgr", "setValue", "(Lorg/springsource/loaded/ReloadableType;Ljava/lang/Object;Ljava/lang/String;)V");
            mv.visitInsn(177);
            mv.visitMaxs(4, 2);
            mv.visitEnd();
        }

        private void createInstanceFieldGetterMethod() {
            MethodVisitor mv = this.cw.visitMethod(1, "r$get", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", null, null);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.slashedname, "r$fields", "Lorg/springsource/loaded/ISMgr;");
            Label l1 = new Label();
            mv.visitJumpInsn(199, l1);
            mv.visitVarInsn(25, 0);
            mv.visitTypeInsn(187, "org/springsource/loaded/ISMgr");
            mv.visitInsn(89);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(178, this.slashedname, "r$type", "Lorg/springsource/loaded/ReloadableType;");
            mv.visitMethodInsn(183, "org/springsource/loaded/ISMgr", "<init>", "(Ljava/lang/Object;Lorg/springsource/loaded/ReloadableType;)V");
            mv.visitFieldInsn(181, this.slashedname, "r$fields", "Lorg/springsource/loaded/ISMgr;");
            mv.visitLabel(l1);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.slashedname, "r$fields", "Lorg/springsource/loaded/ISMgr;");
            mv.visitFieldInsn(178, this.slashedname, "r$type", "Lorg/springsource/loaded/ReloadableType;");
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(182, "org/springsource/loaded/ISMgr", "getValue", "(Lorg/springsource/loaded/ReloadableType;Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
            mv.visitInsn(176);
            mv.visitMaxs(4, 3);
            mv.visitEnd();
        }

        private void createInstanceFieldSetterMethod() {
            MethodVisitor mv = this.cw.visitMethod(1, "r$set", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)V", null, null);
            boolean lvNewValue = true;
            int lvInstance = 2;
            int lvName = 3;
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.slashedname, "r$fields", "Lorg/springsource/loaded/ISMgr;");
            Label l1 = new Label();
            mv.visitJumpInsn(199, l1);
            mv.visitVarInsn(25, 0);
            mv.visitTypeInsn(187, "org/springsource/loaded/ISMgr");
            mv.visitInsn(89);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(178, this.slashedname, "r$type", "Lorg/springsource/loaded/ReloadableType;");
            mv.visitMethodInsn(183, "org/springsource/loaded/ISMgr", "<init>", "(Ljava/lang/Object;Lorg/springsource/loaded/ReloadableType;)V");
            mv.visitFieldInsn(181, this.slashedname, "r$fields", "Lorg/springsource/loaded/ISMgr;");
            mv.visitLabel(l1);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.slashedname, "r$fields", "Lorg/springsource/loaded/ISMgr;");
            mv.visitFieldInsn(178, this.slashedname, "r$type", "Lorg/springsource/loaded/ReloadableType;");
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(182, "org/springsource/loaded/ISMgr", "setValue", "(Lorg/springsource/loaded/ReloadableType;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)V");
            mv.visitInsn(177);
            mv.visitMaxs(4, 4);
            mv.visitEnd();
        }

        private void createInstanceStateManagerInstance() {
            FieldVisitor f = this.cw.visitField(129, "r$fields", "Lorg/springsource/loaded/ISMgr;", null, null);
            f.visitEnd();
        }

        private void createStaticStateManagerInstance() {
            FieldVisitor f = this.cw.visitField(25, "r$sfields", "Lorg/springsource/loaded/SSMgr;", null, null);
            f.visitEnd();
        }

        private void createReloadableTypeField() {
            int acc = this.isInterface ? 25 : 9;
            FieldVisitor fv = this.cw.visitField(acc, "r$type", "Lorg/springsource/loaded/ReloadableType;", null, null);
            fv.visitEnd();
        }

        public MethodVisitor visitMethod(int flags, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(this.promoteIfNecessary(flags), name, descriptor, signature, exceptions);
            MethodVisitor newMethodVisitor = this.getMethodVisitor(name, descriptor, mv);
            return newMethodVisitor;
        }

        public MethodVisitor getMethodVisitor(String name, String descriptor, MethodVisitor mv) {
            MethodAdapter newMethodVisitor = null;
            if (name.charAt(0) == '<') {
                if (name.charAt(1) == 'c') {
                    this.clinitDone = true;
                    newMethodVisitor = new MethodPrepender(mv, new ClinitPrepender(mv));
                } else {
                    newMethodVisitor = new AugmentingConstructorAdapter(mv, descriptor, this.slashedname, this.isTopmostReloadable());
                }
            } else {
                newMethodVisitor = new AugmentingMethodAdapter(mv, name, descriptor);
            }
            return newMethodVisitor;
        }

        private int promoteIfNecessary(int flags) {
            int newflags = Utils.promoteDefaultOrProtectedToPublic(flags, this.isEnum);
            return newflags;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            int modAccess = 0;
            if ((access & 0x10) != 0) {
                if (name.equals("serialVersionUID")) {
                    modAccess = access & 0xFFFFFFF9 | 1;
                } else {
                    modAccess = access & 0xFFFFFFF9 | 1;
                    modAccess &= 0xFFFFFFEF;
                }
            } else {
                modAccess = access & 0xFFFFFFF9 | 1;
                modAccess &= 0xFFFFFFEF;
            }
            return this.cv.visitField(modAccess, name, desc, signature, value);
        }

        public void visitEnd() {
            if (!this.clinitDone) {
                MethodVisitor mv = this.cw.visitMethod(8, "<clinit>", "()V", null, null);
                new ClinitPrepender(mv).prepend();
                mv.visitInsn(177);
                mv.visitMaxs(3, 0);
                mv.visitEnd();
            }
            this.generateCatchers();
            this.generateDynamicDispatchHandler();
            this.cv.visitEnd();
        }

        private void generateDynamicDispatchHandler() {
            boolean indexThis = false;
            boolean indexArgs = true;
            int indexTargetInstance = 2;
            int indexNameAndDescriptor = 3;
            if (this.isInterface) {
                this.cw.visitMethod(1025, "__execute", "([Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", null, null);
            } else {
                MethodVisitor mv = this.cw.visitMethod(1, "__execute", "([Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", null, null);
                mv.visitFieldInsn(178, this.slashedname, "r$type", "Lorg/springsource/loaded/ReloadableType;");
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 3);
                mv.visitMethodInsn(182, "org/springsource/loaded/ReloadableType", "determineDispatcher", "(Ljava/lang/Object;Ljava/lang/String;)Lorg/springsource/loaded/__DynamicallyDispatchable;");
                mv.visitInsn(89);
                Label l1 = new Label();
                mv.visitJumpInsn(198, l1);
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 3);
                mv.visitMethodInsn(185, "org/springsource/loaded/__DynamicallyDispatchable", "__execute", "([Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                mv.visitInsn(176);
                mv.visitLabel(l1);
                mv.visitInsn(87);
                this.genThrowNoSuchMethodError(mv, 3);
                mv.visitMaxs(5, 4);
                mv.visitEnd();
            }
        }

        private final void genThrowNoSuchMethodError(MethodVisitor mv, int index) {
            mv.visitTypeInsn(187, "java/lang/NoSuchMethodError");
            mv.visitInsn(89);
            mv.visitVarInsn(25, index);
            mv.visitMethodInsn(183, "java/lang/NoSuchMethodError", "<init>", "(Ljava/lang/String;)V");
            mv.visitInsn(191);
        }

        private void generateCatchers() {
            MethodMember[] methods;
            FieldMember[] fms;
            if (!GlobalConfiguration.catchersOn || this.isInterface) {
                return;
            }
            FieldMember[] fieldMemberArray = fms = this.typeDescriptor.getFieldsRequiringAccessors();
            int n = fms.length;
            int n2 = 0;
            while (n2 < n) {
                FieldMember field = fieldMemberArray[n2];
                this.createProtectedFieldGetterSetter(field);
                ++n2;
            }
            MethodMember[] methodMemberArray = methods = this.typeDescriptor.getMethods();
            int n3 = methods.length;
            n = 0;
            while (n < n3) {
                MethodMember method = methodMemberArray[n];
                if (MethodMember.isCatcher(method)) {
                    String name = method.getName();
                    String descriptor = method.getDescriptor();
                    Utils.ReturnType returnType = Utils.getReturnTypeDescriptor(descriptor);
                    int flags = method.getModifiers();
                    if (Modifier.isProtected(flags)) {
                        flags = flags - 4 + 1;
                    }
                    MethodVisitor mv = this.cw.visitMethod(flags, method.getName(), method.getDescriptor(), null, method.getExceptions());
                    mv.visitFieldInsn(178, this.slashedname, "r$type", "Lorg/springsource/loaded/ReloadableType;");
                    mv.visitLdcInsn(method.getId());
                    mv.visitMethodInsn(182, "org/springsource/loaded/ReloadableType", "fetchLatestIfExists", "(I)Ljava/lang/Object;");
                    mv.visitInsn(89);
                    Label l1 = new Label();
                    mv.visitJumpInsn(198, l1);
                    mv.visitTypeInsn(192, Utils.getInterfaceName(this.slashedname));
                    int lvarIndex = 0;
                    mv.visitVarInsn(25, lvarIndex++);
                    Utils.createLoadsBasedOnDescriptor(mv, descriptor, lvarIndex);
                    String desc = new StringBuffer("(L").append(this.slashedname).append(";").append(descriptor.substring(1)).toString();
                    mv.visitMethodInsn(185, Utils.getInterfaceName(this.slashedname), name, desc);
                    Utils.addCorrectReturnInstruction(mv, returnType, true);
                    mv.visitLabel(l1);
                    mv.visitInsn(87);
                    int ps = Utils.getParameterCount(method.getDescriptor());
                    Utils.ReturnType methodReturnType = Utils.getReturnTypeDescriptor(method.getDescriptor());
                    if (MethodMember.isCatcherForInterfaceMethod(method)) {
                        mv.visitTypeInsn(187, "java/lang/IllegalStateException");
                        mv.visitInsn(89);
                        mv.visitMethodInsn(183, "java/lang/AbstractMethodError", "<init>", "()V");
                        mv.visitInsn(191);
                    } else {
                        mv.visitVarInsn(25, 0);
                        Utils.createLoadsBasedOnDescriptor(mv, method.getDescriptor(), 1);
                        mv.visitMethodInsn(183, this.supertypeName, method.getName(), method.getDescriptor());
                        Utils.addCorrectReturnInstruction(mv, methodReturnType, false);
                    }
                    int maxs = ps + 1;
                    if (methodReturnType.isDoubleSlot()) {
                        ++maxs;
                    }
                    mv.visitMaxs(maxs, maxs);
                    mv.visitEnd();
                }
                ++n;
            }
        }

        private void insertCorrectLoad(MethodVisitor mv, Utils.ReturnType rt, int slot) {
            block7: {
                block6: {
                    if (!rt.isPrimitive()) break block6;
                    switch (rt.descriptor.charAt(0)) {
                        case 'B': 
                        case 'C': 
                        case 'I': 
                        case 'S': 
                        case 'Z': {
                            mv.visitVarInsn(21, slot);
                            break block7;
                        }
                        case 'F': {
                            mv.visitVarInsn(23, slot);
                            break block7;
                        }
                        case 'J': {
                            mv.visitVarInsn(22, slot);
                            break block7;
                        }
                        case 'D': {
                            mv.visitVarInsn(24, slot);
                            break block7;
                        }
                        default: {
                            throw new IllegalStateException(rt.descriptor);
                        }
                    }
                }
                mv.visitVarInsn(25, slot);
            }
        }

        private void createProtectedFieldGetterSetter(FieldMember field) {
            String descriptor = field.descriptor;
            String name = field.name;
            Utils.ReturnType rt = Utils.ReturnType.getReturnType(descriptor);
            if (field.isStatic()) {
                MethodVisitor mv = this.cw.visitMethod(9, Utils.getProtectedFieldGetterName(name), "()" + descriptor, null, null);
                mv.visitFieldInsn(178, this.slashedname, name, descriptor);
                Utils.addCorrectReturnInstruction(mv, rt, false);
                mv.visitMaxs(rt.isDoubleSlot() ? 2 : 1, 0);
                mv.visitEnd();
                mv = this.cw.visitMethod(9, Utils.getProtectedFieldSetterName(name), "(" + descriptor + ")V", null, null);
                this.insertCorrectLoad(mv, rt, 0);
                mv.visitFieldInsn(179, this.slashedname, name, descriptor);
                mv.visitInsn(177);
                mv.visitMaxs(rt.isDoubleSlot() ? 2 : 1, 1);
                mv.visitEnd();
            } else {
                MethodVisitor mv = this.cw.visitMethod(1, Utils.getProtectedFieldGetterName(name), "()" + descriptor, null, null);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.slashedname, name, descriptor);
                Utils.addCorrectReturnInstruction(mv, rt, false);
                mv.visitMaxs(rt.isDoubleSlot() ? 2 : 1, 1);
                mv.visitEnd();
                mv = this.cw.visitMethod(1, Utils.getProtectedFieldSetterName(name), "(" + descriptor + ")V", null, null);
                mv.visitVarInsn(25, 0);
                this.insertCorrectLoad(mv, rt, 1);
                mv.visitFieldInsn(181, this.slashedname, name, descriptor);
                mv.visitInsn(177);
                mv.visitMaxs(rt.isDoubleSlot() ? 3 : 2, 2);
                mv.visitEnd();
            }
        }

        class AugmentingConstructorAdapter
        extends MethodAdapter
        implements Opcodes {
            int ctorId;
            String name;
            String descriptor;
            MethodMember method;
            String type;
            boolean isTopMost;
            int unitializedObjectsCount;

            public AugmentingConstructorAdapter(MethodVisitor mv, String descriptor, String type, boolean isTopMost) {
                super(mv);
                this.unitializedObjectsCount = 0;
                this.descriptor = descriptor;
                this.type = type;
                this.isTopMost = isTopMost;
            }

            public void visitCode() {
                super.visitCode();
                this.mv.visitFieldInsn(178, RewriteClassAdaptor.this.slashedname, "r$type", "Lorg/springsource/loaded/ReloadableType;");
                this.mv.visitLdcInsn(this.ctorId);
                this.mv.visitMethodInsn(182, "org/springsource/loaded/ReloadableType", "cchanged", "(I)Ljava/lang/Object;");
                Label wasNull = new Label();
                this.mv.visitInsn(89);
                this.mv.visitJumpInsn(198, wasNull);
                this.mv.visitTypeInsn(192, Utils.getInterfaceName(RewriteClassAdaptor.this.slashedname));
                this.mv.visitVarInsn(25, 0);
                if (RewriteClassAdaptor.this.isEnum) {
                    this.mv.visitVarInsn(25, 1);
                    this.mv.visitVarInsn(21, 2);
                    this.mv.visitInsn(1);
                    this.mv.visitMethodInsn(183, RewriteClassAdaptor.this.slashedname, "<init>", "(Ljava/lang/String;ILorg/springsource/loaded/C;)V");
                } else {
                    this.mv.visitInsn(1);
                    this.mv.visitMethodInsn(183, RewriteClassAdaptor.this.slashedname, "<init>", "(Lorg/springsource/loaded/C;)V");
                }
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, RewriteClassAdaptor.this.slashedname, "r$fields", "Lorg/springsource/loaded/ISMgr;");
                Label l1 = new Label();
                this.mv.visitJumpInsn(199, l1);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitTypeInsn(187, "org/springsource/loaded/ISMgr");
                this.mv.visitInsn(89);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(178, RewriteClassAdaptor.this.slashedname, "r$type", "Lorg/springsource/loaded/ReloadableType;");
                this.mv.visitMethodInsn(183, "org/springsource/loaded/ISMgr", "<init>", "(Ljava/lang/Object;Lorg/springsource/loaded/ReloadableType;)V");
                this.mv.visitFieldInsn(181, RewriteClassAdaptor.this.slashedname, "r$fields", "Lorg/springsource/loaded/ISMgr;");
                this.mv.visitLabel(l1);
                this.mv.visitVarInsn(25, 0);
                Utils.createLoadsBasedOnDescriptor(this.mv, this.descriptor, 1);
                String desc = "(L" + RewriteClassAdaptor.this.slashedname + ";" + this.descriptor.substring(1);
                this.mv.visitMethodInsn(185, Utils.getInterfaceName(RewriteClassAdaptor.this.slashedname), "___init___", desc);
                this.mv.visitInsn(177);
                this.mv.visitLabel(wasNull);
                this.mv.visitInsn(87);
            }

            public void visitTypeInsn(int opcode, String type) {
                if (opcode == 187) {
                    ++this.unitializedObjectsCount;
                }
                super.visitTypeInsn(opcode, type);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                super.visitMethodInsn(opcode, owner, name, desc);
                if (opcode == 183) {
                    --this.unitializedObjectsCount;
                }
                if (this.unitializedObjectsCount == -1 && this.isTopMost) {
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitFieldInsn(180, RewriteClassAdaptor.this.slashedname, "r$fields", "Lorg/springsource/loaded/ISMgr;");
                    Label l1 = new Label();
                    this.mv.visitJumpInsn(199, l1);
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitTypeInsn(187, "org/springsource/loaded/ISMgr");
                    this.mv.visitInsn(89);
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitFieldInsn(178, RewriteClassAdaptor.this.slashedname, "r$type", "Lorg/springsource/loaded/ReloadableType;");
                    this.mv.visitMethodInsn(183, "org/springsource/loaded/ISMgr", "<init>", "(Ljava/lang/Object;Lorg/springsource/loaded/ReloadableType;)V");
                    this.mv.visitFieldInsn(181, RewriteClassAdaptor.this.slashedname, "r$fields", "Lorg/springsource/loaded/ISMgr;");
                    this.mv.visitLabel(l1);
                }
            }
        }

        class AugmentingMethodAdapter
        extends MethodAdapter
        implements Opcodes {
            int methodId;
            String name;
            String descriptor;
            MethodMember method;
            Utils.ReturnType returnType;

            public AugmentingMethodAdapter(MethodVisitor mv, String name, String descriptor) {
                super(mv);
                this.name = name;
                this.method = RewriteClassAdaptor.this.rtype.getMethod(name, descriptor);
                this.methodId = this.method.getId();
                this.descriptor = descriptor;
                this.returnType = Utils.getReturnTypeDescriptor(descriptor);
            }

            public void visitCode() {
                super.visitCode();
                boolean isStaticMethod = this.method.isStatic();
                this.mv.visitFieldInsn(178, RewriteClassAdaptor.this.slashedname, "r$type", "Lorg/springsource/loaded/ReloadableType;");
                this.mv.visitLdcInsn(this.methodId);
                this.mv.visitMethodInsn(182, "org/springsource/loaded/ReloadableType", "changed", "(I)I");
                Label wasZero = new Label();
                if (!isStaticMethod) {
                    this.mv.visitInsn(89);
                }
                this.mv.visitJumpInsn(153, wasZero);
                if (!isStaticMethod) {
                    Label wasOne = new Label();
                    this.mv.visitInsn(4);
                    this.mv.visitJumpInsn(159, wasOne);
                    TypeDescriptor superDescriptor = RewriteClassAdaptor.this.rtype.getTypeRegistry().getDescriptorFor(RewriteClassAdaptor.this.supertypeName);
                    if (!superDescriptor.definesNonPrivate(String.valueOf(this.name) + this.descriptor)) {
                        this.insertThrowNoSuchMethodError();
                    } else {
                        this.insertInvokeSpecialToCallSuperMethod();
                    }
                    this.mv.visitLabel(wasOne);
                }
                this.mv.visitFieldInsn(178, RewriteClassAdaptor.this.slashedname, "r$type", "Lorg/springsource/loaded/ReloadableType;");
                this.mv.visitMethodInsn(182, "org/springsource/loaded/ReloadableType", "fetchLatest", "()Ljava/lang/Object;");
                this.mv.visitTypeInsn(192, Utils.getInterfaceName(RewriteClassAdaptor.this.slashedname));
                int lvarIndex = 0;
                if (!isStaticMethod) {
                    this.mv.visitVarInsn(25, lvarIndex++);
                } else {
                    this.mv.visitInsn(1);
                }
                Utils.createLoadsBasedOnDescriptor(this.mv, this.descriptor, lvarIndex);
                String desc = "(L" + RewriteClassAdaptor.this.slashedname + ";" + this.descriptor.substring(1);
                if (this.method.isStatic() && MethodMember.isClash(this.method)) {
                    this.name = "__" + this.name;
                }
                this.mv.visitMethodInsn(185, Utils.getInterfaceName(RewriteClassAdaptor.this.slashedname), this.name, desc);
                Utils.addCorrectReturnInstruction(this.mv, this.returnType, true);
                this.mv.visitLabel(wasZero);
                if (!isStaticMethod) {
                    this.mv.visitInsn(87);
                }
            }

            private void insertInvokeSpecialToCallSuperMethod() {
                int lvarIndex = 0;
                if (!Modifier.isStatic(this.method.getModifiers())) {
                    this.mv.visitVarInsn(25, lvarIndex++);
                }
                Utils.createLoadsBasedOnDescriptor(this.mv, this.descriptor, lvarIndex);
                this.mv.visitMethodInsn(183, RewriteClassAdaptor.this.supertypeName, this.name, this.descriptor);
                Utils.addCorrectReturnInstruction(this.mv, Utils.getReturnTypeDescriptor(this.descriptor), false);
            }

            private void insertThrowNoSuchMethodError() {
                String text = String.valueOf(RewriteClassAdaptor.this.rtype.getName()) + "." + this.name.replace('/', '.') + this.descriptor;
                this.mv.visitTypeInsn(187, "java/lang/NoSuchMethodError");
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(text);
                this.mv.visitMethodInsn(183, "java/lang/NoSuchMethodError", "<init>", "(Ljava/lang/String;)V");
                this.mv.visitInsn(191);
            }
        }

        class ClinitPrepender
        implements Prepender,
        Constants {
            MethodVisitor mv;

            ClinitPrepender(MethodVisitor mv) {
                this.mv = mv;
            }

            public void prepend() {
                this.mv.visitCode();
                this.mv.visitLdcInsn(RewriteClassAdaptor.this.rtype.getTypeRegistryId());
                this.mv.visitLdcInsn(RewriteClassAdaptor.this.rtype.getId());
                this.mv.visitMethodInsn(184, "org/springsource/loaded/TypeRegistry", "getReloadableType", "(II)Lorg/springsource/loaded/ReloadableType;");
                this.mv.visitFieldInsn(179, RewriteClassAdaptor.this.slashedname, "r$type", "Lorg/springsource/loaded/ReloadableType;");
                this.mv.visitFieldInsn(178, RewriteClassAdaptor.this.slashedname, "r$sfields", "Lorg/springsource/loaded/SSMgr;");
                Label l1 = new Label();
                this.mv.visitJumpInsn(199, l1);
                this.mv.visitTypeInsn(187, "org/springsource/loaded/SSMgr");
                this.mv.visitInsn(89);
                this.mv.visitMethodInsn(183, "org/springsource/loaded/SSMgr", "<init>", "()V");
                this.mv.visitFieldInsn(179, RewriteClassAdaptor.this.slashedname, "r$sfields", "Lorg/springsource/loaded/SSMgr;");
                this.mv.visitLabel(l1);
                this.mv.visitFieldInsn(178, RewriteClassAdaptor.this.slashedname, "r$type", "Lorg/springsource/loaded/ReloadableType;");
                this.mv.visitMethodInsn(182, "org/springsource/loaded/ReloadableType", "clinitchanged", "()I");
                Label wasZero = new Label();
                this.mv.visitJumpInsn(153, wasZero);
                this.mv.visitFieldInsn(178, RewriteClassAdaptor.this.slashedname, "r$type", "Lorg/springsource/loaded/ReloadableType;");
                this.mv.visitMethodInsn(182, "org/springsource/loaded/ReloadableType", "fetchLatest", "()Ljava/lang/Object;");
                this.mv.visitTypeInsn(192, Utils.getInterfaceName(RewriteClassAdaptor.this.slashedname));
                this.mv.visitMethodInsn(185, Utils.getInterfaceName(RewriteClassAdaptor.this.slashedname), "___clinit___", "()V");
                this.mv.visitInsn(177);
                this.mv.visitLabel(wasZero);
            }
        }

        static class FieldHolder {
            final int access;
            final String name;
            final String desc;

            public FieldHolder(int access, String name, String desc) {
                this.access = access;
                this.name = name;
                this.desc = desc;
            }
        }

        class MethodPrepender
        extends MethodAdapter
        implements Opcodes {
            Prepender appender;

            public MethodPrepender(MethodVisitor mv, Prepender appender) {
                super(mv);
                this.appender = appender;
            }

            public void visitCode() {
                super.visitCode();
                this.appender.prepend();
            }
        }

        static interface Prepender {
            public void prepend();
        }
    }
}

