/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springsource.loaded.AbstractMember;
import org.springsource.loaded.Constants;
import org.springsource.loaded.CurrentLiveVersion;
import org.springsource.loaded.FieldMember;
import org.springsource.loaded.FieldReaderWriter;
import org.springsource.loaded.GlobalConfiguration;
import org.springsource.loaded.InterfaceExtractor;
import org.springsource.loaded.MethodInvokerRewriter;
import org.springsource.loaded.MethodMember;
import org.springsource.loaded.ReflectionFieldReaderWriter;
import org.springsource.loaded.ReloadException;
import org.springsource.loaded.TypeDelta;
import org.springsource.loaded.TypeDescriptor;
import org.springsource.loaded.TypeDiffComputer;
import org.springsource.loaded.TypeRegistry;
import org.springsource.loaded.TypeRewriter;
import org.springsource.loaded.Utils;
import org.springsource.loaded.__DynamicallyDispatchable;
import org.springsource.loaded.agent.CglibPluginCapturing;
import org.springsource.loaded.infra.UsedByGeneratedCode;
import org.springsource.loaded.ri.Invoker;
import org.springsource.loaded.ri.JavaMethodCache;
import sl.org.objectweb.asm.ClassAdapter;
import sl.org.objectweb.asm.ClassReader;
import sl.org.objectweb.asm.ClassWriter;
import sun.misc.ProxyGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReloadableType {
    private static Logger log = Logger.getLogger(ReloadableType.class.getName());
    public TypeRegistry typeRegistry;
    public final String dottedtypename;
    public final String slashedtypename;
    private int id;
    public byte[] bytesInitial;
    public byte[] bytesLoaded;
    public final byte[] interfaceBytes;
    public TypeDescriptor typedescriptor;
    private CurrentLiveVersion liveVersion;
    private Class<?> clazz;
    private Class<?> superclazz;
    private ReloadableType superRtype;
    private JavaMethodCache javaMethodCache;
    private static final int IS_RESOLVED = 1;
    private int bits;
    public List<Invoker> invokersCache_getDeclaredMethods = null;
    public Collection<Invoker> invokersCache_getMethods = null;
    public Map<String, Map<String, Invoker>> invokerCache_getMethod = new HashMap<String, Map<String, Invoker>>();
    public Map<String, Map<String, Invoker>> invokerCache_getDeclaredMethod = new HashMap<String, Map<String, Invoker>>();
    public static final ReloadableType NOT_RELOADABLE_TYPE = new ReloadableType();
    public static final WeakReference<ReloadableType> NOT_RELOADABLE_TYPE_REF = new WeakReference<ReloadableType>(NOT_RELOADABLE_TYPE);
    private boolean determinedNeedToRetransform = false;
    private boolean retransformNecessary = false;
    private Object retransformWeavingTransformer;
    private Method retransformWeavingTransformMethod;
    Object[] reflectiveTargets;
    private static final int INDEX_SWAPINIT_METHOD = 0;
    private static final int INDEX_CALLSITEARRAY_FIELD = 1;
    private static final int INDEX_METACLASS_FIELD = 2;
    private Set<WeakReference<Object>> liveInstances = Collections.synchronizedSet(new HashSet());
    private ReferenceQueue<Object> liveInstancesRQ = new ReferenceQueue();
    public Reference<Method[]> jlClassGetDeclaredMethods_cache = new WeakReference<Object>(null);
    public Reference<Method[]> jlClassGetMethods_cache = new WeakReference<Object>(null);

    public Class<?> getClazz() {
        if (this.clazz == null) {
            try {
                this.clazz = Class.forName(this.dottedtypename, false, this.typeRegistry.getClassLoader());
            }
            catch (ClassNotFoundException cnfe) {
                throw new ReloadException("Unexpectedly unable to find class " + this.dottedtypename + ".  Asked classloader " + this.typeRegistry.getClassLoader(), cnfe);
            }
        }
        return this.clazz;
    }

    public String toString() {
        return this.dottedtypename;
    }

    public ReloadableType(String dottedtypename, byte[] initialBytes, int id, TypeRegistry typeRegistry, TypeDescriptor typeDescriptor) {
        this.id = id;
        this.typeRegistry = typeRegistry;
        this.dottedtypename = dottedtypename;
        this.slashedtypename = dottedtypename.replace('.', '/');
        this.typedescriptor = typeDescriptor != null ? typeDescriptor : typeRegistry.getExtractor().extract(initialBytes, true);
        this.interfaceBytes = InterfaceExtractor.extract(initialBytes, typeRegistry, this.typedescriptor);
        this.bytesInitial = initialBytes;
        this.rewriteCallSitesAndDefine();
    }

    private ReloadableType() {
        this.slashedtypename = null;
        this.dottedtypename = null;
        this.interfaceBytes = null;
    }

    public TypeDescriptor getTypeDescriptor() {
        return this.typedescriptor;
    }

    public MethodMember getMethod(String name, String descriptor) {
        MethodMember[] methodMemberArray = this.typedescriptor.getMethods();
        int n = methodMemberArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodMember method = methodMemberArray[n2];
            if (method.getName().equals(name) && method.getDescriptor().equals(descriptor)) {
                return method;
            }
            ++n2;
        }
        throw new IllegalStateException("Unable to find member '" + name + descriptor + "' on type " + this.dottedtypename);
    }

    public MethodMember getConstructor(String descriptor) {
        MethodMember[] methodMemberArray = this.typedescriptor.getConstructors();
        int n = methodMemberArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodMember ctor = methodMemberArray[n2];
            if (ctor.getDescriptor().equals(descriptor)) {
                return ctor;
            }
            ++n2;
        }
        throw new IllegalStateException("Unable to find constructor '<init>" + descriptor + "' on type " + this.dottedtypename);
    }

    private byte[] retransform(byte[] bytes) {
        block10: {
            if (!this.determinedNeedToRetransform) {
                try {
                    String s = System.getProperty("insight.enabled", "false");
                    if (s.equals("true")) {
                        ClassLoader cl = this.typeRegistry.getClassLoader();
                        Field f = cl.getClass().getSuperclass().getDeclaredField("weavingTransformer");
                        if (f != null) {
                            f.setAccessible(true);
                            this.retransformWeavingTransformer = f.get(cl);
                            this.retransformWeavingTransformMethod = this.retransformWeavingTransformer.getClass().getDeclaredMethod("transformIfNecessary", String.class, byte[].class);
                            this.retransformNecessary = true;
                        }
                        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                            log.info("Determining if retransform necessary, result = " + this.retransformNecessary);
                        }
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Unexpected exception when determining if Spring Insight enabled", e);
                    this.retransformNecessary = false;
                }
                this.determinedNeedToRetransform = true;
            }
            if (this.retransformNecessary) {
                try {
                    this.retransformWeavingTransformMethod.setAccessible(true);
                    byte[] newdata = (byte[])this.retransformWeavingTransformMethod.invoke(this.retransformWeavingTransformer, this.slashedtypename, bytes);
                    if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                        log.info("retransform was attempted, oldsize=" + bytes.length + " newsize=" + newdata.length);
                    }
                    return newdata;
                }
                catch (Exception e) {
                    if (!GlobalConfiguration.isRuntimeLogging) break block10;
                    log.log(Level.SEVERE, "Unexpected exception when trying to run other weaving transformers", e);
                }
            }
        }
        return bytes;
    }

    public boolean loadNewVersion(byte[] newbytedata) {
        return this.loadNewVersion("2", newbytedata);
    }

    public boolean simulateReload() {
        return this.loadNewVersion("0", this.bytesInitial);
    }

    public boolean loadNewVersion(String versionsuffix, byte[] newbytedata, boolean shouldRerunStaticInitializer) {
        boolean reloadedOK = this.loadNewVersion(versionsuffix, newbytedata);
        if (reloadedOK) {
            this.runStaticInitializer();
        }
        return reloadedOK;
    }

    public boolean loadNewVersion(String versionsuffix, byte[] newbytedata) {
        this.javaMethodCache = null;
        newbytedata = this.retransform(newbytedata);
        boolean reload = true;
        TypeDelta td = null;
        if (GlobalConfiguration.verifyReloads && (td = TypeDiffComputer.computeDifferences(this.bytesInitial, newbytedata)).hasAnythingChanged()) {
            boolean cantReload = false;
            StringBuilder s = null;
            if (td.hasTypeDeclarationChanged()) {
                reload = false;
                s = new StringBuilder("Spring Loaded: Cannot reload new version of ").append(this.dottedtypename).append("\n");
                if (td.hasTypeAccessChanged()) {
                    s.append(" Reason: Type modifiers changed\n");
                    cantReload = true;
                }
                if (td.hasTypeSupertypeChanged()) {
                    s.append(" Reason: Supertype changed from ").append(td.oSuperName).append(" to ").append(td.nSuperName).append("\n");
                    cantReload = true;
                }
                if (td.hasTypeInterfacesChanged()) {
                    boolean justGroovyObjectMoved = false;
                    if (!cantReload && this.getTypeDescriptor().isGroovyType()) {
                        ArrayList<String> interfaceChanges = new ArrayList<String>();
                        interfaceChanges.addAll(td.oInterfaces);
                        interfaceChanges.removeAll(td.nInterfaces);
                        if (this.getTypeDescriptor().isGroovyType() && interfaceChanges.size() == 1 && ((String)interfaceChanges.get(0)).equals("groovy/lang/GroovyObject")) {
                            justGroovyObjectMoved = true;
                            s = null;
                            reload = true;
                        }
                    }
                    if (!justGroovyObjectMoved) {
                        s.append(" Reason: Interfaces changed from ").append(td.oInterfaces).append(" to ").append(td.nInterfaces).append("\n");
                        cantReload = true;
                    }
                }
            }
            boolean somethingCalled = false;
            if (cantReload && td.hasAnythingChanged()) {
                somethingCalled = this.typeRegistry.fireUnableToReloadEvent(this, td, versionsuffix);
            }
            if (cantReload && s == null && td.hasAnythingChanged() && !somethingCalled) {
                System.out.println("Something has changed preventing reload");
            }
            if (!somethingCalled && s != null) {
                System.out.println(s);
            }
        }
        if (reload) {
            TypeRegistry.nothingReloaded = false;
            this.invokersCache_getDeclaredMethods = null;
            if (GlobalConfiguration.reloadMessages) {
                System.out.println("Reloading: Loading new version of " + this.dottedtypename + " [" + versionsuffix + "]");
            }
            if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
                log.info("Reloading: Loading new version of " + this.dottedtypename + " [" + versionsuffix + "]");
            }
            this.liveVersion = new CurrentLiveVersion(this, versionsuffix, newbytedata);
            this.liveVersion.setTypeDelta(td);
            this.typeRegistry.reloadableTypeDescriptorCache.put(this.slashedtypename, this.liveVersion.typeDescriptor);
            if (this.typedescriptor.isGroovyType()) {
                this.fixupGroovyType();
            }
            if (this.typedescriptor.isEnum()) {
                this.resetEnumRelatedState();
            }
            if (this.typeRegistry.shouldRerunStaticInitializer(this, versionsuffix) || this.typedescriptor.isEnum()) {
                this.liveVersion.staticInitializedNeedsRerunningOnDefine = true;
                this.liveVersion.runStaticInitializer();
            } else {
                this.liveVersion.staticInitializedNeedsRerunningOnDefine = false;
            }
            this.typeRegistry.fireReloadEvent(this, versionsuffix);
            this.reloadProxiesIfNecessary(versionsuffix);
        }
        return reload;
    }

    private void resetEnumRelatedState() {
        Field f;
        if (this.clazz == null) {
            return;
        }
        try {
            f = this.clazz.getClass().getDeclaredField("enumConstants");
            f.setAccessible(true);
            f.set(this.clazz, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            f = this.clazz.getClass().getDeclaredField("enumConstantDirectory");
            f.setAccessible(true);
            f.set(this.clazz, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void dump(byte[] newbytedata) {
        String slashedName = this.getSlashedName();
        if (slashedName.contains("BookController")) {
            GlobalConfiguration.dumpFolder = "/Users/aclement/Downloads/grails8344";
            Utils.dump(String.valueOf(slashedName) + "O", this.bytesInitial);
            Utils.dump(String.valueOf(slashedName) + "L", this.bytesLoaded);
            Utils.dump(String.valueOf(slashedName) + "N", newbytedata);
            Utils.dump(String.valueOf(slashedName) + "E", this.liveVersion.executor);
            Utils.dump(String.valueOf(slashedName) + "D", this.liveVersion.dispatcher);
        }
    }

    private void reloadProxiesIfNecessary(String versionsuffix) {
        byte[] bs;
        Method m;
        int n;
        int n2;
        Method[] methodArray;
        Method found;
        Method[] ms;
        Object b;
        Object a;
        ReloadableType proxy = this.typeRegistry.cglibProxies.get(this.slashedtypename);
        if (proxy != null) {
            Object[] strategyAndGeneratorPair = CglibPluginCapturing.clazzToGeneratorStrategyAndClassGeneratorMap.get(this.getClazz());
            a = strategyAndGeneratorPair[0];
            b = strategyAndGeneratorPair[1];
            try {
                ms = a.getClass().getMethods();
                found = null;
                methodArray = ms;
                n2 = ms.length;
                n = 0;
                while (n < n2) {
                    m = methodArray[n];
                    if (m.getName().equals("generate")) {
                        found = m;
                        break;
                    }
                    ++n;
                }
                bs = (byte[])found.invoke(a, b);
                proxy.loadNewVersion(versionsuffix, bs);
                proxy.runStaticInitializer();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if ((proxy = this.typeRegistry.cglibProxiesFastClass.get(this.slashedtypename)) != null) {
            Object[] strategyAndFCGeneratorPair = CglibPluginCapturing.clazzToGeneratorStrategyAndFastClassGeneratorMap.get(this.getClazz());
            strategyAndFCGeneratorPair = CglibPluginCapturing.clazzToGeneratorStrategyAndFastClassGeneratorMap.get(this.getClazz());
            if (strategyAndFCGeneratorPair != null) {
                a = strategyAndFCGeneratorPair[0];
                b = strategyAndFCGeneratorPair[1];
                try {
                    ms = a.getClass().getMethods();
                    found = null;
                    methodArray = ms;
                    n2 = ms.length;
                    n = 0;
                    while (n < n2) {
                        m = methodArray[n];
                        if (m.getName().equals("generate")) {
                            found = m;
                            break;
                        }
                        ++n;
                    }
                    bs = (byte[])found.invoke(a, b);
                    proxy.loadNewVersion(versionsuffix, bs);
                    proxy.runStaticInitializer();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        try {
            Set<ReloadableType> relevantProxies;
            if (this.clazz.isInterface() && (relevantProxies = this.typeRegistry.jdkProxiesForInterface.get(this.slashedtypename)) != null) {
                for (ReloadableType relevantProxy : relevantProxies) {
                    Class[] interfacesImplementedByProxy = relevantProxy.getClazz().getInterfaces();
                    byte[] newProxyBytes = ProxyGenerator.generateProxyClass((String)relevantProxy.getSlashedName(), (Class[])interfacesImplementedByProxy);
                    relevantProxy.loadNewVersion(versionsuffix, newProxyBytes, true);
                }
            }
        }
        catch (Throwable t) {
            new RuntimeException("Unexpected problem trying to reload proxy for interface " + this.dottedtypename, t).printStackTrace();
        }
    }

    public void fixupGroovyType() {
        Object lazyReferenceClass;
        Field f;
        StringBuilder s = new StringBuilder();
        if (this.reflectiveTargets == null) {
            this.reflectiveTargets = new Object[5];
            try {
                this.reflectiveTargets[0] = this.clazz.getDeclaredMethod("__$swapInit", new Class[0]);
            }
            catch (Exception e) {
                s.append("cannot discover __$swapInit " + e.toString() + "  --  ");
            }
            try {
                this.reflectiveTargets[1] = this.clazz.getDeclaredField("$callSiteArray");
            }
            catch (Exception e) {
                s.append("cannot discover $callSiteArray " + e.toString() + "  --  ");
            }
            try {
                this.reflectiveTargets[2] = this.clazz.getDeclaredField("$class$groovy$lang$MetaClass");
            }
            catch (Exception e) {
                s.append("cannot discover $class$groovy$lang$MetaClass " + e.toString() + "  --  ");
            }
            try {
                this.reflectiveTargets[3] = this.clazz.getDeclaredField("$staticClassInfo");
            }
            catch (Exception e) {
                s.append("cannot discover $staticClassInfo " + e.toString() + "  --  ");
            }
        }
        try {
            Method m = null;
            f = null;
            if (this.reflectiveTargets[0] != null) {
                m = (Method)this.reflectiveTargets[0];
                m.setAccessible(true);
                m.invoke(null, new Object[0]);
            }
            if (this.reflectiveTargets[1] != null) {
                f = (Field)this.reflectiveTargets[1];
                f.setAccessible(true);
                f.set(null, null);
            }
            if (this.reflectiveTargets[2] != null) {
                f = (Field)this.reflectiveTargets[2];
                f.setAccessible(true);
                f.set(null, null);
            }
            if (this.reflectiveTargets[3] != null) {
                f = (Field)this.reflectiveTargets[3];
                f.setAccessible(true);
                f.set(null, null);
            }
        }
        catch (Exception e) {
            s.append("cannot reset state" + e.toString() + "  --  ");
        }
        try {
            Class<?> clazz = this.typeRegistry.getClass_GroovySystem();
            Field metaClassRegistryField = clazz.getDeclaredField("META_CLASS_REGISTRY");
            metaClassRegistryField.setAccessible(true);
            Object metaClassRegistry = metaClassRegistryField.get(null);
            Method metaClassRegistryMethod = metaClassRegistry.getClass().getDeclaredMethod("removeMetaClass", Class.class);
            metaClassRegistryMethod.setAccessible(true);
            metaClassRegistryMethod.invoke(metaClassRegistry, this.getClazz());
        }
        catch (Exception e) {
            s.append("Unable to remove meta class for groovy type " + this.dottedtypename + ": " + e.toString() + "  --  ");
        }
        try {
            Method getClassInfoMethod = this.typeRegistry.getMethod_ClassInfo_getClassInfo();
            Object classInfoObject = getClassInfoMethod.invoke(null, this.clazz);
            Field cachedClassRefField = this.typeRegistry.getField_ClassInfo_cachedClassRef();
            cachedClassRefField.setAccessible(true);
            Object cachedClassRefObject = cachedClassRefField.get(classInfoObject);
            lazyReferenceClass = cachedClassRefObject.getClass();
            Method clearMethod = ((Class)lazyReferenceClass).getMethod("clear", new Class[0]);
            clearMethod.invoke(cachedClassRefObject, new Object[0]);
        }
        catch (Exception e) {
            s.append("1 Unable to clear ClassInfo CachedClass data for groovy type " + this.dottedtypename + ": " + e.toString() + "  --  ");
        }
        try {
            Class<?> class_ClassInfo = this.typeRegistry.getClass_ClassInfo();
            Field field_globalClassSet = class_ClassInfo.getDeclaredField("globalClassSet");
            field_globalClassSet.setAccessible(true);
            Object instance_classInfoSet = field_globalClassSet.get(null);
            Method method_ClassInfoSetRemove = instance_classInfoSet.getClass().getMethod("remove", Object.class);
            lazyReferenceClass = method_ClassInfoSetRemove.invoke(instance_classInfoSet, this.clazz);
        }
        catch (Exception e) {
            s.append("2 Unable to clear ClassInfo CachedClass data for groovy type " + this.dottedtypename + ": " + e.toString() + "  --  ");
        }
        try {
            HashSet<WeakReference<Object>> deadInstances = null;
            f = this.getClazz().getDeclaredField("metaClass");
            for (WeakReference<Object> instance : this.liveInstances) {
                Object o = instance.get();
                if (o == null) {
                    if (deadInstances == null) {
                        deadInstances = new HashSet<WeakReference<Object>>();
                    }
                    deadInstances.add(instance);
                    continue;
                }
                f.setAccessible(true);
                f.set(o, null);
            }
            if (deadInstances != null) {
                this.liveInstances.removeAll(deadInstances);
            }
        }
        catch (Exception e) {
            s.append("2 Unable to clear metaClass for groovy object instance (class=" + this.dottedtypename + ") " + e.toString() + "  --  ");
        }
    }

    public byte[] getLatestDispatcherBytes() {
        return this.liveVersion == null ? null : this.liveVersion.dispatcher;
    }

    public Class<?> getLatestDispatcherClass() {
        return this.liveVersion == null ? null : this.liveVersion.dispatcherClass;
    }

    public byte[] getInterfaceBytes() {
        return this.interfaceBytes;
    }

    public Object getLatestDispatcherInstance() {
        return this.liveVersion == null ? null : this.liveVersion.dispatcherInstance;
    }

    public Object getLatestDispatcherInstance(boolean b) {
        if (b) {
            if (this.liveVersion == null) {
                this.loadNewVersion("0", this.bytesInitial);
            }
            return this.liveVersion.dispatcherInstance;
        }
        return this.liveVersion == null ? null : this.liveVersion.dispatcherInstance;
    }

    public String getLatestDispatcherName() {
        return this.liveVersion == null ? null : this.liveVersion.dispatcherName;
    }

    public byte[] getBytesInitial() {
        return this.bytesInitial;
    }

    public byte[] getBytesLoaded() {
        return this.bytesLoaded;
    }

    public byte[] getLatestExecutorBytes() {
        return this.liveVersion == null ? null : this.liveVersion.executor;
    }

    public Class<?> getLatestExecutorClass() {
        return this.liveVersion == null ? null : this.liveVersion.getExecutorClass();
    }

    public String getLatestExecutorName() {
        return this.liveVersion == null ? null : this.liveVersion.executorName;
    }

    public MethodMember getCurrentMethod(String name, String descriptor) {
        if (this.liveVersion == null) {
            return this.getMethod(name, descriptor);
        }
        return this.liveVersion.getReloadableMethod(name, descriptor);
    }

    public MethodMember getOriginalMethod(String nameAndDescriptor) {
        return this.getMethod(nameAndDescriptor);
    }

    public String getName() {
        return this.dottedtypename;
    }

    public String getSlashedName() {
        return this.slashedtypename;
    }

    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public int getTypeRegistryId() {
        return this.typeRegistry.getId();
    }

    public int getId() {
        return this.id;
    }

    public void rewriteCallSitesAndDefine() {
        this.bytesLoaded = MergedRewrite.rewrite(this, this.bytesInitial);
        if (!this.typedescriptor.isInterface()) {
            this.typeRegistry.defineClass(Utils.getInterfaceName(this.dottedtypename), this.interfaceBytes, true);
        }
        if (this.typeRegistry.shouldDefineClasses()) {
            this.clazz = this.typeRegistry.defineClass(this.dottedtypename, this.bytesLoaded, true);
        }
    }

    public Object fetchLatest() {
        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, "fetchLatest called on " + this.getName());
        }
        return this.liveVersion.dispatcherInstance;
    }

    public boolean hasBeenReloaded() {
        return this.liveVersion != null;
    }

    public CurrentLiveVersion getLiveVersion() {
        return this.liveVersion;
    }

    public boolean cchanged(String descriptor) {
        if (this.liveVersion != null) {
            boolean b = this.liveVersion.hasConstructorChanged(descriptor);
            return b;
        }
        return false;
    }

    @UsedByGeneratedCode
    public Object cchanged(int ctorId) {
        boolean b;
        if (this.liveVersion != null && (b = this.liveVersion.hasConstructorChanged(ctorId))) {
            return this.getLatestDispatcherInstance();
        }
        return null;
    }

    @UsedByGeneratedCode
    public int changed(int methodId) {
        if (this.liveVersion == null) {
            return 0;
        }
        int retval = 0;
        if (this.liveVersion != null) {
            boolean b;
            if (GlobalConfiguration.logging && log.isLoggable(Level.FINER)) {
                log.info("MethodId=" + methodId + " method=" + this.typedescriptor.getMethod(methodId));
            }
            retval = (b = this.liveVersion.incrementalTypeDescriptor.hasBeenDeleted(methodId)) ? 2 : (this.liveVersion.incrementalTypeDescriptor.mustUseExecutorForThisMethod(methodId) ? 1 : 0);
        }
        return retval;
    }

    @UsedByGeneratedCode
    public int clinitchanged() {
        if (GlobalConfiguration.logging && log.isLoggable(Level.FINER)) {
            log.entering("ReloadableType", "clinitchanged", null);
        }
        int retval = 0;
        if (this.liveVersion != null) {
            int n = retval = this.liveVersion.hasClinit() ? 1 : 0;
        }
        if (GlobalConfiguration.logging && log.isLoggable(Level.FINER)) {
            log.exiting("ReloadableType", "clinitchanged", retval);
        }
        return retval;
    }

    @UsedByGeneratedCode
    public Object fetchLatestIfExists(int methodId) {
        if (TypeRegistry.nothingReloaded) {
            return null;
        }
        if (this.changed(methodId) == 0) {
            return null;
        }
        return this.fetchLatest();
    }

    public String getSlashedSupertypeName() {
        return this.getTypeDescriptor().getSupertypeName();
    }

    @UsedByGeneratedCode
    public __DynamicallyDispatchable getDispatcher() {
        __DynamicallyDispatchable dd = null;
        if (this.liveVersion == null) {
            this.simulateReload();
        }
        dd = (__DynamicallyDispatchable)this.liveVersion.dispatcherInstance;
        return dd;
    }

    @UsedByGeneratedCode
    public __DynamicallyDispatchable determineDispatcher(Object instance, String nameAndDescriptor) {
        if (nameAndDescriptor.startsWith("<init>")) {
            if (!this.hasBeenReloaded()) {
                this.loadNewVersion("0", this.bytesInitial);
            }
            return (__DynamicallyDispatchable)this.getLiveVersion().dispatcherInstance;
        }
        String dynamicTypeName = instance.getClass().getName();
        ReloadableType rtype = this.typeRegistry.getReloadableType(dynamicTypeName.replace('.', '/'));
        if (rtype == null) {
            throw new ReloadException("ReloadableType.determineDispatcher(): expected " + dynamicTypeName + " to be reloadable");
        }
        boolean found = false;
        while (rtype != null && !found) {
            Object mm;
            Object mms;
            if (rtype.hasBeenReloaded()) {
                mms = rtype.getLiveVersion().incrementalTypeDescriptor.getNewOrChangedMethods();
                Iterator iterator = mms.iterator();
                while (iterator.hasNext()) {
                    mm = (MethodMember)iterator.next();
                    if (((AbstractMember)mm).isPrivate() || !((MethodMember)mm).getNameAndDescriptor().equals(nameAndDescriptor)) continue;
                    found = true;
                    break;
                }
            } else {
                Object object = mms = rtype.getTypeDescriptor().getMethods();
                int n = ((Object)object).length;
                int n2 = 0;
                while (n2 < n) {
                    mm = object[n2];
                    if (((MethodMember)mm).getNameAndDescriptor().equals(nameAndDescriptor) && !MethodMember.isCatcher((MethodMember)mm)) {
                        found = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (found) continue;
            String slashedSupername = rtype.getTypeDescriptor().getSupertypeName();
            rtype = this.typeRegistry.getReloadableType(slashedSupername);
        }
        if (found && GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, "appears that type " + rtype.getName() + " implements " + nameAndDescriptor);
        }
        if (rtype == null) {
            return null;
        }
        if (!rtype.hasBeenReloaded()) {
            rtype.loadNewVersion("0", rtype.bytesInitial);
        }
        return (__DynamicallyDispatchable)rtype.getLiveVersion().dispatcherInstance;
    }

    public String getBaseName() {
        int dotIndex = this.dottedtypename.lastIndexOf(".");
        if (dotIndex == -1) {
            return this.dottedtypename;
        }
        return this.dottedtypename.substring(dotIndex + 1);
    }

    public TypeDescriptor getLatestTypeDescriptor() {
        if (this.liveVersion == null) {
            return this.typedescriptor;
        }
        return this.liveVersion.incrementalTypeDescriptor.getLatestTypeDescriptor();
    }

    public MethodMember getFromLatestByDescriptor(String nameAndDescriptor) {
        return this.getLiveVersion().incrementalTypeDescriptor.getFromLatestByDescriptor(nameAndDescriptor);
    }

    public MethodMember getMethod(String nameAndDescriptor) {
        MethodMember[] methodMemberArray = this.typedescriptor.getMethods();
        int n = methodMemberArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodMember method = methodMemberArray[n2];
            if (nameAndDescriptor.startsWith(method.getName()) && nameAndDescriptor.endsWith(method.getDescriptor())) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public MethodMember getCurrentConstructor(String desc) {
        TypeDescriptor typeDesc = this.getLatestTypeDescriptor();
        return typeDesc.getConstructor(desc);
    }

    public MethodMember getOriginalConstructor(String desc) {
        MethodMember[] methodMemberArray = this.typedescriptor.getConstructors();
        int n = methodMemberArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodMember method = methodMemberArray[n2];
            if (method.getDescriptor().equals(desc)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public JavaMethodCache getJavaMethodCache() {
        if (this.javaMethodCache == null) {
            this.javaMethodCache = new JavaMethodCache();
        }
        return this.javaMethodCache;
    }

    public FieldMember findInstanceField(String name) {
        FieldMember found = this.getLatestTypeDescriptor().getField(name);
        if (found != null) {
            return found;
        }
        String slashedSupername = this.getTypeDescriptor().getSupertypeName();
        ReloadableType rtype = this.typeRegistry.getReloadableType(slashedSupername);
        while (rtype != null) {
            found = rtype.getLatestTypeDescriptor().getField(name);
            if (found != null) break;
            slashedSupername = rtype.getTypeDescriptor().getSupertypeName();
            rtype = this.typeRegistry.getReloadableType(slashedSupername);
        }
        return found;
    }

    public FieldMember findStaticField(String name) {
        return this.searchType(this, name);
    }

    private FieldMember searchType(ReloadableType rtype, String fieldname) {
        if (rtype != null) {
            ReloadableType stype;
            TypeDescriptor td = rtype.getLatestTypeDescriptor();
            FieldMember field = td.getField(fieldname);
            if (field != null) {
                return field;
            }
            String[] interfaces = td.getSuperinterfacesName();
            if (interfaces != null) {
                String[] stringArray = interfaces;
                int n = interfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    String intface = stringArray[n2];
                    ReloadableType itype = this.typeRegistry.getReloadableType(intface);
                    if (intface != null && (field = this.searchType(itype, fieldname)) != null) {
                        return field;
                    }
                    ++n2;
                }
            }
            if ((stype = this.typeRegistry.getReloadableType(td.getSupertypeName())) != null) {
                return this.searchType(stype, fieldname);
            }
        }
        return null;
    }

    public void setField(Object instance, String fieldname, boolean isStatic, Object newValue) throws IllegalAccessException {
        FieldReaderWriter fieldReaderWriter = this.locateField(fieldname);
        if (isStatic && !fieldReaderWriter.isStatic()) {
            throw new IncompatibleClassChangeError("Expected static field " + fieldReaderWriter.theField.getDeclaringTypeName() + "." + fieldReaderWriter.theField.getName());
        }
        if (!isStatic && fieldReaderWriter.isStatic()) {
            throw new IncompatibleClassChangeError("Expected non-static field " + fieldReaderWriter.theField.getDeclaringTypeName() + "." + fieldReaderWriter.theField.getName());
        }
        if (fieldReaderWriter.isStatic()) {
            fieldReaderWriter.setStaticFieldValue(this.getClazz(), newValue, null);
        } else {
            fieldReaderWriter.setValue(instance, newValue, null);
        }
    }

    public Object getField(Object instance, String fieldname, boolean isStatic) throws IllegalAccessException {
        FieldReaderWriter fieldReaderWriter = this.locateField(fieldname);
        if (isStatic && !fieldReaderWriter.isStatic()) {
            throw new IncompatibleClassChangeError("Expected static field " + fieldReaderWriter.theField.getDeclaringTypeName() + "." + fieldReaderWriter.theField.getName());
        }
        if (!isStatic && fieldReaderWriter.isStatic()) {
            throw new IncompatibleClassChangeError("Expected non-static field " + fieldReaderWriter.theField.getDeclaringTypeName() + "." + fieldReaderWriter.theField.getName());
        }
        Object o = null;
        o = fieldReaderWriter.isStatic() ? fieldReaderWriter.getStaticFieldValue(this.getClazz(), null) : fieldReaderWriter.getValue(instance, null);
        return o;
    }

    public FieldReaderWriter locateField(String name) {
        if (this.hasFieldChangedInHierarchy(name)) {
            return this.walk(name, this.getLatestTypeDescriptor());
        }
        return this.getFieldInHierarchy(name);
    }

    public FieldReaderWriter walk(String name, TypeDescriptor typeDescriptor) {
        String[] superinterfaceNames;
        FieldMember theField = typeDescriptor.getField(name);
        if (theField != null) {
            return new FieldReaderWriter(theField, typeDescriptor);
        }
        String[] stringArray = superinterfaceNames = typeDescriptor.getSuperinterfacesName();
        int n = superinterfaceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String superinterfaceName = stringArray[n2];
            TypeDescriptor interfaceTypeDescriptor = this.getTypeRegistry().getLatestDescriptorFor(superinterfaceName);
            FieldReaderWriter locator = this.walk(name, interfaceTypeDescriptor);
            if (locator != null) {
                return locator;
            }
            ++n2;
        }
        String supertypename = typeDescriptor.getSupertypeName();
        if (supertypename != null) {
            TypeDescriptor superTypeDescriptor = this.getTypeRegistry().getLatestDescriptorFor(supertypename);
            FieldReaderWriter locator = this.walk(name, superTypeDescriptor);
            return locator;
        }
        return null;
    }

    private FieldWalkDiscoveryResult hasFieldChangedInHierarchy(String fieldname, String slashedName) {
        ReloadableType rtype = this.typeRegistry.getReloadableType(slashedName);
        if (rtype == null) {
            return FieldWalkDiscoveryResult.UNCHANGED_STOPWALKINGNOW;
        }
        TypeDescriptor originalTypeDescriptor = rtype.getTypeDescriptor();
        FieldMember originalField = originalTypeDescriptor.getField(fieldname);
        TypeDescriptor typedescriptor = rtype.getLatestTypeDescriptor();
        FieldMember field = typedescriptor.getField(fieldname);
        if (originalField != null && field == null) {
            return FieldWalkDiscoveryResult.CHANGED_STOPNOW;
        }
        if (originalField != null && field != null) {
            if (originalField.equals(field)) {
                return FieldWalkDiscoveryResult.UNCHANGED_STOPWALKINGNOW;
            }
            return FieldWalkDiscoveryResult.CHANGED_STOPNOW;
        }
        if (originalField == null && field != null) {
            return FieldWalkDiscoveryResult.CHANGED_STOPNOW;
        }
        String[] interfaces = originalTypeDescriptor.superinterfaceNames;
        if (interfaces != null) {
            String[] stringArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                String intface = stringArray[n2];
                FieldWalkDiscoveryResult b = this.hasFieldChangedInHierarchy(fieldname, intface);
                if (b != FieldWalkDiscoveryResult.DONTKNOW) {
                    return b;
                }
                ++n2;
            }
        }
        return this.hasFieldChangedInHierarchy(fieldname, originalTypeDescriptor.supertypeName);
    }

    public boolean hasFieldChangedInHierarchy(String name) {
        ReloadableType rtype = this;
        FieldMember field = null;
        TypeDescriptor originalTypeDescriptor = rtype.getTypeDescriptor();
        FieldMember originalField = originalTypeDescriptor.getField(name);
        TypeDescriptor typedescriptor = rtype.getLatestTypeDescriptor();
        field = typedescriptor.getField(name);
        if (originalField != null && field == null) {
            return true;
        }
        if (originalField != null && field != null) {
            return !originalField.equals(field);
        }
        if (originalField == null && field != null) {
            return true;
        }
        FieldWalkDiscoveryResult b = this.hasFieldChangedInHierarchy(name, rtype.getTypeDescriptor().getSupertypeName());
        switch (b) {
            case CHANGED_STOPNOW: {
                return true;
            }
            case UNCHANGED_STOPWALKINGNOW: {
                return false;
            }
            case DONTKNOW: {
                throw new IllegalStateException();
            }
        }
        throw new IllegalStateException();
    }

    private Field findField(Class<?> clazz, String name) {
        Class<?> supertype;
        int n;
        int n2;
        AnnotatedElement[] annotatedElementArray;
        AnnotatedElement field = null;
        try {
            Field[] fields = clazz.getDeclaredFields();
            if (fields != null) {
                annotatedElementArray = fields;
                n2 = fields.length;
                n = 0;
                while (n < n2) {
                    AnnotatedElement field2 = annotatedElementArray[n];
                    if (((Field)field2).getName().equals(name)) {
                        field = field2;
                    }
                    ++n;
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (field != null) {
            return field;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces != null) {
            annotatedElementArray = interfaces;
            n2 = interfaces.length;
            n = 0;
            while (n < n2) {
                AnnotatedElement intface = annotatedElementArray[n];
                field = this.findField((Class<?>)intface, name);
                if (field != null) {
                    return field;
                }
                ++n;
            }
        }
        if ((supertype = clazz.getSuperclass()) != null) {
            return this.findField(supertype, name);
        }
        return null;
    }

    public FieldReaderWriter getFieldInHierarchy(String name) {
        return new ReflectionFieldReaderWriter(this.findField(this.getClazz(), name));
    }

    public void clearClassloaderLinks() {
        if (this.hasBeenReloaded()) {
            this.liveVersion.clearClassloaderLinks();
        }
    }

    public void reloadMostRecentDispatcherAndExecutor() {
        if (this.hasBeenReloaded()) {
            this.liveVersion.reloadMostRecentDispatcherAndExecutor();
        }
    }

    public void trackLiveInstance(Object instance) {
        Reference<Object> r;
        while ((r = this.liveInstancesRQ.poll()) != null) {
            this.liveInstances.remove(r);
        }
        this.liveInstances.add(new WeakReference<Object>(instance, this.liveInstancesRQ));
    }

    public void runStaticInitializer() {
        if (this.hasBeenReloaded()) {
            this.liveVersion.runStaticInitializer();
        }
    }

    public boolean isResolved() {
        return (this.bits & 1) != 0;
    }

    public void setResolved() {
        this.bits |= 1;
    }

    public void setSuperclass(Class<?> superclazz) {
        this.superclazz = superclazz;
    }

    public ReloadableType getSuperRtype() {
        if (this.superRtype != null) {
            return this.superRtype;
        }
        if (this.superclazz == null) {
            return null;
        }
        ClassLoader superClassLoader = this.superclazz.getClassLoader();
        TypeRegistry superTypeRegistry = TypeRegistry.getTypeRegistryFor(superClassLoader);
        this.superRtype = superTypeRegistry.getReloadableType(this.superclazz);
        return this.superRtype;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FieldWalkDiscoveryResult {
        CHANGED_STOPNOW,
        UNCHANGED_STOPWALKINGNOW,
        DONTKNOW;

    }

    static class MergedRewrite {
        MergedRewrite() {
        }

        public static byte[] rewrite(ReloadableType rtype, byte[] bytes) {
            try {
                ClassReader fileReader = new ClassReader(bytes);
                ChainedAdapters classAdaptor = new ChainedAdapters(rtype);
                fileReader.accept(classAdaptor, 0);
                return classAdaptor.getBytes();
            }
            catch (MethodInvokerRewriter.DontRewriteException drex) {
                return bytes;
            }
        }

        static class ChainedAdapters
        extends ClassAdapter
        implements Constants {
            public ChainedAdapters(ReloadableType rtype) {
                super(new MethodInvokerRewriter.RewriteClassAdaptor(rtype.typeRegistry, new TypeRewriter.RewriteClassAdaptor(rtype, new ClassWriter(1))));
            }

            public byte[] getBytes() {
                MethodInvokerRewriter.RewriteClassAdaptor rca = (MethodInvokerRewriter.RewriteClassAdaptor)this.cv;
                if (rca.isEnum) {
                    int cfr_ignored_0 = rca.fieldcount;
                }
                TypeRewriter.RewriteClassAdaptor a = (TypeRewriter.RewriteClassAdaptor)rca.getClassVisitor();
                return ((ClassWriter)a.getClassVisitor()).toByteArray();
            }
        }
    }
}

