/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.loaded.ri;

import com.springsource.loaded.CurrentLiveVersion;
import com.springsource.loaded.MethodMember;
import com.springsource.loaded.ReloadableType;
import com.springsource.loaded.Utils;
import com.springsource.loaded.jvm.JVM;
import com.springsource.loaded.ri.Invoker;
import com.springsource.loaded.ri.ReloadableTypeMethodProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import sl.org.objectweb.asm.Type;

public abstract class ReloadedTypeInvoker
extends Invoker {
    ReloadableType rtype;
    private MethodMember methodMember;

    private ReloadedTypeInvoker(ReloadableTypeMethodProvider declaringType, MethodMember methodMember) {
        this.methodMember = methodMember;
        this.rtype = declaringType.getRType();
    }

    public abstract Object invoke(Object var1, Object ... var2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

    public Method createJavaMethod() {
        Class<?> clazz = this.rtype.getClazz();
        String name = this.methodMember.getName();
        String methodDescriptor = this.methodMember.getDescriptor();
        ClassLoader classLoader = this.rtype.getTypeRegistry().getClassLoader();
        try {
            Class<?>[] params = Utils.toParamClasses(methodDescriptor, classLoader);
            Class<?> returnType = Utils.toClass(Type.getReturnType(methodDescriptor), classLoader);
            Class<?>[] exceptions = Utils.slashedNamesToClasses(this.methodMember.getExceptions(), classLoader);
            return JVM.newMethod(clazz, name, params, returnType, exceptions, this.methodMember.getModifiers(), this.methodMember.getGenericSignature());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Couldn't create j.l.r.Method for " + clazz.getName() + "." + methodDescriptor, e);
        }
    }

    public int getModifiers() {
        return this.methodMember.getModifiers();
    }

    public String getName() {
        return this.methodMember.getName();
    }

    public String getMethodDescriptor() {
        return this.methodMember.getDescriptor();
    }

    public String getClassName() {
        return this.rtype.getName();
    }

    public static Invoker create(ReloadableTypeMethodProvider declaringType, final MethodMember methodMember) {
        if (Modifier.isStatic(methodMember.getModifiers())) {
            return new ReloadedTypeInvoker(declaringType, methodMember){

                public Object invoke(Object target, Object ... params) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    CurrentLiveVersion clv = this.rtype.getLiveVersion();
                    Method executor = clv.getExecutorMethod(methodMember);
                    return executor.invoke(target, params);
                }
            };
        }
        return new ReloadedTypeInvoker(declaringType, methodMember){

            public Object invoke(Object target, Object ... params) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                CurrentLiveVersion clv = this.rtype.getLiveVersion();
                Method executor = clv.getExecutorMethod(methodMember);
                if (params == null) {
                    return executor.invoke(null, target);
                }
                Object[] ps = new Object[params.length + 1];
                System.arraycopy(params, 0, ps, 1, params.length);
                ps[0] = target;
                return executor.invoke(null, ps);
            }
        };
    }

    /* synthetic */ ReloadedTypeInvoker(ReloadableTypeMethodProvider reloadableTypeMethodProvider, MethodMember methodMember, ReloadedTypeInvoker reloadedTypeInvoker) {
        this(reloadableTypeMethodProvider, methodMember);
    }
}

