/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.loaded.agent;

import com.springsource.loaded.FileChangeListener;
import com.springsource.loaded.agent.Watcher;
import java.io.File;

public class FileSystemWatcher {
    private Thread thread;
    private boolean threadRunning = false;
    private Watcher watchThread;

    public FileSystemWatcher(FileChangeListener listener, int typeRegistryId, String classloadername) {
        this.watchThread = new Watcher(listener, typeRegistryId, classloadername);
    }

    private void ensureWatchThreadRunning() {
        if (!this.threadRunning) {
            this.thread = new Thread(this.watchThread);
            this.thread.setDaemon(true);
            this.thread.start();
            this.watchThread.setThread(this.thread);
            this.watchThread.updateName();
            this.threadRunning = true;
        }
    }

    public void shutdown() {
        if (this.threadRunning) {
            this.watchThread.timeToStop();
        }
    }

    public void register(File fileToMonitor) {
        if (this.watchThread.addFile(fileToMonitor)) {
            this.ensureWatchThreadRunning();
            this.watchThread.updateName();
        }
    }

    public void setPaused(boolean shouldBePaused) {
        this.watchThread.paused = shouldBePaused;
    }
}

