/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.loaded;

import com.springsource.loaded.AbstractMember;
import com.springsource.loaded.Constants;
import java.lang.reflect.Method;

public class MethodMember
extends AbstractMember {
    static final MethodMember[] NONE = new MethodMember[0];
    protected final String[] exceptions;
    public int bits;
    public static final int BIT_CATCHER = 1;
    public static final int BIT_CLASH = 2;
    public static final int BIT_CATCHER_INTERFACE = 4;
    public static final int MADE_STATIC = 16;
    public static final int MADE_NON_STATIC = 32;
    public static final int VISIBILITY_CHANGE = 64;
    public static final int IS_NEW = 128;
    public static final int WAS_DELETED = 256;
    public static final int EXCEPTIONS_CHANGE = 512;
    public MethodMember original;
    public final String nameAndDescriptor;
    public Method cachedMethod;

    protected MethodMember(int modifiers, String name, String descriptor, String signature, String[] exceptions) {
        super(modifiers, name, descriptor, signature);
        this.exceptions = this.perhapsSortIfNecessary(exceptions);
        this.nameAndDescriptor = name + descriptor;
    }

    private String[] perhapsSortIfNecessary(String[] exceptions) {
        if (exceptions == null) {
            return Constants.NO_STRINGS;
        }
        return exceptions;
    }

    public String[] getExceptions() {
        return this.exceptions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("0x").append(Integer.toHexString(this.modifiers));
        sb.append(" ").append(this.name).append(this.descriptor);
        if (this.exceptions.length != 0) {
            sb.append(" throws ");
            String[] stringArray = this.exceptions;
            int n = this.exceptions.length;
            int n2 = 0;
            while (n2 < n) {
                String ex = stringArray[n2];
                sb.append(ex).append(" ");
                ++n2;
            }
        }
        return sb.toString().trim();
    }

    public String getParamDescriptor() {
        int pos = this.descriptor.length() - 1;
        while (pos > 0) {
            if (this.descriptor.charAt(pos) == ')') {
                return this.descriptor.substring(0, pos + 1);
            }
            --pos;
        }
        throw new IllegalStateException("Method has invalid descriptor: " + this.descriptor);
    }

    public boolean hasReturnValue() {
        return this.descriptor.charAt(this.descriptor.length() - 1) != 'V';
    }

    public boolean equals(Object other) {
        if (!(other instanceof MethodMember)) {
            return false;
        }
        MethodMember o = (MethodMember)other;
        if (!this.name.equals(o.name)) {
            return false;
        }
        if (this.modifiers != o.modifiers) {
            return false;
        }
        if (!this.descriptor.equals(o.descriptor)) {
            return false;
        }
        if (this.exceptions.length != o.exceptions.length) {
            return false;
        }
        if (this.signature == null && o.signature != null) {
            return false;
        }
        if (this.signature != null && o.signature == null) {
            return false;
        }
        if (this.signature != null && !this.signature.equals(o.signature)) {
            return false;
        }
        int i = 0;
        while (i < this.exceptions.length) {
            if (!this.exceptions[i].equals(o.exceptions[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int result = this.modifiers;
        result = result * 37 + this.name.hashCode();
        result = result * 37 + this.descriptor.hashCode();
        if (this.signature != null) {
            result = result * 37 + this.signature.hashCode();
        }
        if (this.exceptions != null) {
            String[] stringArray = this.exceptions;
            int n = this.exceptions.length;
            int n2 = 0;
            while (n2 < n) {
                String ex = stringArray[n2];
                result = result * 37 + ex.hashCode();
                ++n2;
            }
        }
        return result;
    }

    public MethodMember catcherCopyOf() {
        int newModifiers = this.modifiers & 0xFFFFFEFF;
        if (this.name.equals("clone") && (this.modifiers & 0x100) != 0) {
            newModifiers = 1;
        } else if ((this.modifiers & 4) != 0) {
            newModifiers = 1;
        } else if ((this.modifiers & 7) == 0) {
            newModifiers = 1;
        }
        MethodMember copy = new MethodMember(newModifiers, this.name, this.descriptor, this.signature, this.exceptions);
        copy.bits |= 1;
        return copy;
    }

    public MethodMember catcherCopyOfWithAbstractRemoved() {
        int newModifiers = this.modifiers & 0xFFFFFAFF;
        if (this.name.equals("clone") && (this.modifiers & 0x100) != 0) {
            newModifiers = 1;
        } else if ((this.modifiers & 4) != 0) {
            newModifiers = 1;
        } else if ((this.modifiers & 7) == 0) {
            newModifiers = 1;
        }
        MethodMember copy = new MethodMember(newModifiers, this.name, this.descriptor, this.signature, this.exceptions);
        copy.bits |= 1;
        copy.bits |= 4;
        return copy;
    }

    public boolean equalsApartFromModifiers(MethodMember other) {
        if (!(other instanceof MethodMember)) {
            return false;
        }
        MethodMember o = other;
        if (!this.name.equals(o.name)) {
            return false;
        }
        return this.descriptor.equals(o.descriptor);
    }

    public String getNameAndDescriptor() {
        return this.nameAndDescriptor;
    }

    public static boolean isClash(MethodMember method) {
        return (method.bits & 2) != 0;
    }

    public static boolean isCatcher(MethodMember method) {
        return (method.bits & 1) != 0;
    }

    public static boolean isCatcherForInterfaceMethod(MethodMember method) {
        return (method.bits & 4) != 0;
    }

    public static boolean isDeleted(MethodMember method) {
        return (method.bits & 0x100) != 0;
    }

    public Object bitsToString() {
        StringBuilder s = new StringBuilder();
        if ((this.bits & 1) != 0) {
            s.append("catcher ");
        }
        if ((this.bits & 2) != 0) {
            s.append("clash ");
        }
        if ((this.bits & 0x10) != 0) {
            s.append("made_static ");
        }
        if ((this.bits & 0x20) != 0) {
            s.append("made_non_static ");
        }
        if ((this.bits & 0x40) != 0) {
            s.append("vis_change ");
        }
        if ((this.bits & 0x80) != 0) {
            s.append("is_new ");
        }
        if ((this.bits & 0x100) != 0) {
            s.append("is_new ");
        }
        return "[" + s.toString().trim() + "]";
    }

    public boolean shouldReplace(MethodMember other) {
        if (!this.name.equals(other.name)) {
            return false;
        }
        return this.descriptor.equals(other.descriptor);
    }

    public boolean isConstructor() {
        return this.name.equals("<init>");
    }
}

