/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.loaded;

import com.springsource.loaded.Constants;
import com.springsource.loaded.FieldMember;
import com.springsource.loaded.MethodMember;
import com.springsource.loaded.TypeDescriptor;
import com.springsource.loaded.Utils;
import sl.org.objectweb.asm.Label;
import sl.org.objectweb.asm.MethodAdapter;
import sl.org.objectweb.asm.MethodVisitor;

class MethodCopier
extends MethodAdapter
implements Constants {
    private boolean isInterface;
    private String descriptor;
    private TypeDescriptor typeDescriptor;
    private String classname;
    private String suffix;
    private boolean hasFieldsRequiringAccessors;

    public MethodCopier(MethodVisitor mv, boolean isInterface, String descriptor, TypeDescriptor typeDescriptor, String classname, String suffix) {
        super(mv);
        this.isInterface = isInterface;
        this.descriptor = descriptor;
        this.typeDescriptor = typeDescriptor;
        this.classname = classname;
        this.suffix = suffix;
        this.hasFieldsRequiringAccessors = this.typeDescriptor.getFieldsRequiringAccessors().length != 0;
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (index == 0 && name.equals("this")) {
            super.visitLocalVariable("thiz", desc, signature, start, end, index);
        } else {
            super.visitLocalVariable(name, desc, signature, start, end, index);
        }
    }

    private FieldMember findFieldIfRequiresAccessorUsage(String owner, String name) {
        FieldMember[] fms;
        FieldMember[] fieldMemberArray = fms = this.typeDescriptor.getFieldsRequiringAccessors();
        int n = fms.length;
        int n2 = 0;
        while (n2 < n) {
            FieldMember fm = fieldMemberArray[n2];
            if (fm.getName().equals(name) && (owner.equals(this.classname) || this.isOneOfOurSupertypes(owner))) {
                return fm;
            }
            ++n2;
        }
        return null;
    }

    private boolean isOneOfOurSupertypes(String type) {
        String stypeName = this.typeDescriptor.getSupertypeName();
        while (stypeName != null) {
            if (stypeName.equals(type)) {
                return true;
            }
            stypeName = this.typeDescriptor.getTypeRegistry().getDescriptorFor(stypeName).getSupertypeName();
        }
        return false;
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        FieldMember fm;
        if (this.hasFieldsRequiringAccessors && (fm = this.findFieldIfRequiresAccessorUsage(owner, name)) != null) {
            switch (opcode) {
                case 180: {
                    this.mv.visitMethodInsn(182, this.classname, Utils.getProtectedFieldGetterName(name), "()" + desc);
                    return;
                }
                case 181: {
                    this.mv.visitMethodInsn(182, this.classname, Utils.getProtectedFieldSetterName(name), "(" + desc + ")V");
                    return;
                }
                case 178: {
                    this.mv.visitMethodInsn(184, this.classname, Utils.getProtectedFieldGetterName(name), "()" + desc);
                    return;
                }
                case 179: {
                    this.mv.visitMethodInsn(184, this.classname, Utils.getProtectedFieldSetterName(name), "(" + desc + ")V");
                    return;
                }
            }
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (opcode == 183 && name.charAt(0) != '<' && owner.equals(this.classname) && !name.startsWith("r$")) {
            String descriptor = Utils.insertExtraParameter(owner, desc);
            super.visitMethodInsn(184, Utils.getExecutorName(this.classname, this.suffix), name, descriptor);
        } else {
            MethodMember mm;
            boolean done = false;
            if (opcode == 184 && (mm = this.typeDescriptor.getByDescriptor(name, desc)) != null && mm.isPrivate()) {
                super.visitMethodInsn(184, Utils.getExecutorName(this.classname, this.suffix), name, desc);
                done = true;
            }
            if (!done) {
                super.visitMethodInsn(opcode, owner, name, desc);
            }
        }
    }

    public void visitEnd() {
        if (this.isInterface) {
            this.createDummyMethodBody();
            super.visitEnd();
        }
    }

    private void createDummyMethodBody() {
        block7: {
            int descriptorSize;
            block8: {
                Utils.ReturnType returnType;
                block6: {
                    returnType = Utils.getReturnTypeDescriptor(this.descriptor);
                    descriptorSize = Utils.getSize(this.descriptor);
                    if (!returnType.isVoid()) break block6;
                    super.visitInsn(177);
                    super.visitMaxs(1, descriptorSize);
                    break block7;
                }
                if (!returnType.isPrimitive()) break block8;
                super.visitLdcInsn(0);
                switch (returnType.descriptor.charAt(0)) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        super.visitInsn(172);
                        super.visitMaxs(2, descriptorSize);
                        break block7;
                    }
                    case 'D': {
                        super.visitInsn(175);
                        super.visitMaxs(3, descriptorSize);
                        break block7;
                    }
                    case 'F': {
                        super.visitInsn(174);
                        super.visitMaxs(2, descriptorSize);
                        break block7;
                    }
                    case 'J': {
                        super.visitInsn(173);
                        super.visitMaxs(3, descriptorSize);
                        break block7;
                    }
                    default: {
                        throw new IllegalStateException(returnType.descriptor);
                    }
                }
            }
            super.visitInsn(1);
            super.visitInsn(176);
            super.visitMaxs(1, descriptorSize);
        }
    }
}

