/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.loaded;

import com.springsource.loaded.Constants;
import com.springsource.loaded.ConstructorCopier;
import com.springsource.loaded.MethodCopier;
import com.springsource.loaded.MethodMember;
import com.springsource.loaded.ReloadableType;
import com.springsource.loaded.TypeDescriptor;
import com.springsource.loaded.TypeRegistry;
import com.springsource.loaded.Utils;
import java.lang.reflect.Modifier;
import sl.org.objectweb.asm.AnnotationVisitor;
import sl.org.objectweb.asm.Attribute;
import sl.org.objectweb.asm.ClassReader;
import sl.org.objectweb.asm.ClassVisitor;
import sl.org.objectweb.asm.ClassWriter;
import sl.org.objectweb.asm.FieldVisitor;
import sl.org.objectweb.asm.MethodVisitor;

public class ExecutorBuilder {
    private TypeRegistry typeRegistry;

    ExecutorBuilder(TypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    public byte[] createFor(ReloadableType reloadableType, String versionstamp, TypeDescriptor typeDescriptor, byte[] newVersionData) {
        if (typeDescriptor == null) {
            typeDescriptor = this.typeRegistry.getExtractor().extract(newVersionData, true);
        }
        ClassReader fileReader = new ClassReader(newVersionData);
        ExecutorBuilderVisitor executorVisitor = new ExecutorBuilderVisitor(reloadableType.getSlashedName(), versionstamp, typeDescriptor);
        fileReader.accept(executorVisitor, 0);
        return executorVisitor.getBytes();
    }

    static class ExecutorBuilderVisitor
    implements ClassVisitor,
    Constants {
        private ClassWriter cw = new ClassWriter(0);
        private String classname;
        private String suffix;
        protected TypeDescriptor typeDescriptor;

        public ExecutorBuilderVisitor(String classname, String suffix, TypeDescriptor typeDescriptor) {
            this.classname = classname;
            this.suffix = suffix;
            this.typeDescriptor = typeDescriptor;
        }

        public byte[] getBytes() {
            return this.cw.toByteArray();
        }

        public void visit(int version, int flags, String name, String signature, String superclassName, String[] interfaceNames) {
            this.cw.visit(version, 1, Utils.getExecutorName(this.classname, this.suffix), null, "java/lang/Object", null);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationVisitor av = this.cw.visitAnnotation(desc, visible);
            return new CopyingAnnotationVisitor(av);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return this.cw.visitField(access, name, desc, signature, value);
        }

        public MethodVisitor visitMethod(int flags, String name, String descriptor, String signature, String[] exceptions) {
            if (!Utils.isInitializer(name)) {
                if (!Modifier.isStatic(flags)) {
                    descriptor = Utils.insertExtraParameter(this.classname, descriptor);
                    MethodVisitor mv = this.cw.visitMethod(9, name, descriptor, signature, exceptions);
                    return new MethodCopier(mv, this.typeDescriptor.isInterface(), descriptor, this.typeDescriptor, this.classname, this.suffix);
                }
                MethodMember method = this.typeDescriptor.getByDescriptor(name, descriptor);
                if (MethodMember.isClash(method)) {
                    name = "__" + name;
                }
                MethodVisitor mv = this.cw.visitMethod(9, name, descriptor, signature, exceptions);
                return new MethodCopier(mv, this.typeDescriptor.isInterface(), descriptor, this.typeDescriptor, this.classname, this.suffix);
            }
            if (name.charAt(1) != 'c') {
                descriptor = Utils.insertExtraParameter(this.classname, descriptor);
                MethodVisitor mv = this.cw.visitMethod(9, "___init___", descriptor, signature, exceptions);
                ConstructorCopier cc = new ConstructorCopier(mv, this.typeDescriptor, this.suffix, this.classname);
                return cc;
            }
            MethodVisitor mv = this.cw.visitMethod(9, "___clinit___", descriptor, signature, exceptions);
            return new MethodCopier(mv, this.typeDescriptor.isInterface(), descriptor, this.typeDescriptor, this.classname, this.suffix);
        }

        public void visitSource(String sourcefile, String debug) {
            this.cw.visitSource(sourcefile, debug);
        }

        public void visitOuterClass(String arg0, String arg1, String arg2) {
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitEnd() {
        }

        public void visitInnerClass(String arg0, String arg1, String arg2, int arg3) {
        }

        private static class CopyingAnnotationVisitor
        implements AnnotationVisitor {
            private AnnotationVisitor av;

            public CopyingAnnotationVisitor(AnnotationVisitor av) {
                this.av = av;
            }

            public void visit(String name, Object value) {
                this.av.visit(name, value);
            }

            public AnnotationVisitor visitAnnotation(String name, String desc) {
                AnnotationVisitor localav = this.av.visitAnnotation(name, desc);
                return new CopyingAnnotationVisitor(localav);
            }

            public AnnotationVisitor visitArray(String name) {
                AnnotationVisitor localav = this.av.visitArray(name);
                return new CopyingAnnotationVisitor(localav);
            }

            public void visitEnd() {
                this.av.visitEnd();
            }

            public void visitEnum(String name, String desc, String value) {
                this.av.visitEnum(name, desc, value);
            }
        }
    }
}

