/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.cli.support;

import grails.build.logging.GrailsConsole;
import grails.util.BuildSettings;
import grails.util.GrailsNameUtils;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.util.AntBuilder;
import java.io.File;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.LogLevel;
import org.codehaus.gant.GantBinding;
import org.codehaus.groovy.grails.cli.api.BaseSettingsApi;
import org.codehaus.groovy.grails.cli.logging.GrailsConsoleAntBuilder;
import org.codehaus.groovy.grails.cli.logging.GrailsConsoleBuildListener;
import org.codehaus.groovy.grails.cli.parsing.CommandLine;
import org.codehaus.groovy.grails.cli.support.GrailsBuildEventListener;
import org.codehaus.groovy.grails.cli.support.PluginPathDiscoverySupport;

public class ScriptBindingInitializer {
    private static final Pattern pluginDescriptorPattern = Pattern.compile("^(\\S+)GrailsPlugin.groovy$");
    public static final String GRAILS_SCRIPT = "grailsScript";
    public static final String GRAILS_CONSOLE = "grailsConsole";
    public static final String GRAILS_SETTINGS = "grailsSettings";
    public static final String BASEDIR = "basedir";
    public static final String SCAFFOLD_DIR = "scaffoldDir";
    public static final String BASE_FILE = "baseFile";
    public static final String BASE_NAME = "baseName";
    public static final String GRAILS_HOME = "grailsHome";
    public static final String GRAILS_VERSION = "grailsVersion";
    public static final String USER_HOME = "userHome";
    public static final String GRAILS_ENV = "grailsEnv";
    private BuildSettings settings;
    private PluginPathDiscoverySupport pluginPathSupport;
    private boolean isInteractive;
    private CommandLine commandLine;
    private URLClassLoader classLoader;

    public ScriptBindingInitializer(CommandLine commandLine, URLClassLoader classLoader, BuildSettings settings, PluginPathDiscoverySupport pluginPathSupport, boolean interactive) {
        this.commandLine = commandLine;
        this.settings = settings;
        this.pluginPathSupport = pluginPathSupport;
        this.isInteractive = interactive;
        this.classLoader = classLoader;
    }

    public GantBinding initBinding(GantBinding binding, String scriptName) {
        Closure c = this.settings.getGrailsScriptClosure();
        c.setDelegate((Object)binding);
        LinkedHashMap<String, Object> argsMap = new LinkedHashMap<String, Object>(this.commandLine.getUndeclaredOptions());
        argsMap.put("params", this.commandLine.getRemainingArgs());
        binding.setVariable("argsMap", argsMap);
        binding.setVariable("args", (Object)this.commandLine.getRemainingArgsLineSeparated());
        binding.setVariable(GRAILS_SCRIPT, (Object)c);
        GrailsConsole grailsConsole = GrailsConsole.getInstance();
        binding.setVariable(GRAILS_CONSOLE, (Object)grailsConsole);
        binding.setVariable(GRAILS_SETTINGS, (Object)this.settings);
        File basedir = this.settings.getBaseDir();
        String baseDirPath = basedir.getPath();
        binding.setVariable(BASEDIR, (Object)baseDirPath);
        binding.setVariable(SCAFFOLD_DIR, (Object)(baseDirPath + "/web-app/WEB-INF/templates/scaffolding"));
        binding.setVariable(BASE_FILE, (Object)basedir);
        binding.setVariable(BASE_NAME, (Object)basedir.getName());
        binding.setVariable(GRAILS_HOME, this.settings.getGrailsHome() != null ? this.settings.getGrailsHome().getPath() : null);
        binding.setVariable(GRAILS_VERSION, (Object)this.settings.getGrailsVersion());
        binding.setVariable(USER_HOME, (Object)this.settings.getUserHome());
        binding.setVariable(GRAILS_ENV, (Object)this.settings.getGrailsEnv());
        binding.setVariable("defaultEnv", (Object)this.settings.getDefaultEnv());
        binding.setVariable("buildConfig", (Object)this.settings.getConfig());
        binding.setVariable("rootLoader", (Object)this.settings.getRootLoader());
        binding.setVariable("configFile", (Object)new File(baseDirPath + "/grails-app/conf/Config.groovy"));
        String grailsWork = this.settings.getGrailsWorkDir().getPath();
        binding.setVariable("grailsWorkDir", (Object)grailsWork);
        binding.setVariable("projectWorkDir", (Object)this.settings.getProjectWorkDir().getPath());
        binding.setVariable("projectTargetDir", (Object)this.settings.getProjectTargetDir());
        binding.setVariable("classesDir", (Object)this.settings.getClassesDir());
        binding.setVariable("pluginClassesDir", (Object)this.settings.getPluginClassesDir());
        binding.setVariable("grailsTmp", (Object)(grailsWork + "/tmp"));
        binding.setVariable("classesDirPath", (Object)this.settings.getClassesDir().getPath());
        binding.setVariable("pluginClassesDirPath", (Object)this.settings.getPluginClassesDir().getPath());
        binding.setVariable("testDirPath", (Object)this.settings.getTestClassesDir().getPath());
        String resourcesDir = this.settings.getResourcesDir().getPath();
        binding.setVariable("resourcesDirPath", (Object)resourcesDir);
        binding.setVariable("webXmlFile", (Object)this.settings.getWebXmlLocation());
        binding.setVariable("pluginsDirPath", (Object)this.settings.getProjectPluginsDir().getPath());
        binding.setVariable("globalPluginsDirPath", (Object)this.settings.getGlobalPluginsDir().getPath());
        binding.setVariable("Ant", binding.getVariable("ant"));
        GroovyClassLoader eventsClassLoader = new GroovyClassLoader((ClassLoader)this.classLoader);
        GrailsBuildEventListener buildEventListener = new GrailsBuildEventListener(eventsClassLoader, (Binding)binding, this.settings);
        binding.setVariable("eventsClassLoader", (Object)eventsClassLoader);
        binding.setVariable("eventListener", (Object)buildEventListener);
        binding.addBuildListener((BuildListener)buildEventListener);
        BaseSettingsApi cla = new BaseSettingsApi(this.settings, buildEventListener, this.isInteractive);
        if (scriptName.equals("RunApp")) {
            cla.enableUaa();
        }
        cla.makeApiAvailableToScripts(binding, cla);
        cla.makeApiAvailableToScripts(binding, cla.getPluginSettings());
        this.setUIListener(binding);
        try {
            ArrayList<File> descriptors = new ArrayList<File>();
            File desc = this.pluginPathSupport.getPluginDescriptor(basedir);
            if (desc != null) {
                descriptors.add(desc);
            }
            for (File dir : this.pluginPathSupport.listKnownPluginDirs()) {
                File pluginDescriptor = this.pluginPathSupport.getPluginDescriptor(dir);
                if (pluginDescriptor != null) {
                    descriptors.add(pluginDescriptor);
                    continue;
                }
                grailsConsole.log("Cannot find plugin descriptor for path '" + dir.getPath() + "'.");
            }
            for (File file : descriptors) {
                Matcher matcher = pluginDescriptorPattern.matcher(file.getName());
                matcher.find();
                String pluginName = GrailsNameUtils.getPropertyName(matcher.group(1));
                binding.setVariable(pluginName + "PluginDir", (Object)file.getParentFile());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return binding;
    }

    private void setUIListener(GantBinding binding) {
        AntBuilder ant = (AntBuilder)binding.getVariable("ant");
        Project project = ant.getProject();
        project.getBuildListeners().clear();
        GrailsConsoleAntBuilder.addGrailsConsoleBuildListener(project);
        GrailsConsole instance = GrailsConsole.getInstance();
        project.addBuildListener((BuildListener)new GrailsConsoleBuildListener(instance));
        if (!instance.isVerbose()) {
            for (Object buildListener : project.getBuildListeners()) {
                if (!(buildListener instanceof BuildLogger)) continue;
                ((BuildLogger)buildListener).setMessageOutputLevel(LogLevel.ERR.getLevel());
            }
        }
    }
}

