/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.types;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.gradle.internal.classpath.types.InstrumentationTypeRegistry;

public class ExternalPluginsInstrumentationTypeRegistry
implements InstrumentationTypeRegistry {
    private static final String GRADLE_CORE_PACKAGE_PREFIX = "org/gradle/";
    private final InstrumentationTypeRegistry gradleCoreInstrumentationTypeRegistry;
    private final Map<String, Set<String>> directSuperTypes;
    private final Map<String, Set<String>> instrumentedSuperTypes = new ConcurrentHashMap<String, Set<String>>();

    public ExternalPluginsInstrumentationTypeRegistry(Map<String, Set<String>> directSuperTypes, InstrumentationTypeRegistry gradleCoreInstrumentationTypeRegistry) {
        this.directSuperTypes = ImmutableMap.copyOf(directSuperTypes);
        this.gradleCoreInstrumentationTypeRegistry = gradleCoreInstrumentationTypeRegistry;
    }

    @Override
    public Set<String> getSuperTypes(String type) {
        Set<String> superTypes = Collections.emptySet();
        if (type.startsWith(GRADLE_CORE_PACKAGE_PREFIX)) {
            superTypes = this.gradleCoreInstrumentationTypeRegistry.getSuperTypes(type);
        }
        if (!superTypes.isEmpty()) {
            return superTypes;
        }
        superTypes = this.instrumentedSuperTypes.get(type);
        return superTypes != null ? superTypes : this.computeAndCacheInstrumentedSuperTypes(type, new HashSet<String>());
    }

    private Set<String> computeAndCacheInstrumentedSuperTypes(String type, Set<String> visited) {
        Set<String> computedInstrumentedSuperTypes = this.instrumentedSuperTypes.get(type);
        if (computedInstrumentedSuperTypes == null) {
            computedInstrumentedSuperTypes = this.computeInstrumentedSuperTypes(type, visited);
            this.instrumentedSuperTypes.put(type, computedInstrumentedSuperTypes);
        }
        return computedInstrumentedSuperTypes;
    }

    private Set<String> computeInstrumentedSuperTypes(String type, Set<String> visited) {
        Set<String> superTypes = visited.add(type) ? this.computeSuperTypesWithRecursiveCaching(type, visited) : this.computeSuperTypesWithoutRecursiveCaching(type);
        return superTypes.stream().filter(superType -> superType.startsWith(GRADLE_CORE_PACKAGE_PREFIX)).collect(Collectors.toSet());
    }

    private Set<String> computeSuperTypesWithRecursiveCaching(String type, Set<String> visited) {
        HashSet<String> collected = new HashSet<String>();
        collected.add(type);
        for (String superType : this.getDirectSuperTypes(type)) {
            if (!collected.add(superType)) continue;
            collected.addAll(this.computeAndCacheInstrumentedSuperTypes(superType, visited));
        }
        return collected;
    }

    private Set<String> computeSuperTypesWithoutRecursiveCaching(String type) {
        ArrayDeque<String> superTypes = new ArrayDeque<String>(this.getDirectSuperTypes(type));
        HashSet<String> collected = new HashSet<String>();
        collected.add(type);
        while (!superTypes.isEmpty()) {
            String superType = (String)superTypes.poll();
            if (!collected.add(superType)) continue;
            superTypes.addAll(this.getDirectSuperTypes(superType));
        }
        return collected;
    }

    private Set<String> getDirectSuperTypes(String type) {
        Set<String> superTypes = this.directSuperTypes.getOrDefault(type, Collections.emptySet());
        if (!superTypes.isEmpty() || !type.startsWith(GRADLE_CORE_PACKAGE_PREFIX)) {
            return superTypes;
        }
        return this.gradleCoreInstrumentationTypeRegistry.getSuperTypes(type);
    }

    @Override
    public boolean isEmpty() {
        return this.directSuperTypes.isEmpty() && this.gradleCoreInstrumentationTypeRegistry.isEmpty();
    }
}

