/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeMergingException;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.AttributeValueIsolator;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.DefaultImmutableAttributesContainer;
import org.gradle.api.internal.attributes.DefaultMutableAttributeContainer;
import org.gradle.api.internal.attributes.HierarchicalMutableAttributeContainer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.UsageCompatibilityHandler;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.api.internal.provider.PropertyFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.isolation.IsolatableFactory;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class DefaultAttributesFactory
implements AttributesFactory {
    private final AttributeValueIsolator attributeValueIsolator;
    private final PropertyFactory propertyFactory;
    private final ImmutableAttributes root;
    private final Map<ImmutableAttributes, ImmutableList<DefaultImmutableAttributesContainer>> children;
    private final UsageCompatibilityHandler usageCompatibilityHandler;

    public DefaultAttributesFactory(AttributeValueIsolator attributeValueIsolator, IsolatableFactory isolatableFactory, NamedObjectInstantiator instantiator, PropertyFactory propertyFactory) {
        this.attributeValueIsolator = attributeValueIsolator;
        this.propertyFactory = propertyFactory;
        this.root = ImmutableAttributes.EMPTY;
        this.children = new ConcurrentHashMap<ImmutableAttributes, ImmutableList<DefaultImmutableAttributesContainer>>();
        this.usageCompatibilityHandler = new UsageCompatibilityHandler(isolatableFactory, instantiator);
    }

    public int size() {
        return this.children.size();
    }

    @Override
    public AttributeContainerInternal mutable() {
        return new DefaultMutableAttributeContainer(this, this.attributeValueIsolator, this.propertyFactory);
    }

    @Override
    public AttributeContainerInternal mutable(AttributeContainerInternal fallback) {
        return this.join(fallback, new DefaultMutableAttributeContainer(this, this.attributeValueIsolator, this.propertyFactory));
    }

    @Override
    public AttributeContainerInternal join(AttributeContainerInternal fallback, AttributeContainerInternal primary) {
        return new HierarchicalMutableAttributeContainer(this, fallback, primary);
    }

    @Override
    public <T> ImmutableAttributes of(Attribute<T> key, T value) {
        return this.concat(this.root, key, value);
    }

    @Override
    public <T> ImmutableAttributes concat(ImmutableAttributes node, Attribute<T> key, @Nullable T value) {
        return this.concat(node, key, this.attributeValueIsolator.isolate(value));
    }

    @Override
    public <T> ImmutableAttributes concat(ImmutableAttributes node, Attribute<T> key, Isolatable<T> value) {
        if (key.equals((Object)Usage.USAGE_ATTRIBUTE) || key.getName().equals(Usage.USAGE_ATTRIBUTE.getName())) {
            return this.usageCompatibilityHandler.doConcat(this, node, key, value);
        }
        return this.doConcatIsolatable(node, key, value);
    }

    ImmutableAttributes doConcatIsolatable(ImmutableAttributes node, Attribute<?> key, Isolatable<?> value) {
        DefaultImmutableAttributesContainer child;
        this.assertAttributeNotAlreadyPresentFast(node, key);
        ImmutableList cachedChildren = this.children.get(node);
        if (cachedChildren != null && (child = DefaultAttributesFactory.findChild(cachedChildren, key, value)) != null) {
            return child;
        }
        cachedChildren = this.children.compute(node, (k, nodeChildren) -> {
            DefaultImmutableAttributesContainer child;
            if (nodeChildren != null) {
                child = DefaultAttributesFactory.findChild((ImmutableList<DefaultImmutableAttributesContainer>)nodeChildren, key, value);
                if (child != null) {
                    return nodeChildren;
                }
            } else {
                nodeChildren = ImmutableList.of();
            }
            child = new DefaultImmutableAttributesContainer((DefaultImmutableAttributesContainer)node, key, value);
            return DefaultAttributesFactory.concatChild((ImmutableList<DefaultImmutableAttributesContainer>)nodeChildren, child);
        });
        return Objects.requireNonNull(DefaultAttributesFactory.findChild((ImmutableList<DefaultImmutableAttributesContainer>)cachedChildren, key, value));
    }

    private static @Nullable DefaultImmutableAttributesContainer findChild(ImmutableList<DefaultImmutableAttributesContainer> nodeChildren, Attribute<?> key, Isolatable<?> value) {
        for (DefaultImmutableAttributesContainer child : nodeChildren) {
            if (!child.attribute.equals(key) || !child.value.equals(value)) continue;
            return child;
        }
        return null;
    }

    private static ImmutableList<DefaultImmutableAttributesContainer> concatChild(ImmutableList<DefaultImmutableAttributesContainer> nodeChildren, DefaultImmutableAttributesContainer child) {
        return ImmutableList.builderWithExpectedSize((int)(nodeChildren.size() + 1)).addAll(nodeChildren).add((Object)child).build();
    }

    @Override
    public ImmutableAttributes concat(ImmutableAttributes fallback, ImmutableAttributes primary) {
        if (fallback == ImmutableAttributes.EMPTY) {
            return primary;
        }
        if (primary == ImmutableAttributes.EMPTY) {
            return fallback;
        }
        ImmutableAttributes current = primary;
        for (Attribute attribute : fallback.keySet()) {
            if (current.findEntry(attribute.getName()).isPresent()) continue;
            if (fallback instanceof DefaultImmutableAttributesContainer) {
                current = this.doConcatIsolatable(current, attribute, ((DefaultImmutableAttributesContainer)fallback).getIsolatableAttribute(attribute));
                continue;
            }
            current = this.concat(current, (Attribute)Cast.uncheckedNonnullCast((Object)attribute), fallback.getAttribute(attribute));
        }
        return current;
    }

    @Override
    public ImmutableAttributes safeConcat(ImmutableAttributes attributes1, ImmutableAttributes attributes2) throws AttributeMergingException {
        if (attributes1 == ImmutableAttributes.EMPTY) {
            return attributes2;
        }
        if (attributes2 == ImmutableAttributes.EMPTY) {
            return attributes1;
        }
        ImmutableAttributes current = attributes2;
        for (Attribute attribute : attributes1.keySet()) {
            Object existingAttribute;
            Object currentAttribute;
            AttributeValue<?> entry = current.findEntry(attribute.getName());
            if (entry.isPresent() && !(currentAttribute = entry.get()).equals(existingAttribute = attributes1.getAttribute(attribute))) {
                throw new AttributeMergingException(attribute, existingAttribute, currentAttribute, this.buildSameNameDifferentTypeErrorMsg(attribute, attributes2.findAttribute(attribute.getName())));
            }
            if (attributes1 instanceof DefaultImmutableAttributesContainer) {
                current = this.doConcatIsolatable(current, attribute, ((DefaultImmutableAttributesContainer)attributes1).getIsolatableAttribute(attribute));
                continue;
            }
            current = this.concat(current, (Attribute)Cast.uncheckedNonnullCast((Object)attribute), attributes1.getAttribute(attribute));
        }
        return current;
    }

    @Override
    public ImmutableAttributes fromMap(Map<Attribute<?>, Isolatable<?>> attributes) {
        ImmutableAttributes result = ImmutableAttributes.EMPTY;
        for (Map.Entry<Attribute<?>, Isolatable<?>> entry : attributes.entrySet()) {
            result = this.uncheckedConcat(result, entry.getKey(), entry.getValue());
        }
        return result;
    }

    private <T> ImmutableAttributes uncheckedConcat(ImmutableAttributes attributes, Attribute<T> key, Isolatable<?> value) {
        Isolatable castValue = (Isolatable)Cast.uncheckedCast(value);
        return this.concat(attributes, key, castValue);
    }

    public void assertAttributeNotAlreadyPresent(AttributeContainer container, Attribute<?> key) {
        for (Attribute attribute : container.keySet()) {
            String name = key.getName();
            if (!attribute.getName().equals(name) || attribute.getType() == key.getType()) continue;
            throw new IllegalArgumentException(this.buildSameNameDifferentTypeErrorMsg(key, attribute));
        }
    }

    private @NonNull String buildSameNameDifferentTypeErrorMsg(Attribute<?> newAttribute, Attribute<?> oldAttribute) {
        return "Cannot have two attributes with the same name but different types. This container already has an attribute named '" + newAttribute.getName() + "' of type '" + oldAttribute.getType().getName() + "' and you are trying to store another one of type '" + newAttribute.getType().getName() + "'";
    }

    private void assertAttributeNotAlreadyPresentFast(ImmutableAttributes container, Attribute<?> key) {
        if (container.findEntry(key.getName()) != AttributeValue.MISSING) {
            this.assertAttributeNotAlreadyPresent(container, key);
        }
    }
}

