/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.jvm.Jvm;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.JavaDebugOptions;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.ProcessForkOptions;
import org.gradle.process.internal.DefaultJavaDebugOptions;
import org.gradle.process.internal.DefaultProcessForkOptions;
import org.gradle.process.internal.EffectiveJavaForkOptions;
import org.gradle.process.internal.JavaForkOptionsInternal;
import org.gradle.process.internal.JvmDebugSpec;
import org.gradle.process.internal.JvmOptions;
import org.jspecify.annotations.Nullable;

public class DefaultJavaForkOptions
extends DefaultProcessForkOptions
implements JavaForkOptionsInternal {
    private final JvmOptions options;
    private final FileCollectionFactory fileCollectionFactory;
    private final JavaDebugOptions debugOptions;
    private List<CommandLineArgumentProvider> jvmArgumentProviders;

    @Inject
    public DefaultJavaForkOptions(ObjectFactory objectFactory, PathToFileResolver resolver, FileCollectionFactory fileCollectionFactory) {
        super(resolver);
        this.fileCollectionFactory = fileCollectionFactory;
        this.debugOptions = (JavaDebugOptions)objectFactory.newInstance(DefaultJavaDebugOptions.class, new Object[]{objectFactory});
        this.options = new JvmOptions(fileCollectionFactory, new JvmDebugSpec.JavaDebugOptionsBackedSpec(this.debugOptions));
    }

    public List<String> getAllJvmArgs() {
        if (DefaultJavaForkOptions.hasJvmArgumentProviders(this)) {
            JvmOptions copy = this.options.createCopy(this.fileCollectionFactory);
            for (CommandLineArgumentProvider jvmArgumentProvider : this.jvmArgumentProviders) {
                copy.jvmArgs(jvmArgumentProvider.asArguments());
            }
            return copy.getAllJvmArgs();
        }
        return this.options.getAllJvmArgs();
    }

    public void setAllJvmArgs(List<String> arguments) {
        this.options.setAllJvmArgs(arguments);
        if (DefaultJavaForkOptions.hasJvmArgumentProviders(this)) {
            this.jvmArgumentProviders.clear();
        }
    }

    public void setAllJvmArgs(Iterable<?> arguments) {
        this.options.setAllJvmArgs(arguments);
        if (DefaultJavaForkOptions.hasJvmArgumentProviders(this)) {
            this.jvmArgumentProviders.clear();
        }
    }

    public List<String> getJvmArgs() {
        return this.options.getJvmArgs();
    }

    public void setJvmArgs(List<String> arguments) {
        this.options.setJvmArgs(arguments);
    }

    public void setJvmArgs(Iterable<?> arguments) {
        this.options.setJvmArgs(arguments);
    }

    public JavaForkOptions jvmArgs(Iterable<?> arguments) {
        this.options.jvmArgs(arguments);
        return this;
    }

    public JavaForkOptions jvmArgs(Object ... arguments) {
        this.jvmArgs(Arrays.asList(arguments));
        return this;
    }

    public List<CommandLineArgumentProvider> getJvmArgumentProviders() {
        if (this.jvmArgumentProviders == null) {
            this.jvmArgumentProviders = new ArrayList<CommandLineArgumentProvider>();
        }
        return this.jvmArgumentProviders;
    }

    public Map<String, @Nullable Object> getSystemProperties() {
        return this.options.getMutableSystemProperties();
    }

    public void setSystemProperties(Map<String, ? extends @Nullable Object> properties) {
        this.options.setSystemProperties(properties);
    }

    public JavaForkOptions systemProperties(Map<String, ? extends @Nullable Object> properties) {
        this.options.systemProperties(properties);
        return this;
    }

    public JavaForkOptions systemProperty(String name, @Nullable Object value) {
        this.options.systemProperty(name, value);
        return this;
    }

    public FileCollection getBootstrapClasspath() {
        return this.options.getBootstrapClasspath();
    }

    public void setBootstrapClasspath(FileCollection classpath) {
        this.options.setBootstrapClasspath(classpath);
    }

    public JavaForkOptions bootstrapClasspath(Object ... classpath) {
        this.options.bootstrapClasspath(classpath);
        return this;
    }

    public String getMinHeapSize() {
        return this.options.getMinHeapSize();
    }

    public void setMinHeapSize(String heapSize) {
        this.options.setMinHeapSize(heapSize);
    }

    public String getMaxHeapSize() {
        return this.options.getMaxHeapSize();
    }

    public void setMaxHeapSize(String heapSize) {
        this.options.setMaxHeapSize(heapSize);
    }

    public String getDefaultCharacterEncoding() {
        return this.options.getDefaultCharacterEncoding();
    }

    public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
        this.options.setDefaultCharacterEncoding(defaultCharacterEncoding);
    }

    public boolean getEnableAssertions() {
        return this.options.getEnableAssertions();
    }

    public void setEnableAssertions(boolean enabled) {
        this.options.setEnableAssertions(enabled);
    }

    public boolean getDebug() {
        return this.options.getDebug();
    }

    public void setDebug(boolean enabled) {
        this.options.setDebug(enabled);
    }

    public JavaDebugOptions getDebugOptions() {
        return this.debugOptions;
    }

    public void debugOptions(Action<JavaDebugOptions> action) {
        action.execute((Object)this.getDebugOptions());
    }

    @Override
    protected Map<String, ?> getInheritableEnvironment() {
        return Jvm.getInheritableEnvironmentVariables(super.getInheritableEnvironment());
    }

    public JavaForkOptions copyTo(JavaForkOptions target) {
        super.copyTo((ProcessForkOptions)target);
        this.options.copyTo(target);
        if (this.jvmArgumentProviders != null) {
            for (CommandLineArgumentProvider jvmArgumentProvider : this.jvmArgumentProviders) {
                target.jvmArgs(jvmArgumentProvider.asArguments());
            }
        }
        return this;
    }

    @Override
    public void checkDebugConfiguration(Iterable<?> arguments) {
        this.options.checkDebugConfiguration(arguments);
    }

    @Override
    public EffectiveJavaForkOptions toEffectiveJavaForkOptions(FileCollectionFactory fileCollectionFactory) {
        JvmOptions copy = this.options.createCopy(fileCollectionFactory);
        if (this.jvmArgumentProviders != null) {
            for (CommandLineArgumentProvider jvmArgumentProvider : this.jvmArgumentProviders) {
                copy.jvmArgs(jvmArgumentProvider.asArguments());
            }
        }
        return new EffectiveJavaForkOptions(this.getExecutable(), this.getWorkingDir(), this.getEnvironment(), copy);
    }

    @Override
    public void setExtraJvmArgs(Iterable<?> arguments) {
        this.options.setExtraJvmArgs(arguments);
    }

    @Override
    public Iterable<?> getExtraJvmArgs() {
        return this.options.getExtraJvmArgs();
    }

    private static boolean hasJvmArgumentProviders(DefaultJavaForkOptions forkOptions) {
        return !DefaultJavaForkOptions.isNullOrEmpty(forkOptions.jvmArgumentProviders);
    }

    private static <T> boolean isNullOrEmpty(List<T> list) {
        return list == null || list.isEmpty();
    }
}

