/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.internal.file.AbstractOpaqueFileCollection;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.DefaultCompositeFileTree;
import org.gradle.api.internal.file.EmptyFileCollection;
import org.gradle.api.internal.file.FileCollectionExecutionTimeValue;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.FileCollectionAdapter;
import org.gradle.api.internal.file.collections.FileCollectionObservationListener;
import org.gradle.api.internal.file.collections.FileTreeAdapter;
import org.gradle.api.internal.file.collections.GeneratedSingletonFileTree;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.UnpackingVisitor;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.provider.ProviderResolutionStrategy;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;

public class DefaultFileCollectionFactory
implements FileCollectionFactory {
    private final PathToFileResolver fileResolver;
    private final TaskDependencyFactory taskDependencyFactory;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final Factory<PatternSet> patternSetFactory;
    private final PropertyHost propertyHost;
    private final FileSystem fileSystem;
    private final FileCollectionObservationListener listener;

    public DefaultFileCollectionFactory(PathToFileResolver fileResolver, TaskDependencyFactory taskDependencyFactory, DirectoryFileTreeFactory directoryFileTreeFactory, Factory<PatternSet> patternSetFactory, PropertyHost propertyHost, FileSystem fileSystem) {
        this(fileResolver, taskDependencyFactory, directoryFileTreeFactory, patternSetFactory, propertyHost, fileSystem, fileCollection -> {});
    }

    private DefaultFileCollectionFactory(PathToFileResolver fileResolver, TaskDependencyFactory taskDependencyFactory, DirectoryFileTreeFactory directoryFileTreeFactory, Factory<PatternSet> patternSetFactory, PropertyHost propertyHost, FileSystem fileSystem, FileCollectionObservationListener listener) {
        this.fileResolver = fileResolver;
        this.taskDependencyFactory = taskDependencyFactory;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.patternSetFactory = patternSetFactory;
        this.propertyHost = propertyHost;
        this.fileSystem = fileSystem;
        this.listener = listener;
    }

    @Override
    public FileCollectionFactory withResolver(PathToFileResolver fileResolver) {
        if (fileResolver == this.fileResolver) {
            return this;
        }
        return new DefaultFileCollectionFactory(fileResolver, this.taskDependencyFactory, this.directoryFileTreeFactory, this.patternSetFactory, this.propertyHost, this.fileSystem, this.listener);
    }

    @Override
    public FileCollectionFactory forChildScope(FileCollectionObservationListener listener) {
        return new DefaultFileCollectionFactory(this.fileResolver, this.taskDependencyFactory, this.directoryFileTreeFactory, this.patternSetFactory, this.propertyHost, this.fileSystem, listener);
    }

    @Override
    public FileCollectionFactory forChildScope(PathToFileResolver fileResolver, TaskDependencyFactory taskDependencyFactory, PropertyHost propertyHost) {
        return new DefaultFileCollectionFactory(fileResolver, taskDependencyFactory, this.directoryFileTreeFactory, this.patternSetFactory, propertyHost, this.fileSystem, this.listener);
    }

    @Override
    public ConfigurableFileCollection configurableFiles() {
        return new DefaultConfigurableFileCollection(null, this.fileResolver, this.taskDependencyFactory, this.patternSetFactory, this.propertyHost);
    }

    @Override
    public ConfigurableFileCollection configurableFiles(String displayName) {
        return new DefaultConfigurableFileCollection(displayName, this.fileResolver, this.taskDependencyFactory, this.patternSetFactory, this.propertyHost);
    }

    @Override
    public ConfigurableFileTree fileTree() {
        return new DefaultConfigurableFileTree(this.fileResolver, this.listener, this.patternSetFactory, this.taskDependencyFactory, this.directoryFileTreeFactory);
    }

    @Override
    public FileTreeInternal treeOf(List<? extends FileTreeInternal> fileTrees) {
        if (fileTrees.isEmpty()) {
            return FileCollectionFactory.emptyTree();
        }
        if (fileTrees.size() == 1) {
            return fileTrees.get(0);
        }
        return new DefaultCompositeFileTree(this.taskDependencyFactory, this.patternSetFactory, (List<? extends FileTreeInternal>)ImmutableList.copyOf(fileTrees));
    }

    @Override
    public FileTreeInternal treeOf(MinimalFileTree tree) {
        return new FileTreeAdapter(tree, this.listener, this.taskDependencyFactory, this.patternSetFactory);
    }

    @Override
    public FileCollectionInternal create(final TaskDependency builtBy, MinimalFileSet contents) {
        return new FileCollectionAdapter(contents, this.taskDependencyFactory, this.patternSetFactory){

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                super.visitDependencies(context);
                context.add((Object)builtBy);
            }
        };
    }

    @Override
    public FileCollectionInternal create(MinimalFileSet contents, final Consumer<? super TaskDependencyResolveContext> visitTaskDependencies) {
        return new FileCollectionAdapter(contents, this.taskDependencyFactory, this.patternSetFactory){

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                super.visitDependencies(context);
                visitTaskDependencies.accept(context);
            }
        };
    }

    @Override
    public FileCollectionInternal create(MinimalFileSet contents) {
        return new FileCollectionAdapter(contents, this.taskDependencyFactory, this.patternSetFactory);
    }

    @Override
    public FileCollectionInternal resolving(String displayName, Object sources) {
        return this.resolving(displayName, ProviderResolutionStrategy.REQUIRE_PRESENT, sources);
    }

    @Override
    public FileCollectionInternal resolvingLeniently(String displayName, Object sources) {
        return this.resolving(displayName, ProviderResolutionStrategy.ALLOW_ABSENT, sources);
    }

    private FileCollectionInternal resolving(String displayName, ProviderResolutionStrategy providerResolutionStrategy, Object sources) {
        if (this.isEmptyArray(sources)) {
            return FileCollectionFactory.empty(displayName);
        }
        return new ResolvingFileCollection(displayName, this.fileResolver, this.taskDependencyFactory, this.patternSetFactory, providerResolutionStrategy, sources);
    }

    @Override
    public FileCollectionInternal resolving(Object sources) {
        return this.resolving(ProviderResolutionStrategy.REQUIRE_PRESENT, sources);
    }

    @Override
    public FileCollectionInternal resolvingLeniently(Object sources) {
        return this.resolving(ProviderResolutionStrategy.ALLOW_ABSENT, sources);
    }

    private FileCollectionInternal resolving(ProviderResolutionStrategy providerResolutionStrategy, Object sources) {
        if (sources instanceof FileCollectionInternal) {
            return (FileCollectionInternal)sources;
        }
        if (this.isEmptyArray(sources)) {
            return FileCollectionFactory.empty();
        }
        return this.resolving("file collection", providerResolutionStrategy, sources);
    }

    @Override
    public FileCollectionInternal fixed(File ... files) {
        if (files.length == 0) {
            return FileCollectionFactory.empty();
        }
        return this.fixed("file collection", files);
    }

    @Override
    public FileCollectionInternal fixed(String displayName, File ... files) {
        if (files.length == 0) {
            return new EmptyFileCollection(displayName);
        }
        return new FixedFileCollection(displayName, this.taskDependencyFactory, this.patternSetFactory, (ImmutableSet<File>)ImmutableSet.copyOf((Object[])files));
    }

    @Override
    public FileCollectionInternal fixed(Collection<File> files) {
        if (files.isEmpty()) {
            return FileCollectionFactory.empty();
        }
        return this.fixed("file collection", files);
    }

    @Override
    public FileCollectionInternal fixed(String displayName, Collection<File> files) {
        if (files.isEmpty()) {
            return new EmptyFileCollection(displayName);
        }
        return new FixedFileCollection(displayName, this.taskDependencyFactory, this.patternSetFactory, (ImmutableSet<File>)ImmutableSet.copyOf(files));
    }

    @Override
    public FileTreeInternal generated(Factory<File> tmpDir, String fileName, Action<File> fileGenerationListener, Action<OutputStream> contentWriter) {
        return new FileTreeAdapter(new GeneratedSingletonFileTree(tmpDir, fileName, fileGenerationListener, contentWriter, this.fileSystem), this.listener, this.taskDependencyFactory, this.patternSetFactory);
    }

    private boolean isEmptyArray(Object sources) {
        return sources.getClass().isArray() && Array.getLength(sources) == 0;
    }

    private static class ResolvingFileCollection
    extends CompositeFileCollection {
        private final String displayName;
        private final PathToFileResolver resolver;
        private final Object source;
        private final ProviderResolutionStrategy providerResolutionStrategy;

        public ResolvingFileCollection(String displayName, PathToFileResolver resolver, TaskDependencyFactory taskDependencyFactory, Factory<PatternSet> patternSetFactory, ProviderResolutionStrategy providerResolutionStrategy, Object source) {
            super(taskDependencyFactory, patternSetFactory);
            this.displayName = displayName;
            this.resolver = resolver;
            this.source = source;
            this.providerResolutionStrategy = providerResolutionStrategy;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        protected void visitChildren(Consumer<FileCollectionInternal> visitor) {
            UnpackingVisitor nested = new UnpackingVisitor(visitor, this.resolver, this.taskDependencyFactory, (Factory<PatternSet>)this.patternSetFactory, this.providerResolutionStrategy, true);
            nested.add(this.source);
        }

        @Override
        protected void appendContents(TreeFormatter formatter) {
            formatter.node("source");
            formatter.startChildren();
            this.appendItem(formatter, this.source);
            formatter.endChildren();
        }

        private void appendItem(TreeFormatter formatter, Object item) {
            if (item instanceof FileCollectionInternal) {
                ((FileCollectionInternal)item).describeContents(formatter);
            } else if (item instanceof ArrayList) {
                for (Object child : (List)item) {
                    this.appendItem(formatter, child);
                }
            } else {
                formatter.node(item + " (class: " + item.getClass().getName() + ")");
            }
        }
    }

    private static final class FixedFileCollection
    extends AbstractOpaqueFileCollection {
        private final String displayName;
        private final ImmutableSet<File> files;

        public FixedFileCollection(String displayName, TaskDependencyFactory taskDependencyFactory, Factory<PatternSet> patternSetFactory, ImmutableSet<File> files) {
            super(taskDependencyFactory, patternSetFactory);
            this.displayName = displayName;
            this.files = files;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        protected Set<File> getIntrinsicFiles() {
            return this.files;
        }

        @Override
        public Optional<FileCollectionExecutionTimeValue> calculateExecutionTimeValue() {
            return Optional.of(new FixedExecutionTimeValue(this.displayName, this.files));
        }

        private static class FixedExecutionTimeValue
        implements FileCollectionExecutionTimeValue {
            private final String displayName;
            private final ImmutableSet<File> files;

            public FixedExecutionTimeValue(String displayName, ImmutableSet<File> files) {
                this.displayName = displayName;
                this.files = files;
            }

            @Override
            public FileCollectionInternal toFileCollection(FileCollectionFactory fileCollectionFactory) {
                return fileCollectionFactory.fixed(this.displayName, (Collection<File>)this.files);
            }
        }
    }
}

