/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.MultipleBuildOperationFailures;
import org.gradle.internal.work.WorkerLeaseService;

class DefaultBuildOperationQueue<T extends BuildOperation>
implements BuildOperationQueue<T> {
    private final boolean allowAccessToProjectState;
    private final WorkerLeaseService workerLeases;
    private final Executor executor;
    private final BuildOperationQueue.QueueWorker<T> queueWorker;
    private String logLocation;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition workAvailable = this.lock.newCondition();
    private final Condition operationsComplete = this.lock.newCondition();
    private QueueState queueState = QueueState.Working;
    private int workerCount;
    private int pendingOperations;
    private final Deque<T> workQueue = new LinkedList<T>();
    private final LinkedList<Throwable> failures = new LinkedList();

    DefaultBuildOperationQueue(boolean allowAccessToProjectState, WorkerLeaseService workerLeases, Executor executor, BuildOperationQueue.QueueWorker<T> queueWorker) {
        this.allowAccessToProjectState = allowAccessToProjectState;
        this.workerLeases = workerLeases;
        this.executor = executor;
        this.queueWorker = queueWorker;
    }

    public void add(T operation) {
        this.lock.lock();
        try {
            if (this.queueState == QueueState.Done) {
                throw new IllegalStateException("BuildOperationQueue cannot be reused once it has completed.");
            }
            if (this.queueState == QueueState.Cancelled) {
                return;
            }
            this.workQueue.add(operation);
            ++this.pendingOperations;
            this.workAvailable.signalAll();
            if (this.workerCount == 0 || this.workerCount < this.workerLeases.getMaxWorkerCount() - 1) {
                this.executor.execute(new WorkerRunnable());
                ++this.workerCount;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void cancel() {
        this.lock.lock();
        try {
            if (this.queueState == QueueState.Cancelled || this.queueState == QueueState.Done) {
                return;
            }
            this.queueState = QueueState.Cancelled;
            this.completeOperations(this.workQueue.size());
            this.workQueue.clear();
            this.workAvailable.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void waitForCompletion() throws MultipleBuildOperationFailures {
        this.signalNoMoreWork();
        new WorkerRunnable().run();
        this.waitForWorkToComplete();
    }

    private void signalNoMoreWork() {
        this.lock.lock();
        try {
            if (this.queueState == QueueState.Done) {
                throw new IllegalStateException("Cannot wait for completion more than once.");
            }
            this.queueState = QueueState.Finishing;
            this.workAvailable.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void waitForWorkToComplete() {
        this.lock.lock();
        try {
            if (this.pendingOperations == 0) {
                this.markFinished();
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        this.workerLeases.blocking(() -> {
            this.lock.lock();
            try {
                while (this.pendingOperations > 0) {
                    try {
                        this.operationsComplete.await();
                    }
                    catch (InterruptedException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                }
                this.markFinished();
            }
            finally {
                this.lock.unlock();
            }
        });
    }

    private void markFinished() {
        this.queueState = QueueState.Done;
        if (!this.failures.isEmpty()) {
            throw new MultipleBuildOperationFailures(this.failures, this.logLocation);
        }
    }

    private void addFailure(Throwable failure) {
        this.lock.lock();
        try {
            this.failures.add(failure);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void completeOperations(int count) {
        this.lock.lock();
        try {
            this.pendingOperations -= count;
            this.operationsComplete.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setLogLocation(String logLocation) {
        this.logLocation = logLocation;
    }

    private class WorkerRunnable
    implements Runnable {
        private WorkerRunnable() {
        }

        @Override
        public void run() {
            try {
                Object operation;
                while ((operation = this.waitForNextOperation()) != null) {
                    this.runBatch(operation);
                }
            }
            catch (Throwable t) {
                DefaultBuildOperationQueue.this.addFailure(t);
            }
            finally {
                this.shutDown();
            }
        }

        @Nullable
        private T waitForNextOperation() {
            DefaultBuildOperationQueue.this.lock.lock();
            try {
                while (DefaultBuildOperationQueue.this.queueState == QueueState.Working && DefaultBuildOperationQueue.this.workQueue.isEmpty()) {
                    try {
                        DefaultBuildOperationQueue.this.workAvailable.await();
                    }
                    catch (InterruptedException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                }
                Object t = this.getNextOperation();
                return t;
            }
            finally {
                DefaultBuildOperationQueue.this.lock.unlock();
            }
        }

        private void runBatch(T firstOperation) {
            DefaultBuildOperationQueue.this.completeOperations((Integer)DefaultBuildOperationQueue.this.workerLeases.runAsWorkerThread(() -> {
                if (DefaultBuildOperationQueue.this.allowAccessToProjectState) {
                    return this.doRunBatch(firstOperation);
                }
                return (Integer)DefaultBuildOperationQueue.this.workerLeases.whileDisallowingProjectLockChanges(() -> this.doRunBatch(firstOperation));
            }));
        }

        private int doRunBatch(T firstOperation) {
            int operationCount = 0;
            Object operation = firstOperation;
            while (operation != null) {
                if (DefaultBuildOperationQueue.this.queueState == QueueState.Cancelled) {
                    return ++operationCount;
                }
                this.runOperation(operation);
                ++operationCount;
                operation = this.getNextOperation();
            }
            return operationCount;
        }

        @Nullable
        private T getNextOperation() {
            DefaultBuildOperationQueue.this.lock.lock();
            try {
                BuildOperation buildOperation = (BuildOperation)DefaultBuildOperationQueue.this.workQueue.pollFirst();
                return buildOperation;
            }
            finally {
                DefaultBuildOperationQueue.this.lock.unlock();
            }
        }

        private void runOperation(T operation) {
            try {
                DefaultBuildOperationQueue.this.queueWorker.execute(operation);
            }
            catch (Throwable t) {
                DefaultBuildOperationQueue.this.addFailure(t);
            }
        }

        private void shutDown() {
            DefaultBuildOperationQueue.this.lock.lock();
            try {
                DefaultBuildOperationQueue.this.workerCount--;
            }
            finally {
                DefaultBuildOperationQueue.this.lock.unlock();
            }
        }
    }

    private static enum QueueState {
        Working,
        Finishing,
        Cancelled,
        Done;

    }
}

