/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.model;

import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.Project;
import org.gradle.api.internal.initialization.RootScriptDomainObjectContext;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.WorkNodeAction;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Try;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.ModelContainer;
import org.gradle.internal.model.ValueCalculator;
import org.gradle.internal.resources.ProjectLeaseRegistry;
import org.gradle.internal.service.ServiceLookupException;

@ThreadSafe
public class CalculatedValueContainer<T, S extends ValueCalculator<? extends T>>
implements CalculatedValue<T>,
WorkNodeAction {
    private final DisplayName displayName;
    @Nullable
    private volatile CalculationState<T, S> calculationState;
    @Nullable
    private volatile Try<T> result;

    CalculatedValueContainer(DisplayName displayName, S supplier, ProjectLeaseRegistry projectLeaseRegistry, NodeExecutionContext defaultContext) {
        this.displayName = displayName;
        this.calculationState = new CalculationState(displayName, supplier, projectLeaseRegistry, defaultContext);
    }

    CalculatedValueContainer(DisplayName displayName, T value) {
        this.displayName = displayName;
        this.result = Try.successful(value);
    }

    public String toString() {
        return this.displayName.getCapitalizedDisplayName();
    }

    public T get() throws IllegalStateException {
        return (T)this.getValue().get();
    }

    public Try<T> getValue() throws IllegalStateException {
        Try<T> result = this.result;
        if (result == null) {
            throw new IllegalStateException(String.format("Value for %s has not been calculated yet.", this.displayName));
        }
        return result;
    }

    public boolean isFinalized() {
        return this.result != null;
    }

    public S getSupplier() throws IllegalStateException {
        CalculationState<T, S> calculationState = this.calculationState;
        if (calculationState == null) {
            throw new IllegalStateException(String.format("Value for %s has already been calculated.", this.displayName));
        }
        return calculationState.supplier;
    }

    public boolean usesMutableProjectState() {
        CalculationState<T, S> calculationState = this.calculationState;
        if (calculationState != null) {
            return calculationState.supplier.usesMutableProjectState();
        }
        return false;
    }

    public Project getOwningProject() {
        CalculationState<T, S> calculationState = this.calculationState;
        if (calculationState != null) {
            return calculationState.supplier.getOwningProject();
        }
        return null;
    }

    public ModelContainer<?> getResourceToLock() {
        CalculationState<T, S> calculationState = this.calculationState;
        if (calculationState != null && calculationState.supplier.usesMutableProjectState()) {
            return calculationState.supplier.getOwningProject().getOwner();
        }
        return RootScriptDomainObjectContext.INSTANCE.getModel();
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        CalculationState<T, S> calculationState = this.calculationState;
        if (calculationState != null) {
            calculationState.supplier.visitDependencies(context);
        }
    }

    @Nullable
    public WorkNodeAction getPreExecutionNode() {
        CalculationState<T, S> calculationState = this.calculationState;
        if (calculationState != null) {
            return calculationState.supplier.getPreExecutionAction();
        }
        return null;
    }

    public void run(NodeExecutionContext context) {
        this.finalizeIfNotAlready(context);
    }

    public void finalizeIfNotAlready() {
        this.finalizeIfNotAlready(null);
    }

    private void finalizeIfNotAlready(@Nullable NodeExecutionContext context) {
        CalculationState<T, S> calculationState = this.calculationState;
        if (calculationState == null) {
            return;
        }
        calculationState.attachValue(this, context);
    }

    private static class GlobalContext
    implements NodeExecutionContext {
        private final NodeExecutionContext delegate;

        public GlobalContext(NodeExecutionContext delegate) {
            this.delegate = delegate;
        }

        public <T> T getService(Class<T> type) throws ServiceLookupException {
            return (T)this.delegate.getService(type);
        }

        public boolean isPartOfExecutionGraph() {
            return false;
        }
    }

    private static class CalculationState<T, S extends ValueCalculator<? extends T>> {
        final ReentrantLock lock = new ReentrantLock();
        final DisplayName displayName;
        final S supplier;
        final ProjectLeaseRegistry projectLeaseRegistry;
        final NodeExecutionContext defaultContext;
        boolean done;

        public CalculationState(DisplayName displayName, S supplier, ProjectLeaseRegistry projectLeaseRegistry, NodeExecutionContext defaultContext) {
            this.displayName = displayName;
            this.supplier = supplier;
            this.projectLeaseRegistry = projectLeaseRegistry;
            this.defaultContext = defaultContext;
        }

        void attachValue(CalculatedValueContainer<T, ?> owner, @Nullable NodeExecutionContext context) {
            this.acquireLock();
            try {
                if (this.done) {
                    return;
                }
                this.done = true;
                ((CalculatedValueContainer)owner).result = Try.ofFailable(() -> {
                    NodeExecutionContext effectiveContext = context;
                    if (effectiveContext == null) {
                        effectiveContext = new GlobalContext(this.defaultContext);
                    }
                    return this.supplier.calculateValue(effectiveContext);
                });
                ((CalculatedValueContainer)owner).calculationState = null;
            }
            finally {
                this.releaseLock();
            }
        }

        private void acquireLock() {
            if (this.lock.tryLock()) {
                return;
            }
            this.projectLeaseRegistry.blocking(this.lock::lock);
        }

        private void releaseLock() {
            this.lock.unlock();
        }
    }
}

