/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.scala.tasks;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.JavaVersion;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.CompilerForkUtils;
import org.gradle.api.internal.tasks.compile.HasCompileOptions;
import org.gradle.api.internal.tasks.scala.DefaultScalaJavaJointCompileSpec;
import org.gradle.api.internal.tasks.scala.MinimalScalaCompileOptions;
import org.gradle.api.internal.tasks.scala.ScalaCompileSpec;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.LocalState;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.scala.IncrementalCompileOptions;
import org.gradle.api.tasks.scala.ScalaCompileOptions;
import org.gradle.internal.buildevents.BuildStartedTime;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.file.Deleter;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.scala.tasks.BaseScalaCompileOptions;
import org.gradle.language.scala.tasks.KeepAliveMode;
import org.gradle.util.internal.GFileUtils;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Abstract super-class, not to be instantiated directly")
public abstract class AbstractScalaCompile
extends AbstractCompile
implements HasCompileOptions {
    protected static final Logger LOGGER = Logging.getLogger(AbstractScalaCompile.class);
    private final BaseScalaCompileOptions scalaCompileOptions;
    private final CompileOptions compileOptions;
    private final RegularFileProperty analysisMappingFile;
    private final ConfigurableFileCollection analysisFiles;
    private final Property<JavaLauncher> javaLauncher;

    @Incubating
    protected AbstractScalaCompile() {
        ObjectFactory objectFactory = this.getObjectFactory();
        this.analysisMappingFile = objectFactory.fileProperty();
        this.analysisFiles = this.getProject().files(new Object[0]);
        this.compileOptions = (CompileOptions)objectFactory.newInstance(CompileOptions.class, new Object[0]);
        JavaToolchainService javaToolchainService = this.getJavaToolchainService();
        this.javaLauncher = objectFactory.property(JavaLauncher.class).convention(javaToolchainService.launcherFor(it -> {}));
        CompilerForkUtils.doNotCacheIfForkingViaExecutable((CompileOptions)this.compileOptions, (TaskOutputs)this.getOutputs());
        objectFactory = this.getObjectFactory();
        this.scalaCompileOptions = (BaseScalaCompileOptions)((Object)objectFactory.newInstance(ScalaCompileOptions.class, new Object[0]));
        this.scalaCompileOptions.setIncrementalOptions((IncrementalCompileOptions)objectFactory.newInstance(IncrementalCompileOptions.class, new Object[0]));
    }

    @Nested
    public BaseScalaCompileOptions getScalaCompileOptions() {
        return this.scalaCompileOptions;
    }

    @Nested
    public CompileOptions getOptions() {
        return this.compileOptions;
    }

    protected abstract Compiler<ScalaJavaJointCompileSpec> getCompiler(ScalaJavaJointCompileSpec var1);

    @TaskAction
    public void compile() {
        ScalaJavaJointCompileSpec spec = this.createSpec();
        this.configureIncrementalCompilation(spec);
        CleaningJavaCompiler compiler = this.getCompiler(spec);
        if (this.isNonIncrementalCompilation()) {
            compiler = new CleaningJavaCompiler(compiler, this.getOutputs(), this.getDeleter());
        }
        compiler.execute((CompileSpec)spec);
    }

    @Nested
    public Property<JavaLauncher> getJavaLauncher() {
        return this.javaLauncher;
    }

    private boolean isNonIncrementalCompilation() {
        File analysisFile = (File)this.getScalaCompileOptions().getIncrementalOptions().getAnalysisFile().getAsFile().get();
        if (!analysisFile.exists()) {
            LOGGER.info("Zinc is doing a full recompile since the analysis file doesn't exist");
            return true;
        }
        return false;
    }

    @Internal
    protected JavaInstallationMetadata getToolchain() {
        return (JavaInstallationMetadata)this.javaLauncher.map(JavaLauncher::getMetadata).get();
    }

    protected ScalaJavaJointCompileSpec createSpec() {
        File javaExecutable = ((JavaLauncher)this.getJavaLauncher().get()).getExecutablePath().getAsFile();
        DefaultScalaJavaJointCompileSpec spec = new DefaultScalaJavaJointCompileSpec(javaExecutable);
        spec.setSourceFiles(this.getSource().getFiles());
        spec.setDestinationDir((File)this.getDestinationDirectory().getAsFile().get());
        spec.setWorkingDir(this.getProjectLayout().getProjectDirectory().getAsFile());
        spec.setTempDir(this.getTemporaryDir());
        Object effectiveClasspath = this.scalaCompileOptions.getKeepAliveMode().get() == KeepAliveMode.DAEMON ? this.getCachedClasspathTransformer().transform(DefaultClassPath.of((Iterable)this.getClasspath()), CachedClasspathTransformer.StandardTransform.None).getAsFiles() : ImmutableList.copyOf((Iterable)this.getClasspath());
        spec.setCompileClasspath((List)effectiveClasspath);
        this.configureCompatibilityOptions(spec);
        spec.setCompileOptions(this.getOptions());
        spec.setScalaCompileOptions(new MinimalScalaCompileOptions(this.scalaCompileOptions));
        spec.setAnnotationProcessorPath((List)(this.compileOptions.getAnnotationProcessorPath() == null ? ImmutableList.of() : ImmutableList.copyOf((Iterable)this.compileOptions.getAnnotationProcessorPath())));
        spec.setBuildStartTimestamp(((BuildStartedTime)this.getServices().get(BuildStartedTime.class)).getStartTime());
        return spec;
    }

    private void configureCompatibilityOptions(DefaultScalaJavaJointCompileSpec spec) {
        String targetCompatibility;
        String toolchainVersion = JavaVersion.toVersion((Object)this.getToolchain().getLanguageVersion().asInt()).toString();
        String sourceCompatibility = this.getSourceCompatibility();
        if (sourceCompatibility == null) {
            sourceCompatibility = toolchainVersion;
        }
        if ((targetCompatibility = this.getTargetCompatibility()) == null) {
            targetCompatibility = sourceCompatibility;
        }
        spec.setSourceCompatibility(sourceCompatibility);
        spec.setTargetCompatibility(targetCompatibility);
    }

    private void configureIncrementalCompilation(ScalaCompileSpec spec) {
        IncrementalCompileOptions incrementalOptions = this.scalaCompileOptions.getIncrementalOptions();
        File analysisFile = (File)incrementalOptions.getAnalysisFile().getAsFile().get();
        File classpathBackupDir = (File)incrementalOptions.getClassfileBackupDir().getAsFile().get();
        Map<File, File> globalAnalysisMap = this.resolveAnalysisMappingsForOtherProjects();
        spec.setAnalysisMap(globalAnalysisMap);
        spec.setAnalysisFile(analysisFile);
        spec.setClassfileBackupDir(classpathBackupDir);
        if (incrementalOptions.getPublishedCode().isPresent()) {
            File publishedCode = (File)incrementalOptions.getPublishedCode().getAsFile().get();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("scala-incremental Analysis file: {}", (Object)analysisFile);
                LOGGER.debug("scala-incremental Classfile backup dir: {}", (Object)classpathBackupDir);
                LOGGER.debug("scala-incremental Published code: {}", (Object)publishedCode);
            }
            File analysisMapping = (File)this.getAnalysisMappingFile().getAsFile().get();
            GFileUtils.writeFile((String)(publishedCode.getAbsolutePath() + "\n" + analysisFile.getAbsolutePath()), (File)analysisMapping);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("scala-incremental Analysis map: {}", globalAnalysisMap);
        }
    }

    private Map<File, File> resolveAnalysisMappingsForOtherProjects() {
        HashMap<File, File> analysisMap = new HashMap<File, File>();
        for (File mapping : this.analysisFiles.getFiles()) {
            if (!mapping.exists()) continue;
            try {
                List lines = Files.readLines((File)mapping, (Charset)Charset.defaultCharset());
                assert (lines.size() == 2);
                analysisMap.put(new File((String)lines.get(0)), new File((String)lines.get(1)));
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }
        return analysisMap;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    @Input
    protected String getJvmVersion() {
        if (this.javaLauncher.isPresent()) {
            return ((JavaLauncher)this.javaLauncher.get()).getMetadata().getLanguageVersion().toString();
        }
        return JavaVersion.current().getMajorVersion();
    }

    @Internal
    public ConfigurableFileCollection getAnalysisFiles() {
        return this.analysisFiles;
    }

    @LocalState
    public RegularFileProperty getAnalysisMappingFile() {
        return this.analysisMappingFile;
    }

    @Inject
    protected abstract Deleter getDeleter();

    @Inject
    protected abstract ProjectLayout getProjectLayout();

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    @Inject
    protected abstract JavaToolchainService getJavaToolchainService();

    @Inject
    protected abstract CachedClasspathTransformer getCachedClasspathTransformer();
}

