/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import java.util.List;
import java.util.Optional;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.exception.ConfigurationSelectionException;
import org.gradle.internal.component.resolution.failure.type.RequestedConfigurationNotFoundFailure;

public abstract class RequestedConfigurationNotFoundFailureDescriber
extends AbstractResolutionFailureDescriber<RequestedConfigurationNotFoundFailure> {
    public ConfigurationSelectionException describeFailure(RequestedConfigurationNotFoundFailure failure, Optional<AttributesSchemaInternal> schema) {
        String message = this.buildConfigurationNotFoundFailureMsg(failure);
        List<String> resolutions = this.buildResolutions(this.suggestReviewAlgorithm());
        return new ConfigurationSelectionException(message, failure, resolutions);
    }

    private String buildConfigurationNotFoundFailureMsg(RequestedConfigurationNotFoundFailure failure) {
        return String.format("A dependency was declared on configuration '%s' which is not declared in the descriptor for %s.", failure.getRequestedName(), failure.getRequestedComponentDisplayName());
    }
}

