/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure;

import java.util.Collection;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.capabilities.Capability;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;

public final class CapabilitiesDescriber {
    private CapabilitiesDescriber() {
    }

    public static String describeCapabilitiesWithTitle(ModuleVersionIdentifier targetComponentId, Collection<? extends Capability> capabilities) {
        StringBuilder sb = new StringBuilder("capabilit");
        if (capabilities.size() > 1) {
            sb.append("ies ");
            sb.append(CapabilitiesDescriber.describeCapabilities(targetComponentId, capabilities));
        } else {
            sb.append("y ").append(CapabilitiesDescriber.describeCapabilities(targetComponentId, capabilities));
        }
        return sb.toString();
    }

    public static String describeCapabilities(ModuleVersionIdentifier targetComponentId, Collection<? extends Capability> capabilities) {
        if (capabilities.isEmpty()) {
            return CapabilitiesDescriber.describeCapability((Capability)new DefaultImmutableCapability(targetComponentId.getGroup(), targetComponentId.getName(), targetComponentId.getVersion()));
        }
        return capabilities.stream().map(CapabilitiesDescriber::describeCapability).sorted().collect(Collectors.joining(" and "));
    }

    private static String describeCapability(Capability c) {
        String version = c.getVersion();
        if (version != null) {
            return c.getGroup() + ":" + c.getName() + ":" + c.getVersion();
        }
        return c.getGroup() + ":" + c.getName();
    }
}

