/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;

public class DefaultFileSystemLocationFingerprint
implements FileSystemLocationFingerprint {
    private final HashCode normalizedContentHash;
    private final String normalizedPath;

    public DefaultFileSystemLocationFingerprint(String normalizedPath, FileType type, HashCode contentHash) {
        this.normalizedContentHash = DefaultFileSystemLocationFingerprint.hashForType(type, contentHash);
        this.normalizedPath = normalizedPath;
    }

    private static HashCode hashForType(FileType fileType, HashCode hash) {
        switch (fileType) {
            case Directory: {
                return DIR_SIGNATURE;
            }
            case Missing: {
                return MISSING_FILE_SIGNATURE;
            }
            case RegularFile: {
                return hash;
            }
        }
        throw new IllegalStateException("Unknown file type: " + fileType);
    }

    public final void appendToHasher(Hasher hasher) {
        hasher.putString((CharSequence)this.getNormalizedPath());
        hasher.putHash(this.getNormalizedContentHash());
    }

    @Override
    public FileType getType() {
        if (this.normalizedContentHash == DIR_SIGNATURE) {
            return FileType.Directory;
        }
        if (this.normalizedContentHash == MISSING_FILE_SIGNATURE) {
            return FileType.Missing;
        }
        return FileType.RegularFile;
    }

    @Override
    public String getNormalizedPath() {
        return this.normalizedPath;
    }

    @Override
    public HashCode getNormalizedContentHash() {
        return this.normalizedContentHash;
    }

    @Override
    public final int compareTo(FileSystemLocationFingerprint o) {
        int result = this.getNormalizedPath().compareTo(o.getNormalizedPath());
        if (result == 0) {
            result = this.getNormalizedContentHash().compareTo((Object)o.getNormalizedContentHash());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultFileSystemLocationFingerprint that = (DefaultFileSystemLocationFingerprint)o;
        if (!this.normalizedContentHash.equals((Object)that.normalizedContentHash)) {
            return false;
        }
        return this.normalizedPath.equals(that.normalizedPath);
    }

    public int hashCode() {
        int result = this.normalizedContentHash.hashCode();
        result = 31 * result + this.normalizedPath.hashCode();
        return result;
    }

    public String toString() {
        return String.format("'%s' / %s", this.getNormalizedPath(), this.getHashOrTypeToDisplay());
    }

    private Object getHashOrTypeToDisplay() {
        switch (this.getType()) {
            case Directory: {
                return "DIR";
            }
            case Missing: {
                return "MISSING";
            }
        }
        return this.normalizedContentHash;
    }
}

